/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.LatentFunctionCall;
import lowentry.ue4.classes.sockets.SocketConnectionHandler;
import lowentry.ue4.classes.sockets.SocketConnectionListener;
import lowentry.ue4.classes.sockets.SocketFunctions;
import lowentry.ue4.classes.sockets.SocketMessageUdpType;
import lowentry.ue4.classes.sockets.SocketTasks;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.PyroClientUdp;

public class SocketConnection {
    protected static final int UDP_HANDSHAKE_INTERVAL_MS = 500;
    protected static final int UDP_PING_INTERVAL_MS = 10000;
    protected final PyroSelector selector;
    protected final InetSocketAddress address;
    protected final InetSocketAddress addressUdp;
    protected final SocketConnectionListener socketListener;
    protected final SimpleBlockingQueue<Runnable> tasks;
    protected PyroClient connection;
    protected volatile Object attachment;
    protected boolean isDisconnecting;
    protected PyroClientUdp connectionUdp;
    protected final ByteBuffer connectionUdpNetworkBuffer;
    protected int nextFunctionCallId = 0;
    protected final Map<Integer, InternalFunctionCall> functionCalls = new HashMap<Integer, InternalFunctionCall>();
    protected int nextLatentFunctionCallId = 0;
    protected final Map<Integer, InternalLatentFunctionCall> latentFunctionCalls = new HashMap<Integer, InternalLatentFunctionCall>();
    protected long lastFunctionCallTimeoutCheck = CachedTime.millisSinceStart();
    protected long lastUdpPingTime = CachedTime.millisSinceStart();

    public SocketConnection(String host, int portTcp, SocketConnectionListener listener) {
        this.socketListener = listener;
        this.tasks = null;
        this.selector = new PyroSelector();
        this.address = new InetSocketAddress(host, portTcp);
        this.addressUdp = null;
        this.connectionUdpNetworkBuffer = null;
    }

    public SocketConnection(InetSocketAddress endTcp, SocketConnectionListener listener) {
        this.socketListener = listener;
        this.tasks = null;
        this.selector = new PyroSelector();
        this.address = endTcp;
        this.addressUdp = null;
        this.connectionUdpNetworkBuffer = null;
    }

    public SocketConnection(String host, int portTcp, int portUdp, SocketConnectionListener listener) {
        this.socketListener = listener;
        this.tasks = null;
        this.selector = new PyroSelector();
        this.address = new InetSocketAddress(host, portTcp);
        this.addressUdp = portUdp <= 0 ? null : new InetSocketAddress(host, portUdp);
        this.connectionUdpNetworkBuffer = this.addressUdp == null ? null : ByteBuffer.allocate(524288);
    }

    public SocketConnection(InetSocketAddress endTcp, InetSocketAddress endUdp, SocketConnectionListener listener) {
        this.socketListener = listener;
        this.tasks = null;
        this.selector = new PyroSelector();
        this.address = endTcp;
        this.addressUdp = endUdp;
        this.connectionUdpNetworkBuffer = this.addressUdp == null ? null : ByteBuffer.allocate(524288);
    }

    public SocketConnection(String host, int portTcp, SocketConnectionListener listener, SimpleBlockingQueue<Runnable> tasks) {
        this.socketListener = listener;
        this.tasks = tasks;
        this.selector = new PyroSelector();
        this.address = new InetSocketAddress(host, portTcp);
        this.addressUdp = null;
        this.connectionUdpNetworkBuffer = null;
    }

    public SocketConnection(InetSocketAddress endTcp, SocketConnectionListener listener, SimpleBlockingQueue<Runnable> tasks) {
        this.socketListener = listener;
        this.tasks = tasks;
        this.selector = new PyroSelector();
        this.address = endTcp;
        this.addressUdp = null;
        this.connectionUdpNetworkBuffer = null;
    }

    public SocketConnection(String host, int portTcp, int portUdp, SocketConnectionListener listener, SimpleBlockingQueue<Runnable> tasks) {
        this.socketListener = listener;
        this.tasks = tasks;
        this.selector = new PyroSelector();
        this.address = new InetSocketAddress(host, portTcp);
        this.addressUdp = portUdp <= 0 ? null : new InetSocketAddress(host, portUdp);
        this.connectionUdpNetworkBuffer = this.addressUdp == null ? null : ByteBuffer.allocate(524288);
    }

    public SocketConnection(InetSocketAddress endTcp, InetSocketAddress endUdp, SocketConnectionListener listener, SimpleBlockingQueue<Runnable> tasks) {
        this.socketListener = listener;
        this.tasks = tasks;
        this.selector = new PyroSelector();
        this.address = endTcp;
        this.addressUdp = endUdp;
        this.connectionUdpNetworkBuffer = this.addressUdp == null ? null : ByteBuffer.allocate(524288);
    }

    public boolean connect() {
        this.selector.checkThread();
        if (this.connectionUdp != null) {
            this.connectionUdp.shutdown();
            this.connectionUdp = null;
        }
        if (this.connection != null) {
            this.connection.shutdown();
            this.connection = null;
        }
        this.failAllFunctionCalls();
        try {
            this.isDisconnecting = false;
            SocketConnectionHandler listener = this.createListener();
            this.connection = this.selector.connect(this.address, listener);
            if (this.connection == null) {
                return false;
            }
            while (listener.connectingStage == SocketConnectionHandler.ConnectingStage.WAITING_FOR_CONNECTION) {
                this.listen(1L);
            }
            if (listener.connectingStage == SocketConnectionHandler.ConnectingStage.UNCONNECTABLE || this.connection.isDisconnected()) {
                this.connection.shutdown();
                this.connection = null;
                return false;
            }
            if (this.isConnected()) {
                if (this.addressUdp == null) {
                    listener.skipUdpHandshake();
                    this.connection.write(ByteBuffer.wrap(LowEntry.mergeBytes({13, 10, 13, 10}, LowEntry.integerToBytes(0), LowEntry.integerToBytes(0))));
                } else {
                    this.connectionUdp = new PyroClientUdp(this.addressUdp, listener);
                    this.connection.write(ByteBuffer.wrap(LowEntry.mergeBytes({13, 10, 13, 10}, LowEntry.integerToBytes(this.addressUdp.getPort()), LowEntry.integerToBytes(this.getLocalPortUdp()))));
                    while (listener.connectingStage == SocketConnectionHandler.ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_ID) {
                        this.listen(1L);
                    }
                    if (listener.connectingStage == SocketConnectionHandler.ConnectingStage.UNCONNECTABLE || this.connection.isDisconnected()) {
                        this.connectionUdp.shutdown();
                        this.connectionUdp = null;
                        this.connection.shutdown();
                        this.connection = null;
                        return false;
                    }
                    byte[] handshakeUdpId = LowEntry.mergeBytes({1, (byte)listener.handshakeUdpId.length}, listener.handshakeUdpId);
                    long lastHandshakeSendTime = CachedTime.millisSinceStart() - 500L;
                    while (listener.connectingStage == SocketConnectionHandler.ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_RESPONSE) {
                        long time = CachedTime.millisSinceStart();
                        if (time - lastHandshakeSendTime < 500L) {
                            this.listen(1L);
                            continue;
                        }
                        lastHandshakeSendTime = time;
                        this.connectionUdp.write(ByteBuffer.wrap(handshakeUdpId));
                    }
                    if (listener.connectingStage == SocketConnectionHandler.ConnectingStage.UNCONNECTABLE || this.connection.isDisconnected()) {
                        this.connectionUdp.shutdown();
                        this.connectionUdp = null;
                        this.connection.shutdown();
                        this.connection = null;
                        return false;
                    }
                    this.connection.write(ByteBuffer.wrap(new byte[]{85}));
                }
            } else {
                throw new Exception();
            }
            listener.callConnected();
        }
        catch (Exception e) {
            if (this.connectionUdp != null) {
                this.connectionUdp.shutdown();
                this.connectionUdp = null;
            }
            if (this.connection != null) {
                this.connection.shutdown();
                this.connection = null;
            }
            return false;
        }
        return true;
    }

    protected SocketConnectionHandler createListener() {
        return new SocketConnectionHandler(this.socketListener, this);
    }

    public void listen() {
        this.listen(100L);
    }

    public void listen(long eventTimeout) {
        long lastTime;
        this.selector.checkThread();
        if (eventTimeout <= 10L) {
            this.pyroListen(eventTimeout);
            this.handleFunctionCallTimeouts();
            this.handleSendUdpPing();
            return;
        }
        long startTime = CachedTime.millisSinceStart();
        while (eventTimeout > 200L) {
            this.listen(200L);
            lastTime = CachedTime.millisSinceStart();
            eventTimeout -= lastTime - startTime;
            startTime = lastTime;
        }
        this.pyroListen(eventTimeout);
        lastTime = CachedTime.millisSinceStart();
        long timeSpend = lastTime - startTime;
        while (timeSpend < eventTimeout - 10L) {
            this.pyroListen(eventTimeout - timeSpend);
            long newTime = CachedTime.millisSinceStart();
            if (newTime == lastTime) continue;
            lastTime = newTime;
            timeSpend = lastTime - startTime;
        }
        this.handleFunctionCallTimeouts();
        this.handleSendUdpPing();
    }

    private void pyroListen(long eventTimeout) {
        if (this.connectionUdp != null) {
            for (long i = 1L; i <= eventTimeout; ++i) {
                try {
                    this.connectionUdp.listen(this.connectionUdpNetworkBuffer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.selector.select(1L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (long i = 1L; i <= eventTimeout; ++i) {
                try {
                    this.selector.select(1L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void threadSafeFailedFunctionCall(FunctionCallListener listener) {
        if (this.tasks == null) {
            if (this.selector.isNetworkThread()) {
                listener.failed(this);
            } else {
                this.selector.scheduleTask(new SocketTasks.FailedFunctionCallListener(listener, this));
            }
        } else {
            this.tasks.put(new SocketTasks.FailedFunctionCallListener(listener, this));
        }
    }

    protected void failedFunctionCall(FunctionCallListener listener) {
        if (this.tasks == null) {
            listener.failed(this);
        } else {
            this.tasks.put(new SocketTasks.FailedFunctionCallListener(listener, this));
        }
    }

    protected void receivedResponseFunctionCall(FunctionCallListener listener, byte[] bytes) {
        if (this.tasks == null) {
            listener.receivedResponse(this, bytes);
        } else {
            this.tasks.put(new SocketTasks.ReceivedResponseFunctionCallListener(listener, this, bytes));
        }
    }

    protected void threadSafeFailedLatentFunctionCall(LatentFunctionCallListener listener) {
        if (this.tasks == null) {
            if (this.selector.isNetworkThread()) {
                listener.failed(this);
            } else {
                this.selector.scheduleTask(new SocketTasks.FailedLatentFunctionCallListener(listener, this));
            }
        } else {
            this.tasks.put(new SocketTasks.FailedLatentFunctionCallListener(listener, this));
        }
    }

    protected void threadSafeCanceledLatentFunctionCall(LatentFunctionCallListener listener) {
        if (this.tasks == null) {
            if (this.selector.isNetworkThread()) {
                listener.canceled(this);
            } else {
                this.selector.scheduleTask(new SocketTasks.CanceledLatentFunctionCallListener(listener, this));
            }
        } else {
            this.tasks.put(new SocketTasks.CanceledLatentFunctionCallListener(listener, this));
        }
    }

    protected void failedLatentFunctionCall(LatentFunctionCallListener listener) {
        if (this.tasks == null) {
            listener.failed(this);
        } else {
            this.tasks.put(new SocketTasks.FailedLatentFunctionCallListener(listener, this));
        }
    }

    protected void canceledLatentFunctionCall(LatentFunctionCallListener listener) {
        if (this.tasks == null) {
            listener.canceled(this);
        } else {
            this.tasks.put(new SocketTasks.CanceledLatentFunctionCallListener(listener, this));
        }
    }

    protected void receivedResponseLatentFunctionCall(LatentFunctionCallListener listener, byte[] bytes) {
        if (this.tasks == null) {
            listener.receivedResponse(this, bytes);
        } else {
            this.tasks.put(new SocketTasks.ReceivedResponseLatentFunctionCallListener(listener, this, bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFunctionCallTimeouts() {
        Object functionCall;
        Map.Entry<Integer, Object> entry;
        long time = CachedTime.millisSinceStart();
        if (time - this.lastFunctionCallTimeoutCheck < 1000L) {
            return;
        }
        this.lastFunctionCallTimeoutCheck = time;
        LinkedList<Object> functionCallListeners = new LinkedList<Object>();
        Object object = this.functionCalls;
        synchronized (object) {
            Iterator<Map.Entry<Integer, InternalFunctionCall>> iterator = this.functionCalls.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                functionCall = entry.getValue();
                if (time - ((InternalFunctionCall)functionCall).timeoutTime < 0L) continue;
                iterator.remove();
                if (((InternalFunctionCall)functionCall).listener == null) continue;
                functionCallListeners.add(((InternalFunctionCall)functionCall).listener);
            }
        }
        for (FunctionCallListener functionCallListener : functionCallListeners) {
            this.failedFunctionCall(functionCallListener);
        }
        functionCallListeners = new LinkedList();
        object = this.latentFunctionCalls;
        synchronized (object) {
            Iterator<Map.Entry<Integer, InternalLatentFunctionCall>> iterator = this.latentFunctionCalls.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                functionCall = (InternalLatentFunctionCall)entry.getValue();
                if (time - ((InternalLatentFunctionCall)functionCall).timeoutTime < 0L) continue;
                iterator.remove();
                if (((InternalLatentFunctionCall)functionCall).listener == null) continue;
                functionCallListeners.add(functionCall);
            }
        }
        for (InternalLatentFunctionCall internalLatentFunctionCall : functionCallListeners) {
            if (internalLatentFunctionCall.latentAction != null) {
                internalLatentFunctionCall.latentAction.canceledByTimeout();
            }
            if (internalLatentFunctionCall.listener == null) continue;
            this.failedLatentFunctionCall(internalLatentFunctionCall.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failAllFunctionCalls() {
        Object functionCall;
        LinkedList<Object> functionCallListeners = new LinkedList<Object>();
        Object object = this.functionCalls;
        synchronized (object) {
            for (Map.Entry<Integer, InternalFunctionCall> entry : this.functionCalls.entrySet()) {
                functionCall = entry.getValue();
                if (((InternalFunctionCall)functionCall).listener == null) continue;
                functionCallListeners.add(((InternalFunctionCall)functionCall).listener);
            }
            this.functionCalls.clear();
        }
        for (FunctionCallListener functionCallListener : functionCallListeners) {
            this.failedFunctionCall(functionCallListener);
        }
        functionCallListeners = new LinkedList();
        object = this.latentFunctionCalls;
        synchronized (object) {
            for (Map.Entry<Integer, InternalLatentFunctionCall> entry : this.latentFunctionCalls.entrySet()) {
                functionCall = entry.getValue();
                if (((InternalLatentFunctionCall)functionCall).listener == null) continue;
                functionCallListeners.add(functionCall);
            }
            this.latentFunctionCalls.clear();
        }
        for (InternalLatentFunctionCall internalLatentFunctionCall : functionCallListeners) {
            if (internalLatentFunctionCall.latentAction != null) {
                internalLatentFunctionCall.latentAction.canceledByDisconnecting();
            }
            if (internalLatentFunctionCall.listener == null) continue;
            this.failedLatentFunctionCall(internalLatentFunctionCall.listener);
        }
    }

    protected void handleSendUdpPing() {
        if (this.connectionUdp == null) {
            return;
        }
        long time = CachedTime.millisSinceStart();
        if (time - this.lastUdpPingTime < 10000L) {
            return;
        }
        this.lastUdpPingTime = time;
        try {
            this.connectionUdp.write(ByteBuffer.wrap(SocketMessageUdpType.PING_BYTES));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int reserveFunctionCallId(InternalFunctionCall functionCall) {
        Map<Integer, InternalFunctionCall> map = this.functionCalls;
        synchronized (map) {
            do {
                if (this.nextFunctionCallId >= Integer.MAX_VALUE) {
                    this.nextFunctionCallId = 0;
                }
                ++this.nextFunctionCallId;
            } while (this.functionCalls.containsKey(this.nextFunctionCallId));
            int functionCallId = this.nextFunctionCallId;
            this.functionCalls.put(functionCallId, functionCall);
            return functionCallId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int reserveLatentFunctionCallId(InternalLatentFunctionCall functionCall) {
        Map<Integer, InternalLatentFunctionCall> map = this.latentFunctionCalls;
        synchronized (map) {
            do {
                if (this.nextLatentFunctionCallId >= Integer.MAX_VALUE) {
                    this.nextLatentFunctionCallId = 0;
                }
                ++this.nextLatentFunctionCallId;
            } while (this.latentFunctionCalls.containsKey(this.nextLatentFunctionCallId));
            int functionCallId = this.nextLatentFunctionCallId;
            this.latentFunctionCalls.put(functionCallId, functionCall);
            return functionCallId;
        }
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public InetSocketAddress getLocalAddress() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getRemoteAddress();
    }

    public int getLocalPortUdp() {
        if (this.connectionUdp == null) {
            return 0;
        }
        return this.connectionUdp.getLocalPort();
    }

    public void sendUnreliableMessage(byte[] ... bytes) {
        this.sendUnreliableMessage(LowEntry.mergeBytes(bytes));
    }

    public void sendUnreliableMessage(byte[] bytes) {
        if (this.selector.isNetworkThread()) {
            if (bytes == null) {
                this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true);
            } else {
                this.sendUnreliableMessageCode(ByteBuffer.wrap(bytes), true);
            }
        } else if (bytes == null) {
            this.selector.scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true));
        } else {
            this.selector.scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.wrap(bytes), true));
        }
    }

    public void sendUnreliableMessage(ByteBuffer bytes) {
        if (this.selector.isNetworkThread()) {
            if (bytes == null) {
                this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true);
            } else {
                this.sendUnreliableMessageCode(bytes, false);
            }
        } else if (bytes == null) {
            this.selector.scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true));
        } else {
            ByteBuffer b = LowEntry.cloneByteBuffer(bytes, false);
            this.selector.scheduleTask(() -> this.sendUnreliableMessageCode(b, true));
        }
    }

    protected void sendUnreliableMessageCode(ByteBuffer bytes, boolean clonedBytes) {
        if (!this.isConnectedUdp()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + bytes.remaining());
        buffer.put((byte)2);
        buffer.put(bytes);
        buffer.flip();
        this.connectionUdp.write(buffer);
    }

    public void sendMessage(byte[] ... bytes) {
        this.sendMessage(LowEntry.mergeBytes(bytes));
    }

    public void sendMessage(byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.selector.isNetworkThread()) {
            this.sendMessageCode(b);
        } else {
            this.selector.scheduleTask(() -> this.sendMessageCode(b));
        }
    }

    protected void sendMessageCode(byte[] bytes) {
        if (!this.isConnected()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(bytes.length));
        buffer.put((byte)1);
        SocketFunctions.putUint(buffer, bytes.length);
        buffer.flip();
        try {
            this.connection.write(buffer);
            if (bytes.length > 0) {
                this.connection.write(ByteBuffer.wrap(bytes));
            }
        }
        catch (PyroException pyroException) {
            // empty catch block
        }
    }

    public void sendFunctionCall(byte[] bytes, FunctionCallListener functionCallListener) {
        this.sendFunctionCall(30.0f, bytes, functionCallListener);
    }

    public void sendFunctionCall(float timeout, byte[] bytes, FunctionCallListener functionCallListener) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.selector.isNetworkThread()) {
            this.sendFunctionCallCode(b, timeout, functionCallListener);
        } else {
            this.selector.scheduleTask(() -> this.sendFunctionCallCode(b, timeout, functionCallListener));
        }
    }

    protected void sendFunctionCallCode(byte[] bytes, float timeout, FunctionCallListener functionCallListener) {
        if (!this.isConnected()) {
            this.threadSafeFailedFunctionCall(functionCallListener);
            return;
        }
        InternalFunctionCall functionCall = new InternalFunctionCall();
        functionCall.listener = functionCallListener;
        functionCall.timeoutTime = CachedTime.millisSinceStart() + (long)((double)timeout * 1000.0);
        int functionCallId = this.reserveFunctionCallId(functionCall);
        ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length));
        buffer.put((byte)2);
        SocketFunctions.putUint(buffer, functionCallId);
        SocketFunctions.putUint(buffer, bytes.length);
        buffer.flip();
        try {
            this.connection.write(buffer);
            if (bytes.length > 0) {
                this.connection.write(ByteBuffer.wrap(bytes));
            }
        }
        catch (PyroException pyroException) {
            // empty catch block
        }
    }

    public LatentFunctionCall sendLatentFunctionCall(byte[] bytes, LatentFunctionCallListener functionCallListener) {
        return this.sendLatentFunctionCall(30.0f, bytes, functionCallListener);
    }

    public LatentFunctionCall sendLatentFunctionCall(float timeout, byte[] bytes, LatentFunctionCallListener functionCallListener) {
        byte[] b;
        LatentFunctionCall latentAction = new LatentFunctionCall(this);
        latentAction.listener = functionCallListener;
        InternalLatentFunctionCall functionCall = new InternalLatentFunctionCall();
        functionCall.latentAction = latentAction;
        functionCall.listener = functionCallListener;
        functionCall.timeoutTime = CachedTime.millisSinceStart() + (long)((double)timeout * 1000.0);
        latentAction.functionCallId = this.reserveLatentFunctionCallId(functionCall);
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.selector.isNetworkThread()) {
            this.sendLatentFunctionCallCode(latentAction, b, timeout, functionCallListener);
        } else {
            this.selector.scheduleTask(() -> this.sendLatentFunctionCallCode(latentAction, b, timeout, functionCallListener));
        }
        return latentAction;
    }

    protected void sendLatentFunctionCallCode(LatentFunctionCall latentAction, byte[] bytes, float timeout, LatentFunctionCallListener functionCallListener) {
        if (latentAction.isDone() || latentAction.isCanceled() || latentAction.isFailed()) {
            return;
        }
        if (!this.isConnected()) {
            this.threadSafeFailedLatentFunctionCall(functionCallListener);
            latentAction.canceledByDisconnecting();
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(latentAction.functionCallId) + SocketFunctions.uintByteCount(bytes.length));
        buffer.put((byte)4);
        SocketFunctions.putUint(buffer, latentAction.functionCallId);
        SocketFunctions.putUint(buffer, bytes.length);
        buffer.flip();
        try {
            this.connection.write(buffer);
            if (bytes.length > 0) {
                this.connection.write(ByteBuffer.wrap(bytes));
            }
        }
        catch (PyroException pyroException) {
            // empty catch block
        }
    }

    protected void sendLatentFunctionCallCancel(int functionCallId) {
        if (this.selector.isNetworkThread()) {
            this.sendLatentFunctionCallCancelCode(functionCallId);
        } else {
            this.selector.scheduleTask(() -> this.sendLatentFunctionCallCancelCode(functionCallId));
        }
    }

    protected void sendLatentFunctionCallCancelCode(int functionCallId) {
        if (!this.isConnected()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId));
        buffer.put((byte)6);
        SocketFunctions.putUint(buffer, functionCallId);
        buffer.flip();
        try {
            this.connection.write(buffer);
        }
        catch (PyroException pyroException) {
            // empty catch block
        }
    }

    public void disconnect() {
        if (this.selector.isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.selector.scheduleTask(() -> {
                if (this.connectionUdp != null) {
                    this.connectionUdp.shutdown();
                    this.connectionUdp = null;
                }
                if (this.connection != null) {
                    this.connection.shutdown();
                    this.connection = null;
                }
            });
        } else {
            this.selector.scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                if (this.connectionUdp != null) {
                    this.connectionUdp.shutdown();
                    this.connectionUdp = null;
                }
                if (this.connection != null) {
                    this.connection.shutdown();
                    this.connection = null;
                }
            });
        }
    }

    public void disconnectImmediately() {
        if (this.selector.isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.selector.scheduleTask(() -> {
                if (this.connectionUdp != null) {
                    this.connectionUdp.shutdown();
                    this.connectionUdp = null;
                }
                if (this.connection != null) {
                    this.connection.dropConnection();
                    this.connection = null;
                }
            });
        } else {
            this.selector.scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                if (this.connectionUdp != null) {
                    this.connectionUdp.shutdown();
                    this.connectionUdp = null;
                }
                if (this.connection != null) {
                    this.connection.dropConnection();
                    this.connection = null;
                }
            });
        }
    }

    public boolean isConnected() {
        this.selector.checkThread();
        return !this.isDisconnecting && this.connection != null && !this.connection.isDisconnected();
    }

    protected boolean isConnectedUdp() {
        this.selector.checkThread();
        return !this.isDisconnecting && this.connectionUdp != null;
    }

    public PyroClient pyro() {
        return this.connection;
    }

    public PyroSelector selector() {
        return this.selector;
    }

    public PyroClientUdp pyroUdp() {
        return this.connectionUdp;
    }

    public void execute(Runnable runnable) {
        if (this.selector.isNetworkThread()) {
            runnable.run();
        } else {
            this.selector.scheduleTask(runnable);
        }
    }

    public boolean isNetworkThread() {
        return this.selector.isNetworkThread();
    }

    public String getAddressText() {
        if (this.connection == null) {
            return "closed";
        }
        if (this.connectionUdp == null) {
            return this.connection.getAddressText();
        }
        return this.connection.getAddressText() + ", " + this.connectionUdp.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public static interface FunctionCallListener {
        public void receivedResponse(SocketConnection var1, byte[] var2);

        public void failed(SocketConnection var1);
    }

    public static interface LatentFunctionCallListener {
        public void receivedResponse(SocketConnection var1, byte[] var2);

        public void canceled(SocketConnection var1);

        public void failed(SocketConnection var1);
    }

    protected static class InternalFunctionCall {
        FunctionCallListener listener;
        long timeoutTime;

        protected InternalFunctionCall() {
        }
    }

    protected static class InternalLatentFunctionCall {
        LatentFunctionCall latentAction;
        LatentFunctionCallListener listener;
        long timeoutTime;

        protected InternalLatentFunctionCall() {
        }
    }
}

