/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Consumer;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.SimpleSocketServer;
import lowentry.ue4.classes.sockets.SocketClient;
import lowentry.ue4.classes.sockets.SocketServerClientHandler;
import lowentry.ue4.classes.sockets.SocketServerListener;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroServer;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroServerListener;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.PyroServerUdp;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.event.PyroServerUdpListener;

public class SocketServer
implements Iterable<SocketClient> {
    public static boolean IS_DEBUGGING = false;
    public static PrintStream DEBUGGING_PRINTSTREAM = System.out;
    protected static final int NEW_CONNECTIONS_QUEUE_SIZE = 500;
    protected static final int HANDSHAKE_TIMEOUT_MS = 30000;
    protected final PyroServer server;
    protected final Collection<SocketClient> clients = new LinkedHashSet<SocketClient>();
    protected final PyroServerUdp serverUdp;
    protected final HashMap<SocketAddress, SocketServerClientHandler> serverUdpClientHandlers = new HashMap();
    protected final ByteBuffer serverUdpNetworkBuffer;
    protected long serverUdpNextHandshakingId = 1L;
    protected final int serverPortTcp;
    protected final int serverPortUdp;
    protected final SocketServerListener socketListener;
    protected long lastHandshakingClientHandlerValidation = CachedTime.millisSinceStart();
    protected long lastHandshakingClientHandlerUdpSend = CachedTime.millisSinceStart();
    protected final Collection<SocketServerClientHandler> handshakingTcpClientHandlers = new LinkedHashSet<SocketServerClientHandler>();
    protected final Map<ByteBuffer, SocketServerClientHandler> handshakingUdpClientHandlers = new LinkedHashMap<ByteBuffer, SocketServerClientHandler>();
    protected final ByteBuffer clientDataBuffer = ByteBuffer.allocateDirect(524288);
    protected final String addressText;

    public static void setDebuggingEnabled() {
        IS_DEBUGGING = true;
    }

    public static void setDebuggingEnabled(PrintStream printstream) {
        IS_DEBUGGING = true;
        DEBUGGING_PRINTSTREAM = printstream;
    }

    public SocketServer(boolean acceptExternalConnections, int portTcp, SocketServerListener listener) throws Exception {
        this.serverPortTcp = portTcp;
        this.serverPortUdp = 0;
        this.socketListener = listener;
        PyroSelector selector = new PyroSelector();
        this.server = selector.listen(acceptExternalConnections, portTcp, 500, this.createServerListener());
        this.serverUdp = null;
        this.serverUdpNetworkBuffer = null;
        this.addressText = this.getAddressText();
    }

    public SocketServer(boolean acceptExternalConnections, int portTcp, int portUdp, SocketServerListener listener) throws Exception {
        this.serverPortTcp = portTcp;
        this.serverPortUdp = portUdp <= 0 ? 0 : portUdp;
        this.socketListener = listener;
        PyroSelector selector = new PyroSelector();
        this.server = selector.listen(acceptExternalConnections, portTcp, 500, this.createServerListener());
        this.serverUdp = portUdp <= 0 ? null : new PyroServerUdp(acceptExternalConnections, portUdp, this.createServerUdpListener());
        this.serverUdpNetworkBuffer = this.serverUdp == null ? null : ByteBuffer.allocate(524288);
        this.addressText = this.getAddressText();
    }

    public SocketServer(String bindAddress, int portTcp, SocketServerListener listener) throws Exception {
        this.serverPortTcp = portTcp;
        this.serverPortUdp = 0;
        this.socketListener = listener;
        PyroSelector selector = new PyroSelector();
        this.server = selector.listen(new InetSocketAddress(bindAddress, portTcp), 500, this.createServerListener());
        this.serverUdp = null;
        this.serverUdpNetworkBuffer = null;
        this.addressText = this.getAddressText();
    }

    public SocketServer(String bindAddress, int portTcp, int portUdp, SocketServerListener listener) throws Exception {
        this.serverPortTcp = portTcp;
        this.serverPortUdp = portUdp <= 0 ? 0 : portUdp;
        this.socketListener = listener;
        PyroSelector selector = new PyroSelector();
        this.server = selector.listen(new InetSocketAddress(bindAddress, portTcp), 500, this.createServerListener());
        this.serverUdp = portUdp <= 0 ? null : new PyroServerUdp(new InetSocketAddress(bindAddress, portUdp), this.createServerUdpListener());
        this.serverUdpNetworkBuffer = this.serverUdp == null ? null : ByteBuffer.allocate(524288);
        this.addressText = this.getAddressText();
    }

    protected PyroServerListener createServerListener() {
        return client -> {
            SocketServer socketServer = this;
            SocketClient socketClient = new SocketClient(socketServer, client);
            SocketServerClientHandler clientHandler = new SocketServerClientHandler(this.socketListener, socketServer, socketClient);
            client.setListener(clientHandler);
            clientHandler.connectedClient(client);
        };
    }

    protected PyroServerUdpListener createServerUdpListener() {
        return (client, data) -> SocketServerClientHandler.receiveDataUdpUnknownClient(this, client, data);
    }

    protected void addUdpClient(SocketServerClientHandler clientHandler) {
        SocketAddress clientUdp = clientHandler.socketClient.clientUdpAddress;
        if (clientUdp != null) {
            this.serverUdpClientHandlers.put(clientUdp, clientHandler);
        }
    }

    protected void removeUdpClient(SocketServerClientHandler clientHandler) {
        SocketAddress clientUdp = clientHandler.socketClient.clientUdpAddress;
        if (clientUdp != null) {
            this.serverUdpClientHandlers.remove(clientUdp);
        }
    }

    public void listen() {
        this.listen(100L);
    }

    public void listen(long eventTimeout) {
        long lastTime;
        this.server.selector().checkThread();
        if (eventTimeout <= 10L) {
            this.pyroListen(eventTimeout);
            this.handleHandshakingTimeouts();
            this.sendHandshakeUdpMessages();
            return;
        }
        long startTime = CachedTime.millisSinceStart();
        while (eventTimeout > 200L) {
            this.listen(200L);
            lastTime = CachedTime.millisSinceStart();
            eventTimeout -= lastTime - startTime;
            startTime = lastTime;
        }
        this.pyroListen(eventTimeout);
        lastTime = CachedTime.millisSinceStart();
        long timeSpend = lastTime - startTime;
        while (timeSpend < eventTimeout - 10L) {
            this.pyroListen(eventTimeout - timeSpend);
            long newTime = CachedTime.millisSinceStart();
            if (newTime == lastTime) continue;
            lastTime = newTime;
            timeSpend = lastTime - startTime;
        }
        this.handleHandshakingTimeouts();
        this.sendHandshakeUdpMessages();
    }

    private void pyroListen(long eventTimeout) {
        if (this.serverUdp != null) {
            for (long i = 1L; i <= eventTimeout; ++i) {
                block10: {
                    try {
                        this.serverUdp.listen(this.serverUdpNetworkBuffer);
                    }
                    catch (Exception e) {
                        if (!IS_DEBUGGING) break block10;
                        DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " UDP listen caused an exception:");
                        DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                    }
                }
                try {
                    this.server.selector().select(1L);
                    continue;
                }
                catch (Exception e) {
                    if (!IS_DEBUGGING) continue;
                    DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " listen caused an exception:");
                    DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                }
            }
        } else {
            for (long i = 1L; i <= eventTimeout; ++i) {
                try {
                    this.server.selector().select(1L);
                    continue;
                }
                catch (Exception e) {
                    if (!IS_DEBUGGING) continue;
                    DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " listen caused an exception:");
                    DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                }
            }
        }
    }

    protected void handleHandshakingTimeouts() {
        SocketServerClientHandler clientHandler;
        long time = CachedTime.millisSinceStart();
        if (time - this.lastHandshakingClientHandlerValidation < 5000L) {
            return;
        }
        this.lastHandshakingClientHandlerValidation = time;
        Iterator<SocketServerClientHandler> iterator = this.handshakingTcpClientHandlers.iterator();
        while (iterator.hasNext()) {
            clientHandler = iterator.next();
            if (time - clientHandler.handshakingStartTime < 30000L) break;
            if (IS_DEBUGGING) {
                byte[] handshake = clientHandler.handshakingPacket == null ? null : clientHandler.handshakingPacket.toByteArray();
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + clientHandler.socketClient + " was disconnected because the handshake took too long" + (String)(handshake == null ? "" : ", handshake so far was: " + LowEntry.bytesToHex(handshake) + " => " + LowEntry.bytesToStringLatin1(handshake).replaceAll("[\\p{C}]", "?")));
            }
            iterator.remove();
            clientHandler.disconnect();
        }
        iterator = this.handshakingUdpClientHandlers.values().iterator();
        while (iterator.hasNext()) {
            clientHandler = iterator.next();
            if (time - clientHandler.handshakingStartTime < 30000L) break;
            if (IS_DEBUGGING) {
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + clientHandler.socketClient + " was disconnected because the UDP handshake took too long");
            }
            iterator.remove();
            clientHandler.disconnect();
        }
    }

    protected void sendHandshakeUdpMessages() {
        long time = CachedTime.millisSinceStart();
        if (time - this.lastHandshakingClientHandlerUdpSend < 500L) {
            return;
        }
        this.lastHandshakingClientHandlerUdpSend = time;
        for (SocketServerClientHandler clientHandler : this.handshakingUdpClientHandlers.values()) {
            SocketAddress address;
            if (!clientHandler.hasReceivedClientUdpMessage || (address = clientHandler.socketClient.clientUdpAddress) == null) continue;
            this.serverUdp.write(ByteBuffer.wrap(clientHandler.handshakingUdpId), address);
        }
    }

    public void close() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.serverUdp.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.server.close();
            }
            catch (Exception exception) {}
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.serverUdp.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public void terminate() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.serverUdp.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (SocketClient client : this) {
                client.disconnect();
            }
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.serverUdp.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (SocketClient client : this) {
                    client.disconnect();
                }
            });
        }
    }

    public void terminateImmediately() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.serverUdp.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (SocketClient client : this) {
                client.disconnectImmediately();
            }
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.serverUdp.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (SocketClient client : this) {
                    client.disconnectImmediately();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SocketClient> iterator() {
        ArrayList<SocketClient> copy;
        Collection<SocketClient> collection = this.clients;
        synchronized (collection) {
            copy = new ArrayList<SocketClient>(this.clients);
        }
        return copy.iterator();
    }

    public void forEachClient(Consumer<SocketClient> action) {
        this.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        Collection<SocketClient> collection = this.clients;
        synchronized (collection) {
            return this.clients.size();
        }
    }

    public PyroServer pyro() {
        return this.server;
    }

    public PyroSelector selector() {
        return this.server.selector();
    }

    public PyroServerUdp pyroUdp() {
        return this.serverUdp;
    }

    public void execute(Runnable runnable) {
        if (this.server.selector().isNetworkThread()) {
            runnable.run();
        } else {
            this.server.selector().scheduleTask(runnable);
        }
    }

    public int getPortTcp() {
        return this.serverPortTcp;
    }

    public int getPortUdp() {
        return this.serverPortUdp;
    }

    public String getAddressText() {
        if (this.addressText != null) {
            return this.addressText;
        }
        if (this.server == null) {
            return "closed";
        }
        if (this.serverUdp == null) {
            return this.server.getAddressText();
        }
        return this.server.getAddressText() + ", " + this.serverUdp.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }
}

