/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.LatentResponse;
import lowentry.ue4.classes.sockets.LatentResponseImplementation;
import lowentry.ue4.classes.sockets.SocketClient;
import lowentry.ue4.classes.sockets.SocketFunctions;
import lowentry.ue4.classes.sockets.SocketMessageType;
import lowentry.ue4.classes.sockets.SocketMessageUdpType;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.classes.sockets.SocketServerListener;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;

public class SocketServerClientHandler
implements PyroClientListener {
    private static final String WEBSOCKET_KEY_STRING = "Sec-WebSocket-Key:".toLowerCase(Locale.ENGLISH);
    protected final SocketServerListener socketListener;
    protected final SocketServer socketServer;
    protected final SocketClient socketClient;
    protected final HashMap<Integer, LatentResponse> latentResponses = new HashMap();
    protected boolean stopReceivingAnything = false;
    protected final long handshakingStartTime = CachedTime.millisSinceStart();
    protected boolean handshakingPacketComplete = false;
    protected ByteArrayOutputStream handshakingPacket = null;
    protected byte handshakingPacketStage = 0;
    protected WebsocketReceivingData websocket = null;
    protected boolean hasReceivedServerUdpPort = false;
    protected boolean hasReceivedClientUdpPort = false;
    protected boolean hasReceivedClientUdpMessage = false;
    protected boolean hasReceivedClientUdpResponseOfServerUdpMessage = false;
    protected byte[] handshakingUdpId = null;
    protected ReceivingStage receivingStage = ReceivingStage.RECEIVE_TYPE;
    protected byte receivingType = 0;
    protected int receivingFunctionCallId = 0;
    protected int receivingPacketSize = 0;
    protected byte[] receivingPacket = null;
    protected int receivingPacketPosition = 0;
    protected ByteBuffer receivedIntegerBuffer = ByteBuffer.allocate(4);
    protected final int hashCode;

    public SocketServerClientHandler(SocketServerListener socketListener, SocketServer socketServer, SocketClient socketClient) {
        this.socketListener = socketListener;
        this.socketServer = socketServer;
        this.socketClient = socketClient;
        this.hashCode = super.hashCode();
    }

    @Override
    public void unconnectableClient(PyroClient client) {
        if (SocketServer.IS_DEBUGGING) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was unconnectable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectedClient(PyroClient client) {
        if (SocketServer.IS_DEBUGGING) {
            this.socketClient.saveAddressText();
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has connected");
        }
        Collection<SocketClient> collection = this.socketServer.clients;
        synchronized (collection) {
            this.socketServer.clients.add(this.socketClient);
        }
        this.socketServer.handshakingTcpClientHandlers.add(this);
        this.socketListener.clientConnected(this.socketServer, this.socketClient);
    }

    @Override
    public void droppedClient(PyroClient client, IOException cause) {
        if (SocketServer.IS_DEBUGGING) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was dropped:");
            SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(cause));
        }
        this.hasDisconnected();
    }

    @Override
    public void disconnectedClient(PyroClient client) {
        if (SocketServer.IS_DEBUGGING) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was disconnected");
        }
        this.hasDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasDisconnected() {
        Collection<SocketClient> collection = this.socketServer.clients;
        synchronized (collection) {
            this.socketServer.clients.remove(this.socketClient);
        }
        if (this.handshakingPacket != null) {
            this.socketServer.handshakingTcpClientHandlers.remove(this);
        }
        if (this.handshakingUdpId != null) {
            this.socketServer.handshakingUdpClientHandlers.remove(ByteBuffer.wrap(this.handshakingUdpId));
        }
        this.socketServer.removeUdpClient(this);
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.websocket = null;
        LatentResponse[] latentResponsesArray = null;
        LatentResponse[] latentResponseArray = this.latentResponses;
        synchronized (this.latentResponses) {
            if (this.latentResponses.size() > 0) {
                latentResponsesArray = new LatentResponse[this.latentResponses.size()];
                latentResponsesArray = this.latentResponses.values().toArray(latentResponsesArray);
                this.latentResponses.clear();
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            if (latentResponsesArray != null) {
                for (LatentResponse response : latentResponsesArray) {
                    response.canceledByDisconnecting();
                }
            }
            this.socketListener.clientDisconnected(this.socketServer, this.socketClient);
            return;
        }
    }

    @Override
    public void sentData(PyroClient client, int bytes) {
    }

    public void disconnect() {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.websocket = null;
        this.socketClient.disconnect();
    }

    public static void receiveDataUdpUnknownClient(SocketServer server, SocketAddress client, ByteBuffer data) {
        if (!data.hasRemaining()) {
            return;
        }
        byte packetType = data.get();
        switch (packetType) {
            case 1: {
                if (!data.hasRemaining()) {
                    return;
                }
                int length = data.get() & 0xFF;
                if (data.remaining() < length) {
                    return;
                }
                byte[] id = new byte[length];
                data.get(id);
                SocketServerClientHandler clientHandler = server.handshakingUdpClientHandlers.get(ByteBuffer.wrap(id));
                if (clientHandler == null) {
                    return;
                }
                clientHandler.socketClient.setRemoteUdpAddress(client);
                server.addUdpClient(clientHandler);
                clientHandler.hasReceivedClientUdpMessage = true;
                return;
            }
            case 2: {
                SocketServerClientHandler clientHandler = server.serverUdpClientHandlers.get(client);
                if (clientHandler != null) {
                    clientHandler.receivedUnreliableMessage(client, data);
                } else if (SocketServer.IS_DEBUGGING) {
                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] could not find client with UDP address: " + client);
                }
                return;
            }
            case 3: {
                if (server.serverUdp == null) {
                    return;
                }
                server.serverUdp.write(ByteBuffer.wrap(SocketMessageUdpType.PONG_BYTES), client);
                return;
            }
            case 4: {
                return;
            }
        }
        if (SocketServer.IS_DEBUGGING) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] invalid UDP packet type (" + packetType + ") received from UDP address: " + client);
        }
    }

    public void receivedUnreliableMessage(SocketAddress client, ByteBuffer data) {
        if (this.stopReceivingAnything) {
            return;
        }
        if (this.socketListener.startReceivingUnreliableMessage(this.socketServer, this.socketClient, data.remaining())) {
            this.socketListener.receivedUnreliableMessage(this.socketServer, this.socketClient, data);
        } else {
            if (SocketServer.IS_DEBUGGING) {
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was prevented from sending a packet, packet type: " + SocketMessageType.format((byte)9) + ", packet size: " + data.remaining() + " bytes");
            }
            this.disconnect();
        }
    }

    protected Integer receiveInt(ByteBuffer data) {
        if (!data.hasRemaining()) {
            return null;
        }
        while (data.hasRemaining() && this.receivedIntegerBuffer.position() < 4) {
            this.receivedIntegerBuffer.put(data.get());
        }
        if (this.receivedIntegerBuffer.position() < 4) {
            return null;
        }
        this.receivedIntegerBuffer.flip();
        byte b1 = this.receivedIntegerBuffer.get();
        byte b2 = this.receivedIntegerBuffer.get();
        byte b3 = this.receivedIntegerBuffer.get();
        byte b4 = this.receivedIntegerBuffer.get();
        this.receivedIntegerBuffer.clear();
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    protected int receiveUint(ByteBuffer data) {
        if (!data.hasRemaining()) {
            return -1;
        }
        if (this.receivedIntegerBuffer.position() == 0) {
            byte firstByte = data.get();
            if ((firstByte >> 7 & 1) == 0) {
                return firstByte & 0xFF;
            }
            this.receivedIntegerBuffer.put(firstByte);
        }
        while (data.hasRemaining() && this.receivedIntegerBuffer.position() < 4) {
            this.receivedIntegerBuffer.put(data.get());
        }
        if (this.receivedIntegerBuffer.position() < 4) {
            return -1;
        }
        this.receivedIntegerBuffer.flip();
        byte b1 = this.receivedIntegerBuffer.get();
        byte b2 = this.receivedIntegerBuffer.get();
        byte b3 = this.receivedIntegerBuffer.get();
        byte b4 = this.receivedIntegerBuffer.get();
        this.receivedIntegerBuffer.clear();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        if (value < 128) {
            if (SocketServer.IS_DEBUGGING) {
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid uint, uints of 4 bytes can't be below 128, uint value: " + value);
            }
            this.disconnect();
            return -1;
        }
        return value;
    }

    protected byte[] generateNextHandshakingUdpId() {
        byte[] bytes = LowEntry.generateRandomBytes(25);
        bytes[0] = 1;
        bytes[1] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 56);
        bytes[2] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 48);
        bytes[3] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 40);
        bytes[4] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 32);
        bytes[5] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 24);
        bytes[6] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 16);
        bytes[7] = (byte)(this.socketServer.serverUdpNextHandshakingId >> 8);
        bytes[8] = (byte)this.socketServer.serverUdpNextHandshakingId;
        ++this.socketServer.serverUdpNextHandshakingId;
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(PyroClient client, ByteBuffer data) {
        byte b;
        if (this.stopReceivingAnything) {
            return;
        }
        if (!this.handshakingPacketComplete) {
            while (data.hasRemaining()) {
                int websocketKeyEndIndex;
                int websocketKeyStartIndex;
                b = data.get();
                if (this.handshakingPacket == null) {
                    if (this.handshakingPacketStage == 0) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 1) {
                        if (b == 10) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 2) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 3) {
                        this.handshakingPacketStage = 0;
                        if (b != 10) {
                            this.handshakingPacket = new ByteArrayOutputStream(256);
                            this.handshakingPacket.write(b);
                            continue;
                        }
                    }
                } else {
                    this.handshakingPacket.write(b);
                    if (this.handshakingPacket.size() > 8192) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a handshake that is too big, handshakes can't be over 8192 bytes");
                        }
                        this.disconnect();
                        return;
                    }
                    if (this.handshakingPacketStage == 0) {
                        if (b != 13) continue;
                        this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                        continue;
                    }
                    if (this.handshakingPacketStage == 1) {
                        if (b == 10) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        continue;
                    }
                    if (this.handshakingPacketStage == 2) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        continue;
                    }
                    if (this.handshakingPacketStage == 3) {
                        this.handshakingPacketStage = 0;
                        if (b != 10) continue;
                    }
                }
                this.handshakingPacketComplete = true;
                this.socketServer.handshakingTcpClientHandlers.remove(this);
                if (this.handshakingPacket == null) {
                    if (SocketServer.IS_DEBUGGING) {
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has completed the handshake: " + LowEntry.toJsonString("\r\n\r\n"));
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a regular socket");
                    }
                    this.socketClient.onHandshakeCompletedTcp(false);
                    break;
                }
                String header = LowEntry.bytesToStringLatin1(this.handshakingPacket.toByteArray());
                this.handshakingPacket = null;
                if (SocketServer.IS_DEBUGGING) {
                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has completed the handshake: " + LowEntry.toJsonString(header));
                }
                if ((websocketKeyStartIndex = header.toLowerCase(Locale.ENGLISH).indexOf(WEBSOCKET_KEY_STRING)) < 0) {
                    if (SocketServer.IS_DEBUGGING) {
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a regular socket");
                    }
                    this.socketClient.onHandshakeCompletedTcp(false);
                }
                if (SocketServer.IS_DEBUGGING) {
                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a websocket");
                }
                if ((websocketKeyEndIndex = header.indexOf(13, websocketKeyStartIndex += WEBSOCKET_KEY_STRING.length())) < 0) {
                    websocketKeyEndIndex = header.length();
                }
                String key = header.substring(websocketKeyStartIndex, websocketKeyEndIndex).trim();
                String responsekey = LowEntry.bytesToBase64(LowEntry.sha1(LowEntry.stringToBytesLatin1(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
                String response = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: Websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + responsekey + (header.contains("Sec-WebSocket-Protocol:") ? "\r\nSec-WebSocket-Protocol: binary" : "") + "\r\n\r\n";
                try {
                    client.write(ByteBuffer.wrap(LowEntry.stringToBytesLatin1(response)));
                }
                catch (PyroException e) {
                    if (SocketServer.IS_DEBUGGING) {
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " can't be send a handshake response:");
                        SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                    }
                    this.disconnect();
                    return;
                }
                this.websocket = new WebsocketReceivingData();
                this.socketClient.onHandshakeCompletedTcp(true);
                break;
            }
        }
        while (data.hasRemaining()) {
            ByteBuffer d;
            Object buffer;
            if (this.websocket != null) {
                this.socketServer.clientDataBuffer.clear();
                while (data.hasRemaining()) {
                    if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE) {
                        byte opcode = data.get();
                        opcode = LowEntry.getByteWithBitSet(opcode, 8, false);
                        opcode = LowEntry.getByteWithBitSet(opcode, 7, false);
                        opcode = LowEntry.getByteWithBitSet(opcode, 6, false);
                        if ((opcode = LowEntry.getByteWithBitSet(opcode, 5, false)) == 8) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent CLOSE (websocket)");
                            }
                            this.disconnect();
                            return;
                        }
                        if (opcode == 9) {
                            this.websocket.pingPacket = new ByteArrayOutputStream();
                            this.websocket.receivingType = WebsocketReceivingData.WebsocketPacketType.PING;
                        } else {
                            this.websocket.receivingType = opcode == 10 ? WebsocketReceivingData.WebsocketPacketType.PONG : WebsocketReceivingData.WebsocketPacketType.DATA;
                        }
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_1;
                        continue;
                    }
                    if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_1) {
                        b = data.get();
                        this.websocket.containsMask = LowEntry.isBitSet(b, 8);
                        if (this.websocket.containsMask) {
                            b = LowEntry.getByteWithBitSet(b, 8, false);
                        }
                        this.websocket.sizePacket[0] = b;
                        long size = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 1);
                        if (size == 126L) {
                            this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_2;
                            continue;
                        }
                        if (size == 127L) {
                            this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_8;
                            continue;
                        }
                        this.websocket.payloadRemainingByteCount = size;
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                        continue;
                    }
                    if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_2) {
                        if (this.websocket.sizePacketIndex == 0 && data.remaining() >= 2) {
                            data.get(this.websocket.sizePacket, 0, 2);
                        } else {
                            while (data.hasRemaining() && this.websocket.sizePacketIndex < 2) {
                                this.websocket.sizePacket[this.websocket.sizePacketIndex] = data.get();
                                this.websocket.sizePacketIndex = (byte)(this.websocket.sizePacketIndex + 1);
                            }
                            if (this.websocket.sizePacketIndex < 2) {
                                return;
                            }
                        }
                        this.websocket.payloadRemainingByteCount = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 2);
                        this.websocket.sizePacketIndex = 0;
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                        continue;
                    }
                    if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_8) {
                        if (this.websocket.sizePacketIndex == 0 && data.remaining() >= 8) {
                            data.get(this.websocket.sizePacket, 0, 8);
                        } else {
                            while (data.hasRemaining() && this.websocket.sizePacketIndex < 8) {
                                this.websocket.sizePacket[this.websocket.sizePacketIndex] = data.get();
                                this.websocket.sizePacketIndex = (byte)(this.websocket.sizePacketIndex + 1);
                            }
                            if (this.websocket.sizePacketIndex < 8) {
                                return;
                            }
                        }
                        this.websocket.payloadRemainingByteCount = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 8);
                        this.websocket.sizePacketIndex = 0;
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                        continue;
                    }
                    if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK) {
                        if (this.websocket.containsMask) {
                            if (this.websocket.maskIndex == 0 && data.remaining() >= 4) {
                                data.get(this.websocket.mask, 0, 4);
                            } else {
                                while (data.hasRemaining() && this.websocket.maskIndex < 4) {
                                    this.websocket.mask[this.websocket.maskIndex] = data.get();
                                    this.websocket.maskIndex = (byte)(this.websocket.maskIndex + 1);
                                }
                                if (this.websocket.maskIndex < 4) {
                                    return;
                                }
                            }
                            this.websocket.maskIndex = 0;
                        }
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_PAYLOAD;
                        continue;
                    }
                    if (this.websocket.receivingStage != WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_PAYLOAD) continue;
                    if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.DATA) {
                        if (this.websocket.payloadRemainingByteCount <= 0L) {
                            this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                            continue;
                        }
                        while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                            b = data.get();
                            --this.websocket.payloadRemainingByteCount;
                            if (this.websocket.containsMask) {
                                b = (byte)(b ^ this.websocket.mask[this.websocket.maskIndex]);
                                this.websocket.maskIndex = this.websocket.maskIndex == 3 ? (byte)0 : (byte)(this.websocket.maskIndex + 1);
                            }
                            this.socketServer.clientDataBuffer.put(b);
                        }
                        if (this.websocket.payloadRemainingByteCount > 0L) break;
                        this.websocket.maskIndex = 0;
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                        break;
                    }
                    if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.PING) {
                        while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                            b = data.get();
                            --this.websocket.payloadRemainingByteCount;
                            if (this.websocket.containsMask) {
                                b = (byte)(b ^ this.websocket.mask[this.websocket.maskIndex]);
                                this.websocket.maskIndex = this.websocket.maskIndex == 3 ? (byte)0 : (byte)(this.websocket.maskIndex + 1);
                            }
                            this.websocket.pingPacket.write(b);
                            if (this.websocket.pingPacket.size() <= 8192) continue;
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a ping (websocket) that is too big, pings can't be over 8192 bytes");
                            }
                            this.disconnect();
                            return;
                        }
                        if (this.websocket.payloadRemainingByteCount > 0L) continue;
                        byte[] packet = this.websocket.pingPacket.toByteArray();
                        int size = packet.length;
                        byte opcode = -118;
                        buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + packet.length);
                        ((ByteBuffer)buffer).put(opcode);
                        SocketFunctions.putWebsocketSizeBytes((ByteBuffer)buffer, size);
                        ((ByteBuffer)buffer).put(packet);
                        ((ByteBuffer)buffer).flip();
                        try {
                            client.write((ByteBuffer)buffer);
                        }
                        catch (PyroException e) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " can't be send data:");
                                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                            }
                            this.disconnect();
                            return;
                        }
                        this.websocket.pingPacket = null;
                        this.websocket.maskIndex = 0;
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                        continue;
                    }
                    while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                        data.get();
                        --this.websocket.payloadRemainingByteCount;
                    }
                    if (this.websocket.payloadRemainingByteCount > 0L) continue;
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                }
                this.socketServer.clientDataBuffer.flip();
                if (!this.socketServer.clientDataBuffer.hasRemaining()) {
                    return;
                }
            }
            ByteBuffer byteBuffer = d = this.websocket == null ? data : this.socketServer.clientDataBuffer;
            while (d.hasRemaining()) {
                if (!this.hasReceivedServerUdpPort) {
                    Integer receivedInt = this.receiveInt(d);
                    if (receivedInt == null) {
                        return;
                    }
                    this.hasReceivedServerUdpPort = true;
                    if (receivedInt < 0) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid server UDP port: " + receivedInt);
                        }
                        this.disconnect();
                        return;
                    }
                    if (receivedInt == 0 && this.socketServer.serverUdp != null) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " didn't try to connect over UDP, even though the server is listening for UDP");
                        }
                        this.disconnect();
                        return;
                    }
                    if (receivedInt > 0 && this.socketServer.serverUdp == null) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " tried to connect over UDP, even though the server isn't listening for UDP");
                        }
                        this.disconnect();
                        return;
                    }
                }
                if (!this.hasReceivedClientUdpPort) {
                    Integer receivedInt = this.receiveInt(d);
                    if (receivedInt == null) {
                        return;
                    }
                    this.hasReceivedClientUdpPort = true;
                    if (receivedInt < 0) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid client UDP port: " + receivedInt);
                        }
                        this.disconnect();
                        return;
                    }
                    if (this.websocket != null) {
                        this.socketClient.setRemoteUdpAddress(null);
                        this.hasReceivedClientUdpMessage = true;
                        this.hasReceivedClientUdpResponseOfServerUdpMessage = true;
                        this.socketClient.onHandshakeCompletedUdp();
                    } else {
                        if (receivedInt == 0 && this.socketServer.serverUdp != null) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " didn't try to connect over UDP, even though the server is listening for UDP");
                            }
                            this.disconnect();
                            return;
                        }
                        if (receivedInt > 0 && this.socketServer.serverUdp == null) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " tried to connect over UDP, even though the server isn't listening for UDP");
                            }
                            this.disconnect();
                            return;
                        }
                        if (this.socketServer.serverUdp == null) {
                            this.socketClient.setRemoteUdpAddress(null);
                            this.hasReceivedClientUdpMessage = true;
                            this.hasReceivedClientUdpResponseOfServerUdpMessage = true;
                            this.socketClient.onHandshakeCompletedUdp();
                        } else {
                            try {
                                this.handshakingUdpId = this.generateNextHandshakingUdpId();
                                this.socketServer.handshakingUdpClientHandlers.put(ByteBuffer.wrap(this.handshakingUdpId), this);
                                ByteBuffer buffer2 = ByteBuffer.allocate(1 + this.handshakingUdpId.length);
                                buffer2.put((byte)this.handshakingUdpId.length);
                                buffer2.put(this.handshakingUdpId);
                                buffer2.flip();
                                client.write(buffer2);
                            }
                            catch (PyroException e) {
                                if (SocketServer.IS_DEBUGGING) {
                                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " can't be send a UDP handshake request:");
                                    SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                                }
                                this.disconnect();
                                return;
                            }
                        }
                    }
                }
                if (!this.hasReceivedClientUdpMessage) {
                    if (d.hasRemaining()) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " tried to send data, while the server is still waiting for the UDP handshake");
                        }
                        this.disconnect();
                        return;
                    }
                    return;
                }
                if (!this.hasReceivedClientUdpResponseOfServerUdpMessage) {
                    if (!d.hasRemaining()) {
                        return;
                    }
                    if (d.get() != 85) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an incorrect response to the UDP handshake packet of the server");
                        }
                        this.disconnect();
                        return;
                    }
                    this.hasReceivedClientUdpResponseOfServerUdpMessage = true;
                    this.socketServer.handshakingUdpClientHandlers.remove(ByteBuffer.wrap(this.handshakingUdpId));
                    this.handshakingUdpId = null;
                    this.socketClient.onHandshakeCompletedUdp();
                }
                if (this.receivingStage == ReceivingStage.RECEIVE_TYPE) {
                    if (!d.hasRemaining()) {
                        return;
                    }
                    this.receivingType = d.get();
                    if (this.receivingType == 10) {
                        if (this.websocket == null) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a simulated unreliable message while not being a websocket");
                            }
                            this.disconnect();
                            return;
                        }
                        if (this.socketServer.serverUdp == null) {
                            if (SocketServer.IS_DEBUGGING) {
                                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a simulated unreliable message while the server isn't listening for UDP");
                            }
                            this.disconnect();
                            return;
                        }
                        this.receivingStage = ReceivingStage.RECEIVE_PACKET_SIZE;
                    } else if (this.receivingType == 1) {
                        this.receivingStage = ReceivingStage.RECEIVE_PACKET_SIZE;
                    } else if (this.receivingType == 2) {
                        this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                    } else if (this.receivingType == 4) {
                        this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                    } else if (this.receivingType == 6) {
                        this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                    } else if (this.receivingType == 7) {
                        this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                    } else {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid packet type, receiving stage: RECEIVE_TYPE, packet type: " + SocketMessageType.format(this.receivingType));
                        }
                        this.disconnect();
                        return;
                    }
                }
                if (this.receivingStage == ReceivingStage.RECEIVE_FUNCTION_CALL_ID) {
                    int receivedUint = this.receiveUint(d);
                    if (receivedUint < 0) {
                        return;
                    }
                    this.receivingFunctionCallId = receivedUint;
                    if (this.receivingType == 6) {
                        LatentResponse response;
                        buffer = this.latentResponses;
                        synchronized (buffer) {
                            response = this.latentResponses.remove(this.receivingFunctionCallId);
                        }
                        if (response != null) {
                            response.canceledByClient();
                        }
                        this.receivingStage = ReceivingStage.RECEIVE_TYPE;
                    } else if (this.receivingType == 7) {
                        this.socketClient.sendConnectionValidationResponse(this.receivingFunctionCallId);
                        this.socketListener.receivedConnectionValidation(this.socketServer, this.socketClient);
                        this.receivingStage = ReceivingStage.RECEIVE_TYPE;
                    } else {
                        this.receivingStage = ReceivingStage.RECEIVE_PACKET_SIZE;
                    }
                }
                if (this.receivingStage == ReceivingStage.RECEIVE_PACKET_SIZE) {
                    boolean startReceiving;
                    int receivedUint = this.receiveUint(d);
                    if (receivedUint < 0) {
                        return;
                    }
                    this.receivingPacketSize = receivedUint;
                    if (this.receivingType == 10) {
                        startReceiving = this.socketListener.startReceivingUnreliableMessage(this.socketServer, this.socketClient, this.receivingPacketSize);
                    } else if (this.receivingType == 1) {
                        startReceiving = this.socketListener.startReceivingMessage(this.socketServer, this.socketClient, this.receivingPacketSize);
                    } else if (this.receivingType == 2) {
                        startReceiving = this.socketListener.startReceivingFunctionCall(this.socketServer, this.socketClient, this.receivingPacketSize);
                    } else if (this.receivingType == 4) {
                        startReceiving = this.socketListener.startReceivingLatentFunctionCall(this.socketServer, this.socketClient, this.receivingPacketSize);
                    } else {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid packet type, receiving stage: RECEIVE_PACKET_SIZE, packet type: " + SocketMessageType.format(this.receivingType));
                        }
                        this.disconnect();
                        return;
                    }
                    if (!startReceiving) {
                        if (SocketServer.IS_DEBUGGING) {
                            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has been prevented from sending a packet, packet type: " + SocketMessageType.format(this.receivingType) + ", packet size: " + this.receivingPacketSize + " bytes");
                        }
                        this.disconnect();
                        return;
                    }
                    this.receivingPacket = new byte[this.receivingPacketSize];
                    this.receivingStage = ReceivingStage.RECEIVE_PACKET;
                }
                if (this.receivingStage != ReceivingStage.RECEIVE_PACKET) continue;
                if (!d.hasRemaining()) {
                    return;
                }
                int packetBytesRemaining = this.receivingPacketSize - this.receivingPacketPosition;
                int length = d.remaining();
                if (length <= packetBytesRemaining) {
                    d.get(this.receivingPacket, this.receivingPacketPosition, length);
                    this.receivingPacketPosition += length;
                } else {
                    d.get(this.receivingPacket, this.receivingPacketPosition, packetBytesRemaining);
                    this.receivingPacketPosition += packetBytesRemaining;
                }
                if (this.receivingPacketPosition < this.receivingPacketSize) continue;
                if (this.receivingType == 10) {
                    this.socketListener.receivedUnreliableMessage(this.socketServer, this.socketClient, ByteBuffer.wrap(this.receivingPacket));
                } else if (this.receivingType == 1) {
                    this.socketListener.receivedMessage(this.socketServer, this.socketClient, this.receivingPacket);
                } else if (this.receivingType == 2) {
                    byte[] returnBytes = this.socketListener.receivedFunctionCall(this.socketServer, this.socketClient, this.receivingPacket);
                    this.socketClient.sendFunctionCallResponse(this.receivingFunctionCallId, returnBytes);
                } else if (this.receivingType == 4) {
                    this.socketListener.receivedLatentFunctionCall(this.socketServer, this.socketClient, this.receivingPacket, new LatentResponseImplementation(this.latentResponses, this.socketClient, this.receivingFunctionCallId));
                } else {
                    if (SocketServer.IS_DEBUGGING) {
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent an invalid packet type, receiving stage: RECEIVE_PACKET, packet type: " + SocketMessageType.format(this.receivingType));
                    }
                    this.disconnect();
                    return;
                }
                this.receivingStage = ReceivingStage.RECEIVE_TYPE;
                this.receivingPacket = null;
                this.receivingPacketPosition = 0;
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    protected static class WebsocketReceivingData {
        public WebsocketReceivingStage receivingStage = WebsocketReceivingStage.RECEIVE_OPCODE;
        public WebsocketPacketType receivingType = WebsocketPacketType.DATA;
        public final byte[] sizePacket = new byte[8];
        public byte sizePacketIndex = 0;
        public boolean containsMask = false;
        public final byte[] mask = new byte[4];
        public byte maskIndex = 0;
        public long payloadRemainingByteCount = 0L;
        public ByteArrayOutputStream pingPacket = null;

        protected WebsocketReceivingData() {
        }

        protected static enum WebsocketReceivingStage {
            RECEIVE_OPCODE,
            RECEIVE_LENGTH_1,
            RECEIVE_LENGTH_2,
            RECEIVE_LENGTH_8,
            RECEIVE_MASK,
            RECEIVE_PAYLOAD;

        }

        protected static enum WebsocketPacketType {
            DATA,
            PING,
            PONG;

        }
    }

    protected static enum ReceivingStage {
        RECEIVE_TYPE,
        RECEIVE_FUNCTION_CALL_ID,
        RECEIVE_PACKET_SIZE,
        RECEIVE_PACKET;

    }
}

