/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets.simplification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import lowentry.ue4.classes.sockets.SimpleSocketClient;
import lowentry.ue4.classes.sockets.SimpleSocketServer;
import lowentry.ue4.classes.sockets.SimpleSocketServerListener;
import lowentry.ue4.classes.sockets.ThreadedSimpleSocketConnection;
import lowentry.ue4.classes.sockets.ThreadedSimpleSocketConnectionListener;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroServer;

public abstract class SimpleSocketServerMainListener
implements SimpleSocketServerListener,
Iterable<SimpleSocketClient> {
    private final Thread networkThread = Thread.currentThread();
    private final SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();
    private final ArrayList<ThreadedSimpleSocketConnection> socketConnections = new ArrayList();
    private volatile SimpleSocketServer server;
    private volatile boolean shouldRestart = false;
    private volatile boolean shouldStop = false;

    @Override
    public final void clientConnected(SimpleSocketServer server, SimpleSocketClient client) {
        try {
            this.clientConnected(client);
        }
        catch (Exception e) {
            client.disconnect();
            this.clientErrored(e);
        }
    }

    @Override
    public final void clientDisconnected(SimpleSocketServer server, SimpleSocketClient client) {
        try {
            this.clientDisconnected(client);
        }
        catch (Exception e) {
            this.clientErrored(e);
        }
    }

    @Override
    public final boolean canReceivePacket(SimpleSocketServer server, SimpleSocketClient client, int bytes) {
        try {
            return this.canReceivePacket(client, bytes);
        }
        catch (Exception e) {
            client.disconnect();
            this.clientErrored(e);
            return false;
        }
    }

    @Override
    public final void receivedPacket(SimpleSocketServer server, SimpleSocketClient client, byte[] bytes) {
        try {
            this.receivedPacket(client, bytes);
        }
        catch (Exception e) {
            client.disconnect();
            this.clientErrored(e);
        }
    }

    public abstract void hasStarted();

    public abstract void beforeGracefulShutdown();

    public abstract long getMaxTimeMsForGracefulShutdown();

    public abstract void hasStopped();

    public abstract void serverErrored(Exception var1);

    public abstract void clientErrored(Exception var1);

    public abstract void clientConnected(SimpleSocketClient var1);

    public abstract void clientDisconnected(SimpleSocketClient var1);

    public abstract long getTimeMsBeforeNextTick();

    public abstract void tick();

    public abstract boolean canReceivePacket(SimpleSocketClient var1, int var2);

    public abstract void receivedPacket(SimpleSocketClient var1, byte[] var2);

    public final boolean isNetworkThread() {
        return Thread.currentThread() == this.networkThread;
    }

    public final Thread networkThread() {
        return this.networkThread;
    }

    public final void checkThread() {
        if (!this.isNetworkThread()) {
            throw new PyroException("call from outside the network-thread, you must schedule tasks");
        }
    }

    public final void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.isNetworkThread()) {
            try {
                runnable.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        } else {
            this.tasks.put(runnable);
        }
    }

    protected final void executePendingTasks() {
        Object task;
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
        for (ThreadedSimpleSocketConnection connection : this.socketConnections) {
            connection.executePendingTasks();
        }
        try {
            this.executePendingUserTasks();
        }
        catch (Exception cause) {
            cause.printStackTrace();
        }
    }

    protected void executePendingUserTasks() {
    }

    public final ThreadedSimpleSocketConnection addSocketConnection(String host, int port, ThreadedSimpleSocketConnectionListener listener) {
        this.checkThread();
        ThreadedSimpleSocketConnection connection = new ThreadedSimpleSocketConnection(host, port, listener);
        connection.startAsync();
        this.socketConnections.add(connection);
        return connection;
    }

    public final void removeSocketConnection(ThreadedSimpleSocketConnection connection) {
        this.checkThread();
        if (connection == null) {
            return;
        }
        connection.stop();
        connection.executePendingTasks();
        this.socketConnections.remove(connection);
    }

    protected final void setServer(SimpleSocketServer server) {
        this.server = server;
        this.shouldRestart = false;
    }

    public final void restart() {
        this.shouldRestart = true;
    }

    public final void stop() {
        this.shouldStop = true;
    }

    public boolean getShouldRestart() {
        return this.shouldRestart;
    }

    public boolean getShouldStop() {
        return this.shouldStop;
    }

    @Override
    public Iterator<SimpleSocketClient> iterator() {
        return this.server.iterator();
    }

    public void forEachClient(Consumer<SimpleSocketClient> action) {
        this.server.forEach(action);
    }

    public int getClientCount() {
        return this.server.getClientCount();
    }

    public PyroServer pyro() {
        return this.server.pyro();
    }

    public PyroSelector selector() {
        return this.server.selector();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.server + "]";
    }
}

