/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class DynamicByteBuffer {
    protected static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected byte[] buf;
    protected int maxErased;
    protected int erased = 0;
    protected int count = 0;

    public DynamicByteBuffer() {
        this(32);
    }

    public DynamicByteBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
        this.maxErased = size / 3;
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            if (this.erased > this.maxErased && minCapacity - this.erased - this.buf.length <= 0) {
                this.cleanupOffset();
            } else {
                this.grow(minCapacity);
            }
        }
    }

    protected void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = DynamicByteBuffer.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
        this.maxErased = this.buf.length / 3;
    }

    protected static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    protected void cleanupOffset() {
        if (this.erased <= 0) {
            return;
        }
        if (this.count - this.erased <= 0) {
            this.reset();
            return;
        }
        int newCount = this.count - this.erased;
        System.arraycopy(this.buf, this.erased, this.buf, 0, newCount);
        this.erased = 0;
        this.count = newCount;
    }

    public void erase(int len) {
        Objects.checkFromIndexSize(0, len, this.count - this.erased);
        if (len <= 0) {
            return;
        }
        if (len >= this.count - this.erased) {
            this.reset();
            return;
        }
        this.erased += len;
    }

    public void erase(int off, int len) {
        Objects.checkFromIndexSize(off, len, this.count - this.erased);
        if (off <= 0) {
            this.erase(len);
            return;
        }
        if (len <= 0) {
            return;
        }
        if (off >= this.count - this.erased) {
            return;
        }
        if (off + len > this.count - this.erased) {
            len = this.count - this.erased - off;
        }
        int newCount = this.count - len;
        System.arraycopy(this.buf, this.erased + off + len, this.buf, this.erased + off, newCount - off);
        this.count = newCount;
    }

    public void put(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    public void put(byte[] b) {
        if (b.length <= 0) {
            return;
        }
        this.ensureCapacity(this.count + b.length);
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count += b.length;
    }

    public void put(byte[] b, int off, int len) {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len <= 0) {
            return;
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void put(ByteBuffer b) {
        if (!b.hasRemaining()) {
            return;
        }
        if (b.hasArray()) {
            this.ensureCapacity(this.count + b.remaining());
            System.arraycopy(b.array(), b.arrayOffset() + b.position(), this.buf, this.count, b.remaining());
            this.count += b.remaining();
            b.position(b.limit());
        } else {
            this.ensureCapacity(this.count + b.remaining());
            while (b.hasRemaining()) {
                this.buf[this.count] = b.get();
                ++this.count;
            }
        }
    }

    public void reset() {
        this.erased = 0;
        this.count = 0;
    }

    public int remaining() {
        return this.count - this.erased;
    }

    public boolean hasRemaining() {
        return this.count > this.erased;
    }

    public void writeToStream(OutputStream out) throws IOException {
        out.write(this.buf, this.erased, this.count - this.erased);
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buf, this.erased, this.count);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, this.erased, this.count - this.erased);
    }
}

