/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import java.util.HashMap;
import lowentry.ue4.classes.JsonArrayItem;
import lowentry.ue4.classes.JsonObjectItem;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.jackson.databind.JsonNode;

public class ExampleJson {
    public static void main(String[] args) throws Throwable {
        System.out.println("##### example data to JSON #####");
        Object root = new HashMap<String, Object>();
        ((HashMap)root).put("version", "1.0.0");
        ((HashMap)root).put("version_array", new int[]{1, 0, 0});
        ((HashMap)root).put("action", "LOGIN");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", "myusername");
        data.put("password", "mytopsecretpassword");
        ((HashMap)root).put("data", data);
        String jsonString = LowEntry.toJsonString(root, true);
        System.out.println(jsonString);
        System.out.print("\n\n");
        System.out.println("##### example parse and data retrieval #####");
        root = LowEntry.parseJsonString(jsonString);
        if (root == null) {
            System.out.println("parsing failed");
        } else {
            JsonNode jsonNode;
            JsonNode versionArrayNode;
            JsonNode jsonNode2;
            JsonNode actionNode = ((JsonNode)root).get("action");
            if (actionNode != null) {
                String string = actionNode.textValue();
                System.out.println("action: " + string);
            }
            if ((jsonNode2 = ((JsonNode)root).get("version")) != null) {
                String version = jsonNode2.textValue();
                System.out.println("version: " + version);
            }
            if ((versionArrayNode = ((JsonNode)root).get("version_array")) != null) {
                JsonNode versionArrayNode2;
                JsonNode versionArrayNode1;
                JsonNode jsonNode3 = versionArrayNode.get(0);
                if (jsonNode3 != null) {
                    int versionArray0 = jsonNode3.asInt();
                    System.out.println("version array 0: " + versionArray0);
                }
                if ((versionArrayNode1 = versionArrayNode.get(1)) != null) {
                    int versionArray1 = versionArrayNode1.asInt();
                    System.out.println("version array 1: " + versionArray1);
                }
                if ((versionArrayNode2 = versionArrayNode.get(2)) != null) {
                    int versionArray2 = versionArrayNode2.asInt();
                    System.out.println("version array 2: " + versionArray2);
                }
            }
            if ((jsonNode = ((JsonNode)root).get("data")) != null) {
                JsonNode dataPasswordNode;
                JsonNode dataUsernameNode = jsonNode.get("username");
                if (dataUsernameNode != null) {
                    String dataUsername = dataUsernameNode.textValue();
                    System.out.println("data username: " + dataUsername);
                }
                if ((dataPasswordNode = jsonNode.get("password")) != null) {
                    String dataPassword = dataPasswordNode.textValue();
                    System.out.println("data password: " + dataPassword);
                }
            }
        }
        System.out.print("\n\n");
        System.out.println("##### example parse and iterate #####");
        root = LowEntry.parseJsonString(jsonString);
        if (root == null) {
            System.out.println("parsing failed");
        } else if (((JsonNode)root).isArray()) {
            for (JsonArrayItem jsonArrayItem : LowEntry.getArrayNodes((JsonNode)root)) {
                if (jsonArrayItem.value.isArray()) {
                    for (JsonArrayItem jsonArrayItem2 : LowEntry.getArrayNodes(jsonArrayItem.value)) {
                        System.out.println("[" + jsonArrayItem.index + "][" + jsonArrayItem2.index + "] : " + jsonArrayItem2.value);
                    }
                    continue;
                }
                if (jsonArrayItem.value.isObject()) {
                    for (JsonObjectItem jsonObjectItem : LowEntry.getObjectNodes(jsonArrayItem.value)) {
                        System.out.println("[" + jsonArrayItem.index + "].\"" + jsonObjectItem.key + "\" : " + jsonObjectItem.value);
                    }
                    continue;
                }
                System.out.println("[" + jsonArrayItem.index + "] : " + jsonArrayItem.value);
            }
        } else if (((JsonNode)root).isObject()) {
            for (JsonObjectItem jsonObjectItem : LowEntry.getObjectNodes((JsonNode)root)) {
                if (jsonObjectItem.value.isArray()) {
                    for (JsonArrayItem jsonArrayItem : LowEntry.getArrayNodes(jsonObjectItem.value)) {
                        System.out.println("\"" + jsonObjectItem.key + "\"[" + jsonArrayItem.index + "] : " + jsonArrayItem.value);
                    }
                    continue;
                }
                if (jsonObjectItem.value.isObject()) {
                    for (JsonObjectItem jsonObjectItem2 : LowEntry.getObjectNodes(jsonObjectItem.value)) {
                        System.out.println("\"" + jsonObjectItem.key + "\".\"" + jsonObjectItem2.key + "\" : " + jsonObjectItem2.value);
                    }
                    continue;
                }
                System.out.println("\"" + jsonObjectItem.key + "\" : " + jsonObjectItem.value);
            }
        } else {
            System.out.println(root);
        }
    }
}

