/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.sockets.LatentResponse;
import lowentry.ue4.classes.sockets.SocketClient;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.classes.sockets.SocketServerListener;
import lowentry.ue4.library.LowEntry;

public class ExampleSocket1 {
    public static void main(String[] args) throws Throwable {
        SocketServerListener listener = new SocketServerListener(){

            @Override
            public void clientConnected(SocketServer server, SocketClient client) {
                System.out.println("[" + Thread.currentThread().getName() + "] ClientConnected: " + client);
                client.sendMessage(LowEntry.stringToBytesUtf8("hello newly connected client!"));
                for (SocketClient c : server) {
                    if (client == c) continue;
                    c.sendMessage(LowEntry.stringToBytesUtf8("another client connected!"));
                }
            }

            @Override
            public void clientDisconnected(SocketServer server, SocketClient client) {
                System.out.println("[" + Thread.currentThread().getName() + "] ClientDisconnected: " + client);
                for (SocketClient c : server) {
                    c.sendMessage(LowEntry.stringToBytesUtf8("another client disconnected!"));
                }
            }

            @Override
            public void receivedConnectionValidation(SocketServer server, SocketClient client) {
            }

            @Override
            public boolean startReceivingUnreliableMessage(SocketServer server, SocketClient client, int bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Start Receiving Unreliable Message");
                return bytes <= 1024;
            }

            @Override
            public void receivedUnreliableMessage(SocketServer server, SocketClient client, ByteBuffer bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Unreliable Message: \"" + LowEntry.bytesToStringUtf8(LowEntry.getBytesFromByteBuffer(bytes)) + "\"");
            }

            @Override
            public boolean startReceivingMessage(SocketServer server, SocketClient client, int bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Start Receiving Message");
                return bytes <= 10240;
            }

            @Override
            public void receivedMessage(SocketServer server, SocketClient client, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Message: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
            }

            @Override
            public boolean startReceivingFunctionCall(SocketServer server, SocketClient client, int bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Start Receiving Function Call");
                return bytes <= 10240;
            }

            @Override
            public byte[] receivedFunctionCall(SocketServer server, SocketClient client, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Function Call: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
                return null;
            }

            @Override
            public boolean startReceivingLatentFunctionCall(SocketServer server, SocketClient client, int bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Start Receiving Latent Function Call");
                return bytes <= 10240;
            }

            @Override
            public void receivedLatentFunctionCall(SocketServer server, SocketClient client, byte[] bytes, LatentResponse response) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Latent Function Call: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
                response.done(null);
            }
        };
        SocketServer server = new SocketServer(false, 7780, listener);
        System.out.println("Listening: " + server);
        while (true) {
            server.listen();
        }
    }
}

