/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import lowentry.ue4.classes.sockets.LatentFunctionCall;
import lowentry.ue4.classes.sockets.SocketConnection;
import lowentry.ue4.classes.sockets.SocketConnectionListener;
import lowentry.ue4.library.LowEntry;

public class ExampleSocket3 {
    public static void main(String[] args) throws Throwable {
        SocketConnectionListener listener = new SocketConnectionListener(){

            @Override
            public void connected(SocketConnection connection) {
                System.out.println("[" + Thread.currentThread().getName() + "] Connected: " + connection);
                connection.sendMessage(LowEntry.stringToBytesUtf8("hello server!"));
            }

            @Override
            public void disconnected(SocketConnection connection) {
                System.out.println("[" + Thread.currentThread().getName() + "] Disconnected: " + connection);
            }

            @Override
            public void receivedUnreliableMessage(SocketConnection connection, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Unreliable Message: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
            }

            @Override
            public void receivedMessage(SocketConnection connection, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Message: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
            }
        };
        SocketConnection connection = new SocketConnection("localhost", 7780, 7880, listener);
        if (!connection.connect()) {
            System.out.println("Failed to connect");
            System.exit(1);
        }
        connection.sendMessage(LowEntry.stringToBytesUtf8("test message"));
        connection.sendUnreliableMessage(LowEntry.stringToBytesUtf8("test udp message"));
        connection.sendFunctionCall(LowEntry.stringToBytesUtf8("test function call"), new SocketConnection.FunctionCallListener(){

            @Override
            public void receivedResponse(SocketConnection connection, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Function Call Response: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
            }

            @Override
            public void failed(SocketConnection connection) {
                System.out.println("[" + Thread.currentThread().getName() + "] Function Call failed");
            }
        });
        LatentFunctionCall latentFunctionCall = connection.sendLatentFunctionCall(LowEntry.stringToBytesUtf8("test latent function call"), new SocketConnection.LatentFunctionCallListener(){

            @Override
            public void receivedResponse(SocketConnection connection, byte[] bytes) {
                System.out.println("[" + Thread.currentThread().getName() + "] Received Latent Function Call Response: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
            }

            @Override
            public void canceled(SocketConnection connection) {
                System.out.println("[" + Thread.currentThread().getName() + "] Latent Function Call canceled");
            }

            @Override
            public void failed(SocketConnection connection) {
                System.out.println("[" + Thread.currentThread().getName() + "] Latent Function Call failed");
            }
        });
        new Thread(() -> {
            LowEntry.sleep(10000L);
            latentFunctionCall.cancel();
        }).start();
        while (connection.isConnected()) {
            connection.listen();
        }
    }
}

