/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.library;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import lowentry.ue4.classes.AesKey;
import lowentry.ue4.classes.BitDataReader;
import lowentry.ue4.classes.BitDataWriter;
import lowentry.ue4.classes.ByteDataReader;
import lowentry.ue4.classes.ByteDataWriter;
import lowentry.ue4.classes.JsonArrayItem;
import lowentry.ue4.classes.JsonObjectItem;
import lowentry.ue4.classes.ParsedHashcash;
import lowentry.ue4.classes.RsaKeys;
import lowentry.ue4.classes.RsaPrivateKey;
import lowentry.ue4.classes.RsaPublicKey;
import lowentry.ue4.classes.SimpleByteDataReader;
import lowentry.ue4.classes.SimpleByteDataWriter;
import lowentry.ue4.classes.bitdata.reader.BitArrayDataReader;
import lowentry.ue4.classes.bitdata.reader.BitBufferDataReader;
import lowentry.ue4.classes.bitdata.reader.BitSubArrayDataReader;
import lowentry.ue4.classes.bitdata.reader.BitSubBufferDataReader;
import lowentry.ue4.classes.bitdata.writer.BitBufferDataWriter;
import lowentry.ue4.classes.bitdata.writer.BitStreamDataWriter;
import lowentry.ue4.classes.bytedata.reader.ByteArrayDataReader;
import lowentry.ue4.classes.bytedata.reader.ByteBufferDataReader;
import lowentry.ue4.classes.bytedata.reader.ByteSubArrayDataReader;
import lowentry.ue4.classes.bytedata.reader.ByteSubBufferDataReader;
import lowentry.ue4.classes.bytedata.reader.SimpleByteArrayDataReader;
import lowentry.ue4.classes.bytedata.reader.SimpleByteBufferDataReader;
import lowentry.ue4.classes.bytedata.reader.SimpleByteSubArrayDataReader;
import lowentry.ue4.classes.bytedata.reader.SimpleByteSubBufferDataReader;
import lowentry.ue4.classes.bytedata.writer.ByteBufferDataWriter;
import lowentry.ue4.classes.bytedata.writer.ByteStreamDataWriter;
import lowentry.ue4.classes.bytedata.writer.SimpleByteBufferDataWriter;
import lowentry.ue4.classes.bytedata.writer.SimpleByteStreamDataWriter;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.internal.CompressionLzf;
import lowentry.ue4.classes.internal.EncryptionAes;
import lowentry.ue4.classes.internal.EncryptionRsa;
import lowentry.ue4.classes.internal.HashingBCrypt;
import lowentry.ue4.classes.internal.HashingHashcash;
import lowentry.ue4.classes.internal.HashingPearson;
import lowentry.ue4.libs.jackson.annotation.JsonInclude;
import lowentry.ue4.libs.jackson.core.JsonFactory;
import lowentry.ue4.libs.jackson.databind.JsonNode;
import lowentry.ue4.libs.jackson.databind.ObjectMapper;
import lowentry.ue4.libs.jackson.databind.ObjectReader;
import lowentry.ue4.libs.jackson.databind.ObjectWriter;
import lowentry.ue4.libs.jackson.databind.SerializationFeature;
import lowentry.ue4.libs.jackson.dataformat.yaml.YAMLFactory;
import lowentry.ue4.libs.jackson.dataformat.yaml.YAMLGenerator;

public class LowEntry {
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final ObjectReader JSON_READER;
    public static final ObjectWriter JSON_WRITER_PERFORMANCE;
    public static final ObjectWriter JSON_WRITER_READABILITY;
    public static final ObjectMapper YAML;
    public static final char[] HEX_CHARS;
    public static final byte BOOLEAN_TRUE_BYTE = 1;
    public static final byte BOOLEAN_FALSE_BYTE = 0;
    public static final boolean IS_WINDOWS;
    public static final ThreadLocal<DateFormat> dateformatIso8601;
    public static final ThreadLocal<MessageDigest> hashingDigestMd5;
    public static final ThreadLocal<MessageDigest> hashingDigestSha1;
    public static final ThreadLocal<MessageDigest> hashingDigestSha256;
    public static final ThreadLocal<MessageDigest> hashingDigestSha512;

    public static void printStackTrace(Throwable e) {
        if (e == null) {
            return;
        }
        System.err.print(LowEntry.getStackTrace(e));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(Throwable e) {
        if (e == null) {
            return "";
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            try {
                e.printStackTrace(ps);
                String string = baos.toString();
                ps.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            return "";
        }
    }

    public static void sleep(double millis) {
        LowEntry.sleep((long)millis);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long cachedCurrentTimeMillis() {
        return CachedTime.currentTimeMillis();
    }

    public static long cachedNanoTime() {
        return CachedTime.nanoTime();
    }

    public static long millisSinceStart() {
        return CachedTime.millisSinceStart();
    }

    public static long millis() {
        return CachedTime.millisSinceStart();
    }

    public static boolean areBytesEqual(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areBytesEqual(byte[] a, int indexA, int lengthA, byte[] b, int indexB, int lengthB) {
        if (a == null || b == null) {
            return false;
        }
        if (indexA < 0) {
            lengthA += indexA;
            indexA = 0;
        }
        if (lengthA > a.length - indexA) {
            lengthA = a.length - indexA;
        }
        if (lengthA < 0) {
            lengthA = 0;
        }
        if (indexB < 0) {
            lengthB += indexB;
            indexB = 0;
        }
        if (lengthB > b.length - indexB) {
            lengthB = b.length - indexB;
        }
        if (lengthB < 0) {
            lengthB = 0;
        }
        if (lengthA != lengthB) {
            return false;
        }
        for (int i = 0; i < lengthA; ++i) {
            if (a[indexA + i] == b[indexB + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[][] splitBytes(byte[] bytes, int firstArrayLength) {
        if (bytes == null || bytes.length <= 0) {
            return new byte[][]{new byte[0], new byte[0]};
        }
        if (firstArrayLength <= 0) {
            return new byte[][]{new byte[0], bytes};
        }
        if (firstArrayLength >= bytes.length) {
            return new byte[][]{bytes, new byte[0]};
        }
        byte[] a = new byte[firstArrayLength];
        byte[] b = new byte[bytes.length - firstArrayLength];
        System.arraycopy(bytes, 0, a, 0, a.length);
        System.arraycopy(bytes, a.length, b, 0, b.length);
        return new byte[][]{a, b};
    }

    public static byte[] mergeBytes(byte[] ... arrays) {
        if (arrays == null || arrays.length <= 0) {
            return new byte[0];
        }
        if (arrays.length == 1) {
            byte[] array = arrays[0];
            if (array == null) {
                return new byte[0];
            }
            return array;
        }
        int length = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] merged = new byte[length];
        int index = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static byte[] mergeBytes(Collection<byte[]> arrays) {
        if (arrays == null || arrays.size() <= 0) {
            return new byte[0];
        }
        if (arrays.size() == 1) {
            byte[] array = arrays.iterator().next();
            if (array == null) {
                return new byte[0];
            }
            return array;
        }
        int length = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] merged = new byte[length];
        int index = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static byte[] bytesSubArray(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return new byte[0];
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return new byte[0];
        }
        if (index == 0 && length == bytes.length) {
            return bytes;
        }
        byte[] c = new byte[length];
        System.arraycopy(bytes, index, c, 0, c.length);
        return c;
    }

    public static byte[] generateRandomBytes(int length) {
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateRandomBytes(int minLength, int maxLength) {
        int min;
        int diff;
        if (minLength < 0) {
            minLength = 0;
        }
        if (maxLength < 0) {
            maxLength = 0;
        }
        if (maxLength >= minLength) {
            diff = maxLength - minLength;
            min = minLength;
        } else {
            diff = minLength - maxLength;
            min = maxLength;
        }
        if (min == 0 && diff == 0) {
            return new byte[0];
        }
        int length = SECURE_RANDOM.nextInt(diff + 1) + min;
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateRandomBytesFast(int length) {
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateRandomBytesFast(int minLength, int maxLength) {
        int min;
        int diff;
        if (minLength < 0) {
            minLength = 0;
        }
        if (maxLength < 0) {
            maxLength = 0;
        }
        if (maxLength >= minLength) {
            diff = maxLength - minLength;
            min = minLength;
        } else {
            diff = minLength - maxLength;
            min = maxLength;
        }
        if (min == 0 && diff == 0) {
            return new byte[0];
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int length = random.nextInt(diff + 1) + min;
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] getBytesFromByteBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[buffer.remaining()];
        int pos = buffer.position();
        buffer.get(bytes);
        buffer.position(pos);
        return bytes;
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return LowEntry.cloneByteBuffer(buffer, buffer.isDirect());
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buffer, boolean shouldCopyUseAllocateDirect) {
        if (buffer == null) {
            return null;
        }
        int pos = buffer.position();
        ByteBuffer copy = shouldCopyUseAllocateDirect ? ByteBuffer.allocateDirect(buffer.remaining()) : ByteBuffer.allocate(buffer.remaining());
        copy.put(buffer);
        buffer.position(pos);
        copy.flip();
        return copy;
    }

    public static String bytesToStringUtf8(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bytesToStringUtf8(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        try {
            return new String(bytes, index, length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] stringToBytesUtf8(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String bytesToStringLatin1(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        try {
            return new String(bytes, StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bytesToStringLatin1(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        try {
            return new String(bytes, index, length, StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] stringToBytesLatin1(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes(StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String bytesToBase64(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String bytesToBase64(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        if (index == 0 && length == bytes.length) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return Base64.getEncoder().encodeToString(LowEntry.bytesSubArray(bytes, index, length));
    }

    public static byte[] base64ToBytes(String base64) {
        if (base64 == null) {
            return new byte[0];
        }
        try {
            return Base64.getDecoder().decode(base64);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String bytesToHex(byte[] bytes) {
        return LowEntry.bytesToHex(bytes, false);
    }

    public static String bytesToHex(byte[] bytes, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS[v >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        String hex = new String(hexChars);
        if (!addSpaces) {
            return hex;
        }
        return LowEntry.padHexString(hex);
    }

    public static String bytesToHex(byte[] bytes, int index, int length) {
        return LowEntry.bytesToHex(bytes, index, length, false);
    }

    public static String bytesToHex(byte[] bytes, int index, int length, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        if (index != 0 || length != bytes.length) {
            bytes = LowEntry.bytesSubArray(bytes, index, length);
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS[v >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        String hex = new String(hexChars);
        if (!addSpaces) {
            return hex;
        }
        return LowEntry.padHexString(hex);
    }

    protected static String padHexString(String hex) {
        StringBuilder stringBuilder = new StringBuilder(hex.length() / 2 * 3);
        char[] chars = hex.toCharArray();
        for (int i = 1; i <= chars.length; ++i) {
            stringBuilder.append(chars[i - 1]);
            if (i % 2 != 0 || i >= chars.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static byte[] hexToBytes(String hex) {
        if (hex == null || hex.length() <= 0) {
            return new byte[0];
        }
        try {
            hex = hex.replaceAll(" ", "");
            int len = hex.length();
            byte[] bytes = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                bytes[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            }
            return bytes;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String bytesToBinary(byte[] bytes) {
        return LowEntry.bytesToBinary(bytes, false);
    }

    public static String bytesToBinary(byte[] bytes, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(bytes.length * (addSpaces ? 9 : 8));
        for (int i = 1; i <= bytes.length; ++i) {
            for (int j = 7; j >= 0; --j) {
                if ((bytes[i - 1] & 1 << j) > 0) {
                    stringBuilder.append("1");
                    continue;
                }
                stringBuilder.append("0");
            }
            if (!addSpaces || i >= bytes.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String bytesToBinary(byte[] bytes, int index, int length) {
        return LowEntry.bytesToBinary(bytes, index, length, false);
    }

    public static String bytesToBinary(byte[] bytes, int index, int length, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(length * (addSpaces ? 9 : 8));
        for (int i = 1; i <= length; ++i) {
            for (int j = 7; j >= 0; --j) {
                if ((bytes[index + (i - 1)] & 1 << j) > 0) {
                    stringBuilder.append("1");
                    continue;
                }
                stringBuilder.append("0");
            }
            if (!addSpaces || i >= length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static byte[] binaryToBytes(String binary) {
        if (binary == null || binary.length() <= 0) {
            return new byte[0];
        }
        if ((binary = binary.replaceAll(" ", "")).length() <= 0 || binary.length() % 8 != 0) {
            return new byte[0];
        }
        char[] bits = binary.toCharArray();
        byte[] bytes = new byte[binary.length() / 8];
        int index = 0;
        for (int i = 0; i < binary.length(); i += 8) {
            byte b = 0;
            for (int j = 0; j < 8; ++j) {
                if (bits[i + j] == '0') continue;
                if (bits[i + j] == '1') {
                    b = (byte)(b + (1 << 7 - j));
                    continue;
                }
                return new byte[0];
            }
            bytes[index] = b;
            ++index;
        }
        return bytes;
    }

    public static String bytesToBitString(byte[] bytes) {
        return LowEntry.bytesToBitString(bytes, false);
    }

    public static String bytesToBitString(byte[] bytes, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(bytes.length * (addSpaces ? 9 : 8));
        for (int i = 1; i <= bytes.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((bytes[i - 1] & 1 << j) > 0) {
                    stringBuilder.append("1");
                    continue;
                }
                stringBuilder.append("0");
            }
            if (!addSpaces || i >= bytes.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String bytesToBitString(byte[] bytes, int index, int length) {
        return LowEntry.bytesToBitString(bytes, index, length, false);
    }

    public static String bytesToBitString(byte[] bytes, int index, int length, boolean addSpaces) {
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(length * (addSpaces ? 9 : 8));
        for (int i = 1; i <= length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((bytes[index + (i - 1)] & 1 << j) > 0) {
                    stringBuilder.append("1");
                    continue;
                }
                stringBuilder.append("0");
            }
            if (!addSpaces || i >= length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static byte[] bitStringToBytes(String bits) {
        if (bits == null || bits.length() <= 0) {
            return new byte[0];
        }
        if ((bits = bits.replaceAll(" ", "")).length() <= 0 || bits.length() % 8 != 0) {
            return new byte[0];
        }
        char[] bitss = bits.toCharArray();
        byte[] bytes = new byte[bits.length() / 8];
        int index = 0;
        for (int i = 0; i < bits.length(); i += 8) {
            byte b = 0;
            for (int j = 0; j < 8; ++j) {
                if (bitss[i + j] == '0') continue;
                if (bitss[i + j] == '1') {
                    b = (byte)(b + (1 << j));
                    continue;
                }
                return new byte[0];
            }
            bytes[index] = b;
            ++index;
        }
        return bytes;
    }

    public static boolean bytesToBoolean(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return false;
        }
        return bytes[0] == 1;
    }

    public static boolean bytesToBoolean(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return false;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return false;
        }
        return bytes[index] == 1;
    }

    public static byte[] booleanToBytes(boolean value) {
        if (value) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    public static boolean byteToBoolean(byte bytes) {
        return bytes == 1;
    }

    public static byte booleanToByte(boolean value) {
        if (value) {
            return 1;
        }
        return 0;
    }

    public static int bytesToInteger(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return 0;
        }
        if (bytes.length <= 1) {
            return bytes[0] & 0xFF;
        }
        if (bytes.length <= 2) {
            return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        }
        if (bytes.length <= 3) {
            return (bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF;
        }
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int bytesToInteger(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return 0;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return 0;
        }
        if (length <= 1) {
            return bytes[index] & 0xFF;
        }
        if (length <= 2) {
            return (bytes[index] & 0xFF) << 8 | bytes[index + 1] & 0xFF;
        }
        if (length <= 3) {
            return (bytes[index] & 0xFF) << 16 | (bytes[index + 1] & 0xFF) << 8 | bytes[index + 2] & 0xFF;
        }
        return (bytes[index] & 0xFF) << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF;
    }

    public static byte[] integerToBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static float bytesToFloat(byte[] bytes) {
        return Float.intBitsToFloat(LowEntry.bytesToInteger(bytes));
    }

    public static float bytesToFloat(byte[] bytes, int index, int length) {
        return Float.intBitsToFloat(LowEntry.bytesToInteger(bytes, index, length));
    }

    public static byte[] floatToBytes(float value) {
        return LowEntry.integerToBytes(Float.floatToIntBits(value));
    }

    public static long bytesToLong(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return 0L;
        }
        if (bytes.length <= 1) {
            return (long)bytes[0] & 0xFFL;
        }
        if (bytes.length <= 2) {
            return ((long)bytes[0] & 0xFFL) << 8 | (long)bytes[1] & 0xFFL;
        }
        if (bytes.length <= 3) {
            return ((long)bytes[0] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[2] & 0xFFL;
        }
        if (bytes.length <= 4) {
            return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
        }
        if (bytes.length <= 5) {
            return ((long)bytes[0] & 0xFFL) << 32 | ((long)bytes[1] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 8 | (long)bytes[4] & 0xFFL;
        }
        if (bytes.length <= 6) {
            return ((long)bytes[0] & 0xFFL) << 40 | ((long)bytes[1] & 0xFFL) << 32 | ((long)bytes[2] & 0xFFL) << 24 | ((long)bytes[3] & 0xFFL) << 16 | ((long)bytes[4] & 0xFFL) << 8 | (long)bytes[5] & 0xFFL;
        }
        if (bytes.length <= 7) {
            return ((long)bytes[0] & 0xFFL) << 48 | ((long)bytes[1] & 0xFFL) << 40 | ((long)bytes[2] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 16 | ((long)bytes[5] & 0xFFL) << 8 | (long)bytes[6] & 0xFFL;
        }
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static long bytesToLong(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return 0L;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return 0L;
        }
        if (length <= 1) {
            return (long)bytes[index] & 0xFFL;
        }
        if (length <= 2) {
            return ((long)bytes[index] & 0xFFL) << 8 | (long)bytes[index + 1] & 0xFFL;
        }
        if (length <= 3) {
            return ((long)bytes[index] & 0xFFL) << 16 | ((long)bytes[index + 1] & 0xFFL) << 8 | (long)bytes[index + 2] & 0xFFL;
        }
        if (length <= 4) {
            return ((long)bytes[index] & 0xFFL) << 24 | ((long)bytes[index + 1] & 0xFFL) << 16 | ((long)bytes[index + 2] & 0xFFL) << 8 | (long)bytes[index + 3] & 0xFFL;
        }
        if (length <= 5) {
            return ((long)bytes[index] & 0xFFL) << 32 | ((long)bytes[index + 1] & 0xFFL) << 24 | ((long)bytes[index + 2] & 0xFFL) << 16 | ((long)bytes[index + 3] & 0xFFL) << 8 | (long)bytes[index + 4] & 0xFFL;
        }
        if (length <= 6) {
            return ((long)bytes[index] & 0xFFL) << 40 | ((long)bytes[index + 1] & 0xFFL) << 32 | ((long)bytes[index + 2] & 0xFFL) << 24 | ((long)bytes[index + 3] & 0xFFL) << 16 | ((long)bytes[index + 4] & 0xFFL) << 8 | (long)bytes[index + 5] & 0xFFL;
        }
        if (length <= 7) {
            return ((long)bytes[index] & 0xFFL) << 48 | ((long)bytes[index + 1] & 0xFFL) << 40 | ((long)bytes[index + 2] & 0xFFL) << 32 | ((long)bytes[index + 3] & 0xFFL) << 24 | ((long)bytes[index + 4] & 0xFFL) << 16 | ((long)bytes[index + 5] & 0xFFL) << 8 | (long)bytes[index + 6] & 0xFFL;
        }
        return ((long)bytes[index] & 0xFFL) << 56 | ((long)bytes[index + 1] & 0xFFL) << 48 | ((long)bytes[index + 2] & 0xFFL) << 40 | ((long)bytes[index + 3] & 0xFFL) << 32 | ((long)bytes[index + 4] & 0xFFL) << 24 | ((long)bytes[index + 5] & 0xFFL) << 16 | ((long)bytes[index + 6] & 0xFFL) << 8 | (long)bytes[index + 7] & 0xFFL;
    }

    public static byte[] longToBytes(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static double bytesToDouble(byte[] bytes) {
        return Double.longBitsToDouble(LowEntry.bytesToLong(bytes));
    }

    public static double bytesToDouble(byte[] bytes, int index, int length) {
        return Double.longBitsToDouble(LowEntry.bytesToLong(bytes, index, length));
    }

    public static byte[] doubleToBytes(double value) {
        return LowEntry.longToBytes(Double.doubleToLongBits(value));
    }

    public static byte bytesToByte(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return 0;
        }
        return bytes[0];
    }

    public static byte bytesToByte(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            return 0;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            return 0;
        }
        return bytes[index];
    }

    public static byte[] byteToBytes(byte value) {
        return new byte[]{value};
    }

    public static byte bitsToByte(boolean bit8, boolean bit7, boolean bit6, boolean bit5, boolean bit4, boolean bit3, boolean bit2, boolean bit1) {
        byte b = 0;
        if (bit8) {
            b = (byte)(b | 0x80);
        }
        if (bit7) {
            b = (byte)(b | 0x40);
        }
        if (bit6) {
            b = (byte)(b | 0x20);
        }
        if (bit5) {
            b = (byte)(b | 0x10);
        }
        if (bit4) {
            b = (byte)(b | 8);
        }
        if (bit3) {
            b = (byte)(b | 4);
        }
        if (bit2) {
            b = (byte)(b | 2);
        }
        if (bit1) {
            b = (byte)(b | 1);
        }
        return b;
    }

    public static byte bitsToByte(boolean[] bits) {
        byte b = 0;
        if (bits == null) {
            return b;
        }
        if (bits.length >= 1 && bits[0]) {
            b = (byte)(b | 0x80);
        }
        if (bits.length >= 2 && bits[1]) {
            b = (byte)(b | 0x40);
        }
        if (bits.length >= 3 && bits[2]) {
            b = (byte)(b | 0x20);
        }
        if (bits.length >= 4 && bits[3]) {
            b = (byte)(b | 0x10);
        }
        if (bits.length >= 5 && bits[4]) {
            b = (byte)(b | 8);
        }
        if (bits.length >= 6 && bits[5]) {
            b = (byte)(b | 4);
        }
        if (bits.length >= 7 && bits[6]) {
            b = (byte)(b | 2);
        }
        if (bits.length >= 8 && bits[7]) {
            b = (byte)(b | 1);
        }
        return b;
    }

    public static byte bitsToByte(boolean[] bits, int index, int length) {
        if (bits == null || bits.length <= 0) {
            return 0;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bits.length - index) {
            length = bits.length - index;
        }
        if (length <= 0) {
            return 0;
        }
        byte b = 0;
        if (bits[index]) {
            b = (byte)(b | 0x80);
        }
        if (length >= 2 && bits[index + 1]) {
            b = (byte)(b | 0x40);
        }
        if (length >= 3 && bits[index + 2]) {
            b = (byte)(b | 0x20);
        }
        if (length >= 4 && bits[index + 3]) {
            b = (byte)(b | 0x10);
        }
        if (length >= 5 && bits[index + 4]) {
            b = (byte)(b | 8);
        }
        if (length >= 6 && bits[index + 5]) {
            b = (byte)(b | 4);
        }
        if (length >= 7 && bits[index + 6]) {
            b = (byte)(b | 2);
        }
        if (length >= 8 && bits[index + 7]) {
            b = (byte)(b | 1);
        }
        return b;
    }

    public static boolean[] byteToBits(byte b) {
        boolean[] bits = new boolean[]{(b >> 7 & 1) != 0, (b >> 6 & 1) != 0, (b >> 5 & 1) != 0, (b >> 4 & 1) != 0, (b >> 3 & 1) != 0, (b >> 2 & 1) != 0, (b >> 1 & 1) != 0, (b & 1) != 0};
        return bits;
    }

    public static boolean isBitSet(byte b, int bit) {
        return (b >> --bit & 1) != 0;
    }

    public static byte getByteWithBitSet(byte b, int bit, boolean value) {
        --bit;
        if (value) {
            return (byte)(b | 1 << bit);
        }
        return (byte)(b & ~(1 << bit));
    }

    public static boolean isBitSet(byte[] b, int bit) {
        int bindex;
        if (b == null || b.length == 0) {
            return false;
        }
        if (b.length <= (bindex = --bit / 8)) {
            return false;
        }
        return (b[bindex] >> (bit %= 8) & 1) != 0;
    }

    public static void setBit(byte[] b, int bit, boolean value) {
        int bindex;
        if (b == null || b.length == 0) {
            return;
        }
        if (b.length <= (bindex = --bit / 8)) {
            return;
        }
        b[bindex] = value ? (byte)(b[bindex] | 1 << bit) : (byte)(b[bindex] & ~(1 << (bit %= 8)));
    }

    public static byte getByteWithReverseBits(byte b) {
        byte b2 = 0;
        for (int position = 7; position >= 0; --position) {
            b2 = (byte)(b2 + ((b & 1) << position));
            b = (byte)(b >> 1);
        }
        return b2;
    }

    public static void reverseBitsIndividually(byte[] b) {
        if (b == null || b.length == 0) {
            return;
        }
        for (int i = 0; i < b.length; ++i) {
            byte b2 = 0;
            for (int position = 7; position >= 0; --position) {
                b2 = (byte)(b2 + ((b[i] & 1) << position));
                int n = i;
                b[n] = (byte)(b[n] >> 1);
            }
            b[i] = b2;
        }
    }

    public static void reverseBitsIndividually(byte[] b, int index, int length) {
        if (b == null || b.length == 0) {
            return;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > b.length - index) {
            length = b.length - index;
        }
        if (length <= 0) {
            return;
        }
        for (int i = index; i < index + length; ++i) {
            byte b2 = 0;
            for (int position = 7; position >= 0; --position) {
                b2 = (byte)(b2 + ((b[i] & 1) << position));
                int n = i;
                b[n] = (byte)(b[n] >> 1);
            }
            b[i] = b2;
        }
    }

    public static void reverseBitsCombined(byte[] b) {
        if (b == null || b.length == 0) {
            return;
        }
        LowEntry.reverseBitsIndividually(b);
        int i = 0;
        for (int j = b.length - 1; j > i; --j, ++i) {
            byte tmp = b[j];
            b[j] = b[i];
            b[i] = tmp;
        }
    }

    public static void reverseBitsCombined(byte[] b, int index, int length) {
        if (b == null || b.length == 0) {
            return;
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > b.length - index) {
            length = b.length - index;
        }
        if (length <= 0) {
            return;
        }
        LowEntry.reverseBitsIndividually(b, index, length);
        int i = index;
        for (int j = length - 1; j > i; --j, ++i) {
            byte tmp = b[j];
            b[j] = b[i];
            b[i] = tmp;
        }
    }

    public static byte[] pearson(byte[] bytes, int hashLength) {
        return HashingPearson.generatePearsonHash(bytes, hashLength);
    }

    public static byte[] pearson(byte[] bytes, int index, int length, int hashLength) {
        return HashingPearson.generatePearsonHash(bytes, index, length, hashLength);
    }

    public static byte[] md5(byte[] bytes) {
        return LowEntry.hash(hashingDigestMd5.get(), bytes);
    }

    public static byte[] md5(byte[] bytes, int index, int length) {
        return LowEntry.hash(hashingDigestMd5.get(), bytes, index, length);
    }

    public static byte[] sha1(byte[] bytes) {
        return LowEntry.hash(hashingDigestSha1.get(), bytes);
    }

    public static byte[] sha1(byte[] bytes, int index, int length) {
        return LowEntry.hash(hashingDigestSha1.get(), bytes, index, length);
    }

    public static byte[] sha256(byte[] bytes) {
        return LowEntry.hash(hashingDigestSha256.get(), bytes);
    }

    public static byte[] sha256(byte[] bytes, int index, int length) {
        return LowEntry.hash(hashingDigestSha256.get(), bytes, index, length);
    }

    public static byte[] sha512(byte[] bytes) {
        return LowEntry.hash(hashingDigestSha512.get(), bytes);
    }

    public static byte[] sha512(byte[] bytes, int index, int length) {
        return LowEntry.hash(hashingDigestSha512.get(), bytes, index, length);
    }

    public static byte[] bcrypt(byte[] bytes, byte[] salt, int strength) {
        return new HashingBCrypt().hash(bytes, salt, strength);
    }

    public static byte[] bcrypt(byte[] bytes, int index, int length, byte[] salt, int strength) {
        return new HashingBCrypt().hash(LowEntry.bytesSubArray(bytes, index, length), salt, strength);
    }

    public static String[] hashcash(String[] resources, int bits) {
        return HashingHashcash.hash(resources, null, bits);
    }

    public static String[] hashcash(String[] resources, Date date, int bits) {
        return HashingHashcash.hash(resources, date, bits);
    }

    public static String hashcash(String resource, int bits) {
        return HashingHashcash.hash(resource, null, bits);
    }

    public static String hashcash(String resource, Date date, int bits) {
        return HashingHashcash.hash(resource, date, bits);
    }

    public static ParsedHashcash[] parseHashcash(String[] hashes) {
        return HashingHashcash.parse(hashes);
    }

    public static ParsedHashcash parseHashcash(String hash) {
        return HashingHashcash.parse(hash);
    }

    public static byte[] hash(String algorithm, byte[] bytes) {
        try {
            return LowEntry.hash(MessageDigest.getInstance(algorithm), bytes);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] hash(MessageDigest hasher, byte[] bytes) {
        try {
            hasher.reset();
            if (bytes != null && bytes.length > 0) {
                hasher.update(bytes);
            }
            return hasher.digest();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] hash(String algorithm, byte[] bytes, int index, int length) {
        try {
            return LowEntry.hash(MessageDigest.getInstance(algorithm), bytes, index, length);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] hash(MessageDigest hasher, byte[] bytes, int index, int length) {
        if (bytes == null) {
            length = 0;
        } else {
            if (index < 0) {
                length += index;
                index = 0;
            }
            if (length > bytes.length - index) {
                length = bytes.length - index;
            }
        }
        try {
            hasher.reset();
            if (length > 0) {
                hasher.update(bytes, index, length);
            }
            return hasher.digest();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String createString(int length, String filler) {
        if (length <= 0) {
            return "";
        }
        int steps = filler.length();
        if (steps <= 0) {
            filler = " ";
            steps = filler.length();
        }
        int overflow = (steps - length % steps) % steps;
        StringBuilder stringBuilder = new StringBuilder();
        if (overflow <= 0) {
            for (int i = 0; i < length; i += steps) {
                stringBuilder.append(filler);
            }
        } else {
            for (int i = steps; i < length; i += steps) {
                stringBuilder.append(filler);
            }
            stringBuilder.append(filler, 0, steps - overflow);
        }
        return stringBuilder.toString();
    }

    public static SimpleByteDataReader readSimpleByteData(byte[] bytes) {
        return new SimpleByteArrayDataReader(bytes);
    }

    public static SimpleByteDataReader readSimpleByteData(byte[] bytes, int index, int length) {
        if (bytes == null) {
            return new SimpleByteArrayDataReader(null);
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (index == 0) {
            return new SimpleByteArrayDataReader(bytes, length);
        }
        return new SimpleByteSubArrayDataReader(bytes, index, length);
    }

    public static SimpleByteDataReader readSimpleByteData(ByteBuffer bytes) {
        if (bytes == null || bytes.position() <= 0) {
            return new SimpleByteBufferDataReader(bytes);
        }
        return new SimpleByteSubBufferDataReader(bytes, bytes.position(), bytes.remaining());
    }

    public static SimpleByteDataReader readSimpleByteData(ByteBuffer bytes, int index, int length) {
        if (bytes == null) {
            return new SimpleByteBufferDataReader(null);
        }
        if ((index += bytes.position()) < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.remaining() - index) {
            length = bytes.remaining() - index;
        }
        if (index == 0) {
            return new SimpleByteBufferDataReader(bytes, length);
        }
        return new SimpleByteSubBufferDataReader(bytes, index, length);
    }

    public static SimpleByteDataWriter writeSimpleByteData() {
        return new SimpleByteStreamDataWriter();
    }

    public static SimpleByteDataWriter writeSimpleByteData(ByteBuffer buffer) {
        return new SimpleByteBufferDataWriter(buffer);
    }

    public static ByteDataReader readByteData(byte[] bytes) {
        return new ByteArrayDataReader(bytes);
    }

    public static ByteDataReader readByteData(byte[] bytes, int index, int length) {
        if (bytes == null) {
            return new ByteArrayDataReader(null);
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (index == 0) {
            return new ByteArrayDataReader(bytes, length);
        }
        return new ByteSubArrayDataReader(bytes, index, length);
    }

    public static ByteDataReader readByteData(ByteBuffer bytes) {
        if (bytes == null || bytes.position() <= 0) {
            return new ByteBufferDataReader(bytes);
        }
        return new ByteSubBufferDataReader(bytes, bytes.position(), bytes.remaining());
    }

    public static ByteDataReader readByteData(ByteBuffer bytes, int index, int length) {
        if (bytes == null) {
            return new ByteBufferDataReader(null);
        }
        if ((index += bytes.position()) < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.remaining() - index) {
            length = bytes.remaining() - index;
        }
        if (index == 0) {
            return new ByteBufferDataReader(bytes, length);
        }
        return new ByteSubBufferDataReader(bytes, index, length);
    }

    public static ByteDataWriter writeByteData() {
        return new ByteStreamDataWriter();
    }

    public static ByteDataWriter writeByteData(ByteBuffer buffer) {
        return new ByteBufferDataWriter(buffer);
    }

    public static BitDataReader readBitData(byte[] bytes) {
        return new BitArrayDataReader(bytes);
    }

    public static BitDataReader readBitData(byte[] bytes, int index, int length) {
        if (bytes == null) {
            return new BitArrayDataReader(null);
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (index == 0) {
            return new BitArrayDataReader(bytes, length);
        }
        return new BitSubArrayDataReader(bytes, index, length);
    }

    public static BitDataReader readBitData(ByteBuffer bytes) {
        if (bytes == null || bytes.position() <= 0) {
            return new BitBufferDataReader(bytes);
        }
        return new BitSubBufferDataReader(bytes, bytes.position(), bytes.remaining());
    }

    public static BitDataReader readBitData(ByteBuffer bytes, int index, int length) {
        if (bytes == null) {
            return new BitBufferDataReader(null);
        }
        if ((index += bytes.position()) < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.remaining() - index) {
            length = bytes.remaining() - index;
        }
        if (index == 0) {
            return new BitBufferDataReader(bytes, length);
        }
        return new BitSubBufferDataReader(bytes, index, length);
    }

    public static BitDataWriter writeBitData() {
        return new BitStreamDataWriter();
    }

    public static BitDataWriter writeBitData(ByteBuffer buffer) {
        return new BitBufferDataWriter(buffer);
    }

    public static JsonNode parseJsonString(String json) {
        try {
            return JSON_READER.readTree(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toJsonString(Object object) {
        return LowEntry.toJsonString(object, false);
    }

    public static String toJsonString(Object object, boolean prettyPrint) {
        try {
            if (prettyPrint) {
                return JSON_WRITER_READABILITY.writeValueAsString(object);
            }
            return JSON_WRITER_PERFORMANCE.writeValueAsString(object);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static ArrayList<JsonObjectItem> getObjectNodes(JsonNode node) {
        ArrayList<JsonObjectItem> list = new ArrayList<JsonObjectItem>();
        if (node == null) {
            return list;
        }
        if (node.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                list.add(new JsonObjectItem(entry.getKey(), entry.getValue()));
            }
        } else {
            int i = 0;
            for (JsonNode subnode : node) {
                list.add(new JsonObjectItem("" + i, subnode));
                ++i;
            }
        }
        return list;
    }

    public static ArrayList<JsonArrayItem> getArrayNodes(JsonNode node) {
        ArrayList<JsonArrayItem> list = new ArrayList<JsonArrayItem>();
        if (node == null) {
            return list;
        }
        int i = 0;
        for (JsonNode subnode : node) {
            list.add(new JsonArrayItem(i, subnode));
            ++i;
        }
        return list;
    }

    public static void printNodeTree(JsonNode node) {
        System.out.println(LowEntry.toJsonString(node, true));
    }

    public static <T> T parseYamlStringIntoObject(String yaml, Class<T> objectType) throws Exception {
        return YAML.readValue(yaml, objectType);
    }

    public static String toYamlString(Object object) {
        try {
            return YAML.writeValueAsString(object);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] encryptAes(byte[] data, byte[] key) {
        return EncryptionAes.encryptBytes(data, key, false);
    }

    public static byte[] encryptAes(byte[] data, byte[] key, boolean addValidationHash) {
        return EncryptionAes.encryptBytes(data, key, addValidationHash);
    }

    public static byte[] decryptAes(byte[] data, byte[] key) {
        return EncryptionAes.decryptBytes(data, key, false);
    }

    public static byte[] decryptAes(byte[] data, byte[] key, boolean addedValidationHash) {
        return EncryptionAes.decryptBytes(data, key, addedValidationHash);
    }

    public static AesKey createAesKey(byte[] key) {
        return EncryptionAes.createKey(key);
    }

    public static byte[] encryptAes(byte[] data, AesKey key) {
        return EncryptionAes.encrypt(data, key, false);
    }

    public static byte[] encryptAes(byte[] data, AesKey key, boolean addValidationHash) {
        return EncryptionAes.encrypt(data, key, addValidationHash);
    }

    public static byte[] decryptAes(byte[] data, AesKey key) {
        return EncryptionAes.decrypt(data, key, false);
    }

    public static byte[] decryptAes(byte[] data, AesKey key, boolean addedValidationHash) {
        return EncryptionAes.decrypt(data, key, addedValidationHash);
    }

    public static RsaKeys generateRsaKeys(int bits) {
        return EncryptionRsa.generateKeys(bits);
    }

    public static byte[] encryptRsa(byte[] data, RsaPublicKey publicKey) {
        return EncryptionRsa.encrypt(data, publicKey);
    }

    public static byte[] decryptRsa(byte[] data, RsaPrivateKey privateKey) {
        return EncryptionRsa.decrypt(data, privateKey);
    }

    public static byte[] signRsa(byte[] hash, RsaPrivateKey privateKey) {
        return EncryptionRsa.sign(hash, privateKey);
    }

    public static boolean verifySignatureRsa(byte[] signature, byte[] expectedHash, RsaPublicKey publicKey) {
        return EncryptionRsa.verifySignature(signature, expectedHash, publicKey);
    }

    public static byte[] rsaPublicKeyToBytes(RsaPublicKey publicKey) {
        return EncryptionRsa.publicKeyToBytes(publicKey);
    }

    public static RsaPublicKey bytesToRsaPublicKey(byte[] bytes) {
        return EncryptionRsa.bytesToPublicKey(bytes);
    }

    public static RsaPublicKey bytesToRsaPublicKey(byte[] bytes, int index, int length) {
        return EncryptionRsa.bytesToPublicKey(bytes, index, length);
    }

    public static byte[] rsaPrivateKeyToBytes(RsaPrivateKey privateKey) {
        return EncryptionRsa.privateKeyToBytes(privateKey);
    }

    public static RsaPrivateKey bytesToRsaPrivateKey(byte[] bytes) {
        return EncryptionRsa.bytesToPrivateKey(bytes);
    }

    public static RsaPrivateKey bytesToRsaPrivateKey(byte[] bytes, int index, int length) {
        return EncryptionRsa.bytesToPrivateKey(bytes, index, length);
    }

    public static byte[] compressLzf(byte[] data) {
        if (data == null) {
            return new byte[0];
        }
        return CompressionLzf.compress(data);
    }

    public static byte[] decompressLzf(byte[] data) {
        if (data == null) {
            return new byte[0];
        }
        return CompressionLzf.decompress(data);
    }

    public static byte[] toByteArray(Collection<Byte> collection) {
        if (collection == null) {
            return new byte[0];
        }
        byte[] array = new byte[collection.size()];
        int i = 0;
        for (Byte value : collection) {
            array[i] = value != null ? value : (byte)0;
            ++i;
        }
        return array;
    }

    public static byte[] toByteArray(Byte[] collection) {
        if (collection == null) {
            return new byte[0];
        }
        byte[] array = new byte[collection.length];
        int i = 0;
        for (Byte value : collection) {
            array[i] = value != null ? value : (byte)0;
            ++i;
        }
        return array;
    }

    public static short[] toShortArray(Collection<Short> collection) {
        if (collection == null) {
            return new short[0];
        }
        short[] array = new short[collection.size()];
        int i = 0;
        for (Short value : collection) {
            array[i] = value != null ? value : (short)0;
            ++i;
        }
        return array;
    }

    public static short[] toShortArray(Short[] collection) {
        if (collection == null) {
            return new short[0];
        }
        short[] array = new short[collection.length];
        int i = 0;
        for (Short value : collection) {
            array[i] = value != null ? value : (short)0;
            ++i;
        }
        return array;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] array = new int[collection.size()];
        int i = 0;
        for (Integer value : collection) {
            array[i] = value != null ? value : 0;
            ++i;
        }
        return array;
    }

    public static int[] toIntArray(Integer[] collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] array = new int[collection.length];
        int i = 0;
        for (Integer value : collection) {
            array[i] = value != null ? value : 0;
            ++i;
        }
        return array;
    }

    public static long[] toLongArray(Collection<Long> collection) {
        if (collection == null) {
            return new long[0];
        }
        long[] array = new long[collection.size()];
        int i = 0;
        for (Long value : collection) {
            array[i] = value != null ? value : 0L;
            ++i;
        }
        return array;
    }

    public static long[] toLongArray(Long[] collection) {
        if (collection == null) {
            return new long[0];
        }
        long[] array = new long[collection.length];
        int i = 0;
        for (Long value : collection) {
            array[i] = value != null ? value : 0L;
            ++i;
        }
        return array;
    }

    public static float[] toFloatArray(Collection<Float> collection) {
        if (collection == null) {
            return new float[0];
        }
        float[] array = new float[collection.size()];
        int i = 0;
        for (Float value : collection) {
            array[i] = value != null ? value.floatValue() : 0.0f;
            ++i;
        }
        return array;
    }

    public static float[] toFloatArray(Float[] collection) {
        if (collection == null) {
            return new float[0];
        }
        float[] array = new float[collection.length];
        int i = 0;
        for (Float value : collection) {
            array[i] = value != null ? value.floatValue() : 0.0f;
            ++i;
        }
        return array;
    }

    public static double[] toDoubleArray(Collection<Double> collection) {
        if (collection == null) {
            return new double[0];
        }
        double[] array = new double[collection.size()];
        int i = 0;
        for (Double value : collection) {
            array[i] = value != null ? value : 0.0;
            ++i;
        }
        return array;
    }

    public static double[] toDoubleArray(Double[] collection) {
        if (collection == null) {
            return new double[0];
        }
        double[] array = new double[collection.length];
        int i = 0;
        for (Double value : collection) {
            array[i] = value != null ? value : 0.0;
            ++i;
        }
        return array;
    }

    public static boolean[] toBooleanArray(Collection<Boolean> collection) {
        if (collection == null) {
            return new boolean[0];
        }
        boolean[] array = new boolean[collection.size()];
        int i = 0;
        for (Boolean value : collection) {
            array[i] = value != null ? value : false;
            ++i;
        }
        return array;
    }

    public static boolean[] toBooleanArray(Boolean[] collection) {
        if (collection == null) {
            return new boolean[0];
        }
        boolean[] array = new boolean[collection.length];
        int i = 0;
        for (Boolean value : collection) {
            array[i] = value != null ? value : false;
            ++i;
        }
        return array;
    }

    public static char[] toCharArray(Collection<Character> collection) {
        if (collection == null) {
            return new char[0];
        }
        char[] array = new char[collection.size()];
        int i = 0;
        for (Character value : collection) {
            array[i] = value != null ? value.charValue() : (char)'\u0000';
            ++i;
        }
        return array;
    }

    public static char[] toCharArray(Character[] collection) {
        if (collection == null) {
            return new char[0];
        }
        char[] array = new char[collection.length];
        int i = 0;
        for (Character value : collection) {
            array[i] = value != null ? value.charValue() : (char)'\u0000';
            ++i;
        }
        return array;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return new String[0];
        }
        return collection.toArray(new String[0]);
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> theClass) {
        if (collection == null) {
            return (Object[])Array.newInstance(theClass, 0);
        }
        return collection.toArray((Object[])Array.newInstance(theClass, collection.size()));
    }

    /*
     * Exception decompiling
     */
    public static String getExternalIp() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getHttpContent(String url) {
        return LowEntry.getHttpContent(url, "\r\n");
    }

    /*
     * Exception decompiling
     */
    public static String getHttpContent(String url, String lineSeperator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDateStringIso(Date date) {
        if (date == null) {
            date = new Date(CachedTime.currentTimeMillis());
        }
        return dateformatIso8601.get().format(date);
    }

    public static String getDateStringIso(long time) {
        return dateformatIso8601.get().format(new Date(time));
    }

    public static int stringCountOccurrences(String string, String substring) {
        int index = string.indexOf(substring);
        if (index < 0) {
            return 0;
        }
        int length = substring.length();
        int maxIndex = string.length() - substring.length();
        int count = 0;
        while (index >= 0 && index <= maxIndex) {
            ++count;
            index += length;
            index = string.indexOf(substring, index);
        }
        return count;
    }

    public static String increaseNumericStringByOne(String value) {
        char[] chars = value.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            int c = Character.getNumericValue(chars[i]);
            if (c < 9) {
                int n = i;
                chars[n] = (char)(chars[n] + '\u0001');
                break;
            }
            chars[i] = 48;
        }
        if (chars[0] == '0') {
            return "1" + new String(chars);
        }
        return new String(chars);
    }

    static {
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
        IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().contains("win");
        ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
        JSON_READER = jsonMapper.reader();
        jsonMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        jsonMapper.disable(SerializationFeature.INDENT_OUTPUT);
        JSON_WRITER_PERFORMANCE = jsonMapper.writer();
        jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        JSON_WRITER_READABILITY = jsonMapper.writer();
        ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        yamlMapper.findAndRegisterModules();
        yamlMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        yamlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        YAML = yamlMapper;
        dateformatIso8601 = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm.ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        });
        hashingDigestMd5 = ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
        hashingDigestSha1 = ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
        hashingDigestSha256 = ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
        hashingDigestSha512 = ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static final class Nanos {
        private static final long MILLISECOND = 1000000L;
        private static final long SECOND = 1000000000L;
        private static final long MINUTE = 60000000000L;
        private static final long HOUR = 3600000000000L;
        private static final long DAY = 86400000000000L;
        private static final long WEEK = 604800000000000L;

        public static long NANOSECONDS(long times) {
            return times;
        }

        public static long MILLISECONDS(long times) {
            return 1000000L * times;
        }

        public static long SECONDS(long times) {
            return 1000000000L * times;
        }

        public static long MINUTES(long times) {
            return 60000000000L * times;
        }

        public static long HOURS(long times) {
            return 3600000000000L * times;
        }

        public static long DAYS(long times) {
            return 86400000000000L * times;
        }

        public static long WEEKS(long times) {
            return 604800000000000L * times;
        }

        public static double NANOSECONDS(double times) {
            return times;
        }

        public static double MILLISECONDS(double times) {
            return 1000000.0 * times;
        }

        public static double SECONDS(double times) {
            return 1.0E9 * times;
        }

        public static double MINUTES(double times) {
            return 6.0E10 * times;
        }

        public static double HOURS(double times) {
            return 3.6E12 * times;
        }

        public static double DAYS(double times) {
            return 8.64E13 * times;
        }

        public static double WEEKS(double times) {
            return 6.048E14 * times;
        }
    }

    public static final class Millis {
        private static final double NANOSECOND = 1.0E-6;
        private static final long SECOND = 1000L;
        private static final long MINUTE = 60000L;
        private static final long HOUR = 3600000L;
        private static final long DAY = 86400000L;
        private static final long WEEK = 604800000L;

        public static long NANOSECONDS(long times) {
            return (long)(1.0E-6 * (double)times);
        }

        public static long MILLISECONDS(long times) {
            return times;
        }

        public static long SECONDS(long times) {
            return 1000L * times;
        }

        public static long MINUTES(long times) {
            return 60000L * times;
        }

        public static long HOURS(long times) {
            return 3600000L * times;
        }

        public static long DAYS(long times) {
            return 86400000L * times;
        }

        public static long WEEKS(long times) {
            return 604800000L * times;
        }

        public static double NANOSECONDS(double times) {
            return 1.0E-6 * times;
        }

        public static double MILLISECONDS(double times) {
            return times;
        }

        public static double SECONDS(double times) {
            return 1000.0 * times;
        }

        public static double MINUTES(double times) {
            return 60000.0 * times;
        }

        public static double HOURS(double times) {
            return 3600000.0 * times;
        }

        public static double DAYS(double times) {
            return 8.64E7 * times;
        }

        public static double WEEKS(double times) {
            return 6.048E8 * times;
        }
    }
}

