/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.craterstudio.util.concur;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SimpleBlockingQueue<T> {
    private static final Object NULL_VALUE = new Object();
    private final BlockingQueue<T> backing;
    private final int capacity;

    public SimpleBlockingQueue() {
        this(new LinkedBlockingQueue(), Integer.MAX_VALUE);
    }

    public SimpleBlockingQueue(int cap) {
        this(new ArrayBlockingQueue(cap), cap);
    }

    private SimpleBlockingQueue(BlockingQueue<T> backing, int capacity) {
        this.backing = backing;
        this.capacity = capacity;
    }

    public void clear() {
        this.backing.clear();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public int size() {
        return this.backing.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public void put(T item) {
        if (item == null) {
            item = NULL_VALUE;
        }
        while (true) {
            try {
                this.backing.put(item);
            }
            catch (InterruptedException exc) {
                continue;
            }
            break;
        }
    }

    public T peek() {
        return (T)this.backing.peek();
    }

    public T poll() {
        return (T)this.backing.poll();
    }

    public T poll(long ms) {
        try {
            return this.backing.poll(ms, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exc) {
            return null;
        }
    }

    public T take() {
        while (true) {
            try {
                T item = this.backing.take();
                return item == NULL_VALUE ? null : (T)item;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

