/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.jawnae.pyronet.traffic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;

public class ByteStream {
    private final List<ByteBuffer> queue = new ArrayList<ByteBuffer>();

    public void append(ByteBuffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.queue.add(buf);
    }

    public boolean hasData() {
        for (ByteBuffer byteBuffer : this.queue) {
            if (!byteBuffer.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public int getByteCount() {
        int sum = 0;
        for (ByteBuffer byteBuffer : this.queue) {
            sum += byteBuffer.remaining();
        }
        return sum;
    }

    public void get(ByteBuffer dst) {
        if (dst == null) {
            throw new NullPointerException();
        }
        for (ByteBuffer data : this.queue) {
            if ((data = data.slice()).remaining() > dst.remaining()) {
                data.limit(dst.remaining());
                dst.put(data);
                break;
            }
            dst.put(data);
            if (dst.hasRemaining()) continue;
            break;
        }
    }

    public void discard(int count) {
        int original = count;
        while (count > 0) {
            ByteBuffer data = this.queue.get(0);
            if (count < data.remaining()) {
                data.position(data.position() + count);
                count = 0;
                break;
            }
            this.queue.remove(0);
            count -= data.remaining();
        }
        if (count != 0) {
            throw new PyroException("discarded " + (original - count) + "/" + original + " bytes");
        }
    }
}

