/*
 * Decompiled with CFR 0.152.
 */
package com.lsjwzh.widget.recyclerviewpager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.lsjwzh.widget.recyclerviewpager.R;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

@TargetApi(value=12)
public abstract class FragmentStatePagerAdapter
extends RecyclerView.Adapter<FragmentViewHolder> {
    private static final String TAG = "FragmentStatePagerAdapter";
    private static final boolean DEBUG = false;
    private final FragmentManager mFragmentManager;
    private FragmentTransaction mCurTransaction = null;
    private SparseArray<Fragment.SavedState> mStates = new SparseArray();
    private Set<Integer> mIds = new HashSet<Integer>();
    private IContainerIdGenerator mContainerIdGenerator = new IContainerIdGenerator(){
        private Random mRandom = new Random();

        @Override
        public int genId(Set<Integer> idContainer) {
            return Math.abs(this.mRandom.nextInt());
        }
    };

    public FragmentStatePagerAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
    }

    public void setContainerIdGenerator(@NonNull IContainerIdGenerator idGenerator) {
        this.mContainerIdGenerator = idGenerator;
    }

    public void onViewRecycled(FragmentViewHolder holder) {
        int tagId;
        Fragment f;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        if ((f = this.mFragmentManager.findFragmentByTag((tagId = this.genTagId(holder.getAdapterPosition())) + "")) != null) {
            this.mStates.put(tagId, (Object)this.mFragmentManager.saveFragmentInstanceState(f));
            this.mCurTransaction.remove(f);
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
        if (holder.itemView instanceof ViewGroup) {
            ((ViewGroup)holder.itemView).removeAllViews();
        }
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public final FragmentViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.rvp_fragment_container, parent, false);
        int id2 = this.mContainerIdGenerator.genId(this.mIds);
        if (parent.getContext() instanceof Activity) {
            while (((Activity)parent.getContext()).getWindow().getDecorView().findViewById(id2) != null) {
                id2 = this.mContainerIdGenerator.genId(this.mIds);
            }
        }
        view.findViewById(R.id.rvp_fragment_container).setId(id2);
        this.mIds.add(id2);
        return new FragmentViewHolder(view);
    }

    public final void onBindViewHolder(FragmentViewHolder holder, int position) {
    }

    protected int genTagId(int position) {
        long itemId = this.getItemId(position);
        if (itemId == -1L) {
            return position + 1;
        }
        return (int)itemId;
    }

    public abstract Fragment getItem(int var1, Fragment.SavedState var2);

    public abstract void onDestroyItem(int var1, Fragment var2);

    public static interface IContainerIdGenerator {
        public int genId(Set<Integer> var1);
    }

    public class FragmentViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnAttachStateChangeListener {
        public FragmentViewHolder(View itemView) {
            super(itemView);
            itemView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(View v) {
            if (FragmentStatePagerAdapter.this.mCurTransaction == null) {
                FragmentStatePagerAdapter.this.mCurTransaction = FragmentStatePagerAdapter.this.mFragmentManager.beginTransaction();
            }
            int tagId = FragmentStatePagerAdapter.this.genTagId(this.getLayoutPosition());
            Fragment fragmentInAdapter = FragmentStatePagerAdapter.this.getItem(this.getLayoutPosition(), (Fragment.SavedState)FragmentStatePagerAdapter.this.mStates.get(tagId));
            if (fragmentInAdapter != null) {
                FragmentStatePagerAdapter.this.mCurTransaction.replace(this.itemView.getId(), fragmentInAdapter, tagId + "");
                FragmentStatePagerAdapter.this.mCurTransaction.commitAllowingStateLoss();
                FragmentStatePagerAdapter.this.mCurTransaction = null;
                FragmentStatePagerAdapter.this.mFragmentManager.executePendingTransactions();
            }
        }

        public void onViewDetachedFromWindow(View v) {
            int tagId = FragmentStatePagerAdapter.this.genTagId(this.getLayoutPosition());
            Fragment frag = FragmentStatePagerAdapter.this.mFragmentManager.findFragmentByTag(tagId + "");
            if (frag == null) {
                return;
            }
            if (FragmentStatePagerAdapter.this.mCurTransaction == null) {
                FragmentStatePagerAdapter.this.mCurTransaction = FragmentStatePagerAdapter.this.mFragmentManager.beginTransaction();
            }
            FragmentStatePagerAdapter.this.mStates.put(tagId, (Object)FragmentStatePagerAdapter.this.mFragmentManager.saveFragmentInstanceState(frag));
            FragmentStatePagerAdapter.this.mCurTransaction.remove(frag);
            FragmentStatePagerAdapter.this.mCurTransaction.commitAllowingStateLoss();
            FragmentStatePagerAdapter.this.mCurTransaction = null;
            FragmentStatePagerAdapter.this.mFragmentManager.executePendingTransactions();
            FragmentStatePagerAdapter.this.onDestroyItem(this.getLayoutPosition(), frag);
        }
    }
}

