/*
 * Decompiled with CFR 0.152.
 */
package com.lsjwzh.widget.recyclerviewpager;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.lsjwzh.widget.recyclerviewpager.R;
import com.lsjwzh.widget.recyclerviewpager.RecyclerViewPagerAdapter;
import com.lsjwzh.widget.recyclerviewpager.ViewUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewPager
extends RecyclerView {
    public static final boolean DEBUG = false;
    private RecyclerViewPagerAdapter<?> mViewPagerAdapter;
    private float mTriggerOffset = 0.25f;
    private float mFlingFactor = 0.15f;
    private float mTouchSpan;
    private List<OnPageChangedListener> mOnPageChangedListeners;
    private int mSmoothScrollTargetPosition = -1;
    private int mPositionBeforeScroll = -1;
    private boolean mSinglePageFling;
    boolean mNeedAdjust;
    int mFisrtLeftWhenDragging;
    int mFirstTopWhenDragging;
    View mCurView;
    int mMaxLeftWhenDragging = Integer.MIN_VALUE;
    int mMinLeftWhenDragging = Integer.MAX_VALUE;
    int mMaxTopWhenDragging = Integer.MIN_VALUE;
    int mMinTopWhenDragging = Integer.MAX_VALUE;

    public RecyclerViewPager(Context context) {
        this(context, null);
    }

    public RecyclerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewPager(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs, defStyle);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerViewPager, defStyle, 0);
        this.mFlingFactor = a.getFloat(R.styleable.RecyclerViewPager_flingFactor, 0.15f);
        this.mTriggerOffset = a.getFloat(R.styleable.RecyclerViewPager_triggerOffset, 0.25f);
        this.mSinglePageFling = a.getBoolean(R.styleable.RecyclerViewPager_singlePageFling, this.mSinglePageFling);
        a.recycle();
    }

    public void setFlingFactor(float flingFactor) {
        this.mFlingFactor = flingFactor;
    }

    public float getFlingFactor() {
        return this.mFlingFactor;
    }

    public void setTriggerOffset(float triggerOffset) {
        this.mTriggerOffset = triggerOffset;
    }

    public float getTriggerOffset() {
        return this.mTriggerOffset;
    }

    public void setSinglePageFling(boolean singlePageFling) {
        this.mSinglePageFling = singlePageFling;
    }

    public boolean isSinglePageFling() {
        return this.mSinglePageFling;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        try {
            Field fLayoutState = state.getClass().getDeclaredField("mLayoutState");
            fLayoutState.setAccessible(true);
            Object layoutState = fLayoutState.get(state);
            Field fAnchorOffset = layoutState.getClass().getDeclaredField("mAnchorOffset");
            Field fAnchorPosition = layoutState.getClass().getDeclaredField("mAnchorPosition");
            fAnchorPosition.setAccessible(true);
            fAnchorOffset.setAccessible(true);
            if (fAnchorOffset.getInt(layoutState) > 0) {
                fAnchorPosition.set(layoutState, fAnchorPosition.getInt(layoutState) - 1);
            } else {
                fAnchorPosition.set(layoutState, fAnchorPosition.getInt(layoutState) + 1);
            }
            fAnchorOffset.setInt(layoutState, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.onRestoreInstanceState(state);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mViewPagerAdapter = adapter instanceof RecyclerViewPagerAdapter ? (RecyclerViewPagerAdapter)adapter : new RecyclerViewPagerAdapter(this, adapter);
        super.setAdapter(this.mViewPagerAdapter);
    }

    public void swapAdapter(RecyclerView.Adapter adapter, boolean removeAndRecycleExistingViews) {
        this.mViewPagerAdapter = adapter instanceof RecyclerViewPagerAdapter ? (RecyclerViewPagerAdapter)adapter : new RecyclerViewPagerAdapter(this, adapter);
        super.swapAdapter(this.mViewPagerAdapter, removeAndRecycleExistingViews);
    }

    public RecyclerView.Adapter getAdapter() {
        if (this.mViewPagerAdapter != null) {
            return this.mViewPagerAdapter.mAdapter;
        }
        return null;
    }

    public RecyclerViewPagerAdapter getWrapperAdapter() {
        return this.mViewPagerAdapter;
    }

    public boolean fling(int velocityX, int velocityY) {
        boolean flinging = super.fling((int)((float)velocityX * this.mFlingFactor), (int)((float)velocityY * this.mFlingFactor));
        if (flinging) {
            if (this.getLayoutManager().canScrollHorizontally()) {
                this.adjustPositionX(velocityX);
            } else {
                this.adjustPositionY(velocityY);
            }
        }
        return flinging;
    }

    public void smoothScrollToPosition(int position) {
        this.mSmoothScrollTargetPosition = position;
        super.smoothScrollToPosition(position);
    }

    public int getCurrentPosition() {
        int curPosition = -1;
        curPosition = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChildPosition(this) : ViewUtils.getCenterYChildPosition(this);
        return curPosition;
    }

    protected void adjustPositionX(int velocityX) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            View centerXChild;
            int curPosition = ViewUtils.getCenterXChildPosition(this);
            int childWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int flingCount = (int)((float)velocityX * this.mFlingFactor / (float)childWidth);
            if (this.mSinglePageFling) {
                flingCount = Math.max(-1, Math.min(1, flingCount));
            }
            int targetPosition = curPosition + flingCount;
            targetPosition = Math.max(targetPosition, 0);
            if ((targetPosition = Math.min(targetPosition, this.getAdapter().getItemCount() - 1)) == curPosition && (centerXChild = ViewUtils.getCenterXChild(this)) != null) {
                if (this.mTouchSpan > (float)centerXChild.getWidth() * this.mTriggerOffset * this.mTriggerOffset && targetPosition != 0) {
                    --targetPosition;
                } else if (this.mTouchSpan < (float)centerXChild.getWidth() * -this.mTriggerOffset && targetPosition != this.getAdapter().getItemCount() - 1) {
                    ++targetPosition;
                }
            }
            this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getAdapter().getItemCount()));
        }
    }

    public void addOnPageChangedListener(OnPageChangedListener listener) {
        if (this.mOnPageChangedListeners == null) {
            this.mOnPageChangedListeners = new ArrayList<OnPageChangedListener>();
        }
        this.mOnPageChangedListeners.add(listener);
    }

    public void removeOnPageChangedListener(OnPageChangedListener listener) {
        if (this.mOnPageChangedListeners != null) {
            this.mOnPageChangedListeners.remove(listener);
        }
    }

    public void clearOnPageChangedListeners() {
        if (this.mOnPageChangedListeners != null) {
            this.mOnPageChangedListeners.clear();
        }
    }

    protected void adjustPositionY(int velocityY) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            View centerYChild;
            int curPosition = ViewUtils.getCenterYChildPosition(this);
            int childHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int flingCount = (int)((float)velocityY * this.mFlingFactor / (float)childHeight);
            int targetPosition = curPosition + flingCount;
            targetPosition = Math.max(targetPosition, 0);
            if ((targetPosition = Math.min(targetPosition, this.getAdapter().getItemCount() - 1)) == curPosition && (centerYChild = ViewUtils.getCenterYChild(this)) != null) {
                if (this.mTouchSpan > (float)centerYChild.getHeight() * this.mTriggerOffset && targetPosition != 0) {
                    --targetPosition;
                } else if (this.mTouchSpan < (float)centerYChild.getHeight() * -this.mTriggerOffset && targetPosition != this.getAdapter().getItemCount() - 1) {
                    ++targetPosition;
                }
            }
            this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getAdapter().getItemCount()));
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (e.getAction() == 2 && this.mCurView != null) {
            this.mMaxLeftWhenDragging = Math.max(this.mCurView.getLeft(), this.mMaxLeftWhenDragging);
            this.mMaxTopWhenDragging = Math.max(this.mCurView.getTop(), this.mMaxTopWhenDragging);
            this.mMinLeftWhenDragging = Math.min(this.mCurView.getLeft(), this.mMinLeftWhenDragging);
            this.mMinTopWhenDragging = Math.min(this.mCurView.getTop(), this.mMinTopWhenDragging);
        }
        return super.onTouchEvent(e);
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 1) {
            this.mNeedAdjust = true;
            View view = this.mCurView = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChild(this) : ViewUtils.getCenterYChild(this);
            if (this.mCurView != null) {
                this.mPositionBeforeScroll = this.getChildLayoutPosition(this.mCurView);
                this.mFisrtLeftWhenDragging = this.mCurView.getLeft();
                this.mFirstTopWhenDragging = this.mCurView.getTop();
            } else {
                this.mPositionBeforeScroll = -1;
            }
            this.mTouchSpan = 0.0f;
        } else if (state == 2) {
            this.mNeedAdjust = false;
            this.mTouchSpan = this.mCurView != null ? (this.getLayoutManager().canScrollHorizontally() ? (float)(this.mCurView.getLeft() - this.mFisrtLeftWhenDragging) : (float)(this.mCurView.getTop() - this.mFirstTopWhenDragging)) : 0.0f;
            this.mCurView = null;
        } else if (state == 0) {
            if (this.mNeedAdjust) {
                int targetPosition;
                int n = targetPosition = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChildPosition(this) : ViewUtils.getCenterYChildPosition(this);
                if (this.mCurView != null) {
                    targetPosition = this.getChildAdapterPosition(this.mCurView);
                    if (this.getLayoutManager().canScrollHorizontally()) {
                        int spanX = this.mCurView.getLeft() - this.mFisrtLeftWhenDragging;
                        if ((float)spanX > (float)this.mCurView.getWidth() * this.mTriggerOffset && this.mCurView.getLeft() >= this.mMaxLeftWhenDragging) {
                            --targetPosition;
                        } else if ((float)spanX < (float)this.mCurView.getWidth() * -this.mTriggerOffset && this.mCurView.getLeft() <= this.mMinLeftWhenDragging) {
                            ++targetPosition;
                        }
                    } else {
                        int spanY = this.mCurView.getTop() - this.mFirstTopWhenDragging;
                        if ((float)spanY > (float)this.mCurView.getHeight() * this.mTriggerOffset && this.mCurView.getTop() >= this.mMaxTopWhenDragging) {
                            --targetPosition;
                        } else if ((float)spanY < (float)this.mCurView.getHeight() * -this.mTriggerOffset && this.mCurView.getTop() <= this.mMinTopWhenDragging) {
                            ++targetPosition;
                        }
                    }
                }
                this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getAdapter().getItemCount()));
                this.mCurView = null;
            } else if (this.mSmoothScrollTargetPosition != this.mPositionBeforeScroll && this.mOnPageChangedListeners != null) {
                for (OnPageChangedListener onPageChangedListener : this.mOnPageChangedListeners) {
                    if (onPageChangedListener == null) continue;
                    onPageChangedListener.OnPageChanged(this.mPositionBeforeScroll, this.mSmoothScrollTargetPosition);
                }
            }
            this.mMaxLeftWhenDragging = Integer.MIN_VALUE;
            this.mMinLeftWhenDragging = Integer.MAX_VALUE;
            this.mMaxTopWhenDragging = Integer.MIN_VALUE;
            this.mMinTopWhenDragging = Integer.MAX_VALUE;
        }
    }

    private int safeTargetPosition(int position, int count) {
        if (position < 0) {
            return 0;
        }
        if (position >= count) {
            return count - 1;
        }
        return position;
    }

    public static interface OnPageChangedListener {
        public void OnPageChanged(int var1, int var2);
    }
}

