/*
 * Decompiled with CFR 0.152.
 */
package com.lsjwzh.widget.recyclerviewpager;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.lsjwzh.widget.recyclerviewpager.RecyclerViewPager;

public class RecyclerViewPagerAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private final RecyclerViewPager mViewPager;
    RecyclerView.Adapter<VH> mAdapter;

    public RecyclerViewPagerAdapter(RecyclerViewPager viewPager, RecyclerView.Adapter<VH> adapter) {
        this.mAdapter = adapter;
        this.mViewPager = viewPager;
        this.setHasStableIds(this.mAdapter.hasStableIds());
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        return (VH)this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
        this.mAdapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
        this.mAdapter.unregisterAdapterDataObserver(observer);
    }

    public void onBindViewHolder(VH holder, int position) {
        ViewGroup.LayoutParams lp;
        this.mAdapter.onBindViewHolder(holder, position);
        View itemView = ((RecyclerView.ViewHolder)holder).itemView;
        ViewGroup.LayoutParams layoutParams = lp = itemView.getLayoutParams() == null ? new ViewGroup.LayoutParams(-1, -1) : itemView.getLayoutParams();
        if (this.mViewPager.getLayoutManager().canScrollHorizontally()) {
            lp.width = this.mViewPager.getWidth() - this.mViewPager.getPaddingLeft() - this.mViewPager.getPaddingRight();
        } else {
            lp.height = this.mViewPager.getHeight() - this.mViewPager.getPaddingTop() - this.mViewPager.getPaddingBottom();
        }
        itemView.setLayoutParams(lp);
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
        this.mAdapter.setHasStableIds(hasStableIds);
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        return this.mAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        return this.mAdapter.getItemId(position);
    }
}

