/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.JdbcEventListener;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.JdbcPeer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import io.opentracing.threadcontext.ContextSpan;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class SpanEventListener
extends JdbcEventListener {
    private final ContextSpan spanContext;
    private final Tracer tracer;
    private final JdbcPeer peer;

    public SpanEventListener(Tracer tracer, ContextSpan contextSpan, JdbcPeer jdbcPeer) {
        this.spanContext = contextSpan;
        this.tracer = tracer;
        this.peer = jdbcPeer;
    }

    public void onAfterExecute(StatementInformation statementInformation, long l, String string, SQLException sQLException) {
        this.onAfterExecute("execute", statementInformation, l, sQLException);
    }

    public void onAfterExecute(PreparedStatementInformation preparedStatementInformation, long l, SQLException sQLException) {
        this.onAfterExecute("execute", (StatementInformation)preparedStatementInformation, l, sQLException);
    }

    public void onAfterExecuteUpdate(StatementInformation statementInformation, long l, String string, int n, SQLException sQLException) {
        this.onAfterExecute("update", statementInformation, l, sQLException);
    }

    public void onAfterExecuteUpdate(PreparedStatementInformation preparedStatementInformation, long l, int n, SQLException sQLException) {
        this.onAfterExecute("update", (StatementInformation)preparedStatementInformation, l, sQLException);
    }

    public void onAfterExecuteQuery(StatementInformation statementInformation, long l, String string, SQLException sQLException) {
        this.onAfterExecute("query", statementInformation, l, sQLException);
    }

    public void onAfterExecuteQuery(PreparedStatementInformation preparedStatementInformation, long l, SQLException sQLException) {
        this.onAfterExecute("query", (StatementInformation)preparedStatementInformation, l, sQLException);
    }

    private void onAfterExecute(String string, StatementInformation statementInformation, long l, SQLException sQLException) {
        Driver driver;
        Instant instant = Instant.now();
        Instant instant2 = instant.minusNanos(l);
        String string2 = statementInformation.getSql();
        Span span = this.spanContext.get() != NoopSpan.INSTANCE ? this.spanContext.get() : null;
        Span span2 = this.tracer.buildSpan(String.format("SQL %s %s", string, new Scanner(string2).next())).asChildOf(span).withStartTimestamp(TimeUnit.SECONDS.toMicros(instant2.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant2.getNano())).start();
        Tags.SPAN_KIND.set(span2, "client");
        if (this.peer.name != null) {
            Tags.PEER_SERVICE.set(span2, this.peer.name);
        }
        if (this.peer.ipv4 != null) {
            Tags.PEER_HOST_IPV4.set(span2, this.peer.ipv4);
        }
        if (this.peer.ipv6 != null) {
            Tags.PEER_HOST_IPV6.set(span2, this.peer.ipv6);
        }
        if (this.peer.port != null) {
            Tags.PEER_PORT.set(span2, this.peer.port);
        }
        if ((driver = statementInformation.getConnectionInformation().getDriver()) != null) {
            span2.setTag("jdbc.driver", driver.getClass().getName());
        }
        span2.setTag("jdbc.query", string2);
        if (sQLException != null) {
            Tags.ERROR.set(span2, Boolean.valueOf(true));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sQLException.printStackTrace(printWriter);
            span2.setTag("error.message", sQLException.getMessage() + ". SqlState: " + sQLException.getSQLState() + ". ErrorCode: " + sQLException.getErrorCode());
            span2.setTag("error.stack", stringWriter.toString());
        }
        span2.finish(TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
    }
}

