/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.util.Log;
import com.luhonghai.litedb.LiteDatabaseHelper;
import com.luhonghai.litedb.LiteQuery;
import com.luhonghai.litedb.annotation.AnnotationHelper;
import com.luhonghai.litedb.annotation.LiteColumn;
import com.luhonghai.litedb.annotation.LiteTable;
import com.luhonghai.litedb.bulk.BulkInsert;
import com.luhonghai.litedb.bulk.BulkUpdate;
import com.luhonghai.litedb.exception.InvalidAnnotationData;
import com.luhonghai.litedb.exception.LiteDatabaseException;
import com.luhonghai.litedb.meta.LiteColumnMeta;
import com.luhonghai.litedb.meta.LiteTableMeta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class LiteBaseDao<T> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final AnnotationHelper annotationHelper;
    private final LiteDatabaseHelper databaseHelper;
    private final Class<T> tableClass;
    private final SimpleDateFormat sdfDateValue;

    public LiteBaseDao(LiteDatabaseHelper databaseHelper, Class<T> tableClass) {
        this.databaseHelper = databaseHelper;
        this.annotationHelper = databaseHelper.getAnnotationHelper(tableClass);
        this.tableClass = tableClass;
        this.sdfDateValue = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.getDefault());
        this.sdfDateValue.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public LiteQuery getLiteQuery() {
        return this.databaseHelper.getLiteQuery();
    }

    public SQLiteDatabase getDatabase() {
        return this.databaseHelper.getDatabase();
    }

    public AnnotationHelper getAnnotationHelper() {
        return this.annotationHelper;
    }

    public LiteDatabaseHelper getDatabaseHelper() {
        return this.databaseHelper;
    }

    public void open() {
        this.databaseHelper.open();
    }

    public void close() {
        this.databaseHelper.close();
    }

    public ContentValues fillContentValues(T object) throws LiteDatabaseException {
        ContentValues contentValues = new ContentValues();
        for (String fieldName : this.getTableMeta().getColumns().keySet()) {
            LiteColumnMeta columnMeta = this.getTableMeta().getColumns().get(fieldName);
            if (columnMeta.isAutoincrement()) continue;
            this.putContentValues(contentValues, fieldName, object);
        }
        return contentValues;
    }

    public void putContentValues(ContentValues contentValues, Field field, T object) throws LiteDatabaseException {
        this.putContentValues(contentValues, field.getName(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void putContentValues(ContentValues contentValues, String fieldName, T object) throws LiteDatabaseException {
        fieldValue = null;
        columnMeta = this.getTableMeta().getColumns().get(fieldName);
        try {
            fieldValue = columnMeta.getValue(object);
        }
        catch (IllegalAccessException e) {
            throw new LiteDatabaseException("Could not get field value from object", e);
        }
        if (fieldValue == null) {
            return;
        }
        key = columnMeta.getColumnName();
        block9 : switch (1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[columnMeta.getFieldType().ordinal()]) {
            case 1: {
                contentValues.put(key, Long.valueOf(fieldValue.toString()));
                break;
            }
            case 2: {
                contentValues.put(key, fieldValue.toString());
                break;
            }
            case 3: {
                contentValues.put(key, Integer.valueOf(fieldValue.toString()));
                break;
            }
            case 4: {
                contentValues.put(key, Float.valueOf(fieldValue.toString()));
                break;
            }
            case 5: {
                contentValues.put(key, Byte.valueOf(fieldValue.toString()));
                break;
            }
            case 6: {
                contentValues.put(key, Short.valueOf(fieldValue.toString()));
                break;
            }
            case 7: {
                contentValues.put(key, Boolean.valueOf(Boolean.parseBoolean(fieldValue.toString())));
                break;
            }
            case 8: {
                contentValues.put(key, Double.valueOf(fieldValue.toString()));
                break;
            }
            case 9: {
                switch (1.$SwitchMap$com$luhonghai$litedb$LiteColumnType[columnMeta.getDateColumnType().ordinal()]) {
                    case 1: {
                        contentValues.put(key, this.sdfDateValue.format((Date)fieldValue));
                        break block9;
                    }
                    case 2: {
                        contentValues.put(key, Long.valueOf(((Date)fieldValue).getTime()));
                        break block9;
                    }
                }
                throw new LiteDatabaseException("Invalid date column type " + columnMeta.getDateColumnType().toString(), new InvalidAnnotationData("Invalid dateColumnType"));
            }
            case 10: 
            case 11: {
                outputStream = null;
                objectOutputStream = null;
                outputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(fieldValue);
                contentValues.put(key, outputStream.toByteArray());
                objectOutputStream.flush();
                outputStream.flush();
                if (objectOutputStream == null) ** GOTO lbl61
                try {
                    objectOutputStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
lbl61:
                // 3 sources

                if (outputStream == null) break;
                try {
                    outputStream.close();
                }
                catch (Exception e) {}
                break;
                catch (Exception e) {
                    try {
                        Log.e((String)"", (String)"", (Throwable)e);
                        if (objectOutputStream == null) ** GOTO lbl91
                    }
                    catch (Throwable var10_15) {
                        if (objectOutputStream != null) {
                            try {
                                objectOutputStream.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var10_15;
                    }
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
lbl91:
                    // 3 sources

                    if (outputStream == null) break;
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {}
                    break;
                }
            }
        }
    }

    public Object getValueFromCursor(Cursor cursor, Field field) throws LiteDatabaseException {
        return this.getValueFromCursor(cursor, field.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueFromCursor(Cursor cursor, String fieldName) throws LiteDatabaseException {
        LiteColumnMeta columnMeta = this.getTableMeta().getColumns().get(fieldName);
        Object value = null;
        int columnIndex = !"".equals(columnMeta.getAlias()) ? cursor.getColumnIndex(columnMeta.getAlias()) : cursor.getColumnIndex(columnMeta.getColumnName());
        if (columnIndex == -1) {
            return null;
        }
        switch (columnMeta.getFieldType()) {
            case LONG: {
                return cursor.getLong(columnIndex);
            }
            case STRING: {
                return cursor.getString(columnIndex);
            }
            case INTEGER: {
                return cursor.getInt(columnIndex);
            }
            case BYTE_ARRAY: {
                return cursor.getBlob(columnIndex);
            }
            case DOUBLE: {
                return cursor.getDouble(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(cursor.getFloat(columnIndex));
            }
            case BYTE: 
            case SHORT: {
                return cursor.getShort(columnIndex);
            }
            case BOOLEAN: {
                return cursor.getInt(columnIndex) == 1;
            }
            case DATE: {
                switch (columnMeta.getDateColumnType()) {
                    case TEXT: {
                        String date = cursor.getString(columnIndex);
                        if (date == null || date.length() <= 0) break;
                        try {
                            return this.sdfDateValue.parse(date);
                        }
                        catch (ParseException e) {
                            throw new LiteDatabaseException("Could not parse date value from database", e);
                        }
                    }
                    case INTEGER: {
                        long unixDate = cursor.getLong(columnIndex);
                        if (unixDate == 0L) break;
                        value = new Date(unixDate);
                        return value;
                    }
                }
                return value;
            }
            case SERIALIZABLE: {
                byte[] data = cursor.getBlob(columnIndex);
                if (data == null) return value;
                if (data.length <= 0) return value;
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                ObjectInputStream in = null;
                try {
                    in = new ObjectInputStream(bis);
                    value = in.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    try {
                        throw new LiteDatabaseException("Could not read serializable object from database", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            bis.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        try {
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (in == null) return value;
                    in.close();
                    return value;
                }
                catch (IOException ex) {
                    return value;
                }
            }
        }
        return value;
    }

    public void bindObject(T object, Cursor cursor) throws LiteDatabaseException {
        this.bindObject(this.tableClass, object, cursor);
        Class<T> parent = this.tableClass.getSuperclass();
        if (parent.isAssignableFrom(this.tableClass.getAnnotation(LiteTable.class).allowedParent())) {
            this.bindObject(parent, object, cursor);
        }
    }

    public void bindObject(Class clazz, T object, Cursor cursor) throws LiteDatabaseException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (field.getAnnotation(LiteColumn.class) == null) continue;
            try {
                field.set(object, this.getValueFromCursor(cursor, field));
            }
            catch (IllegalAccessException e) {
                throw new LiteDatabaseException("Could not set value to object field from database cursor", e);
            }
        }
    }

    public List<T> toList(Cursor cursor) throws LiteDatabaseException {
        ArrayList<T> list = new ArrayList<T>();
        if (cursor.moveToFirst()) {
            do {
                list.add(this.toObject(cursor));
                cursor.moveToNext();
            } while (!cursor.isAfterLast());
        }
        cursor.close();
        return list;
    }

    public T toObject(Cursor cursor) throws LiteDatabaseException {
        T obj;
        try {
            obj = this.tableClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new LiteDatabaseException("Could not create new instance of class " + this.tableClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new LiteDatabaseException("Could not create new instance of class " + this.tableClass.getName(), e);
        }
        this.bindObject(obj, cursor);
        return obj;
    }

    public void deleteAll() throws LiteDatabaseException {
        this.delete(null, null);
    }

    public void delete(String whereClause, String[] whereArgs) throws LiteDatabaseException {
        this.getDatabase().delete(this.getTableName(), this.getLiteQuery().exchange(whereClause), whereArgs);
    }

    public void deleteByKey(Object key) throws LiteDatabaseException {
        String primaryColumn = this.getTableMeta().getPrimaryKey();
        this.delete("[" + (this.databaseHelper.isUseClassSchema() ? primaryColumn : this.getTableMeta().getColumns().get(primaryColumn).getColumnName()) + "] = ?", new String[]{key.toString()});
    }

    public void delete(T obj) throws LiteDatabaseException {
        try {
            this.deleteByKey(this.getTableMeta().getColumns().get(this.getTableMeta().getPrimaryKey()).getValue(obj));
        }
        catch (IllegalAccessException e) {
            throw new LiteDatabaseException("Could not delete object", e);
        }
    }

    public long insert(T obj) throws LiteDatabaseException {
        return this.insert(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(T obj, boolean useTransaction) throws LiteDatabaseException {
        BulkInsert<T> bulkInsert = this.newBulkInsert(useTransaction);
        bulkInsert.begin();
        try {
            long id = bulkInsert.execute(obj);
            bulkInsert.success();
            long l = id;
            return l;
        }
        finally {
            bulkInsert.end();
        }
    }

    public long[] insert(Collection<T> list) throws LiteDatabaseException {
        return this.insert(list, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] insert(Collection<T> list, boolean useTransaction) throws LiteDatabaseException {
        long[] ids = new long[list.size()];
        BulkInsert<T> bulkInsert = this.newBulkInsert(useTransaction);
        bulkInsert.begin();
        try {
            bulkInsert.execute(list);
            bulkInsert.success();
            long[] lArray = ids;
            return lArray;
        }
        finally {
            bulkInsert.end();
        }
    }

    public long update(T obj) throws LiteDatabaseException {
        return this.update(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(T obj, boolean useTransaction) throws LiteDatabaseException {
        BulkUpdate<T> bulkUpdate = this.newBulkUpdate(useTransaction);
        bulkUpdate.begin();
        try {
            long length = bulkUpdate.execute(obj);
            bulkUpdate.success();
            long l = length;
            return l;
        }
        finally {
            bulkUpdate.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] update(Collection<T> list, boolean useTransaction) throws LiteDatabaseException {
        BulkUpdate<T> bulkUpdate = this.newBulkUpdate(useTransaction);
        bulkUpdate.begin();
        try {
            long[] data = bulkUpdate.execute(list);
            bulkUpdate.success();
            long[] lArray = data;
            return lArray;
        }
        finally {
            bulkUpdate.end();
        }
    }

    public long[] update(Collection<T> list) throws LiteDatabaseException {
        return this.update(list, true);
    }

    public int update(ContentValues contentValues, String whereClause, String[] whereArgs) throws LiteDatabaseException {
        return this.getDatabase().update(this.getTableName(), contentValues, this.getLiteQuery().exchange(whereClause), whereArgs);
    }

    public Cursor query(boolean distinct, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) throws LiteDatabaseException {
        String sql = SQLiteQueryBuilder.buildQueryString((boolean)distinct, (String)("[" + (this.databaseHelper.isUseClassSchema() ? this.tableClass.getName() : this.getTableMeta().getTableName()) + "]"), (String[])(this.databaseHelper.isUseClassSchema() ? this.getTableMeta().getSelectFields() : this.getColumns()), (String)selection, (String)groupBy, (String)having, (String)orderBy, (String)limit);
        Log.d((String)this.getClass().getName(), (String)("Execute query: " + sql));
        return this.getDatabase().rawQueryWithFactory(null, this.getLiteQuery().exchange(sql), selectionArgs, null);
    }

    public Cursor query(String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) throws LiteDatabaseException {
        return this.query(false, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor query(String selection, String[] selectionArgs, String groupBy, String having, String orderBy) throws LiteDatabaseException {
        return this.query(false, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String selection, String[] selectionArgs) throws LiteDatabaseException {
        return this.query(selection, selectionArgs, null, null, null, null);
    }

    public Cursor rawQuery(String sql, String[] args) throws LiteDatabaseException {
        return this.getDatabase().rawQuery(this.getLiteQuery().exchange(sql), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Object key) throws LiteDatabaseException {
        String primaryColumn = this.getTableMeta().getPrimaryKey();
        Cursor cursor = this.query("[" + (this.databaseHelper.isUseClassSchema() ? primaryColumn : this.getTableMeta().getColumns().get(primaryColumn).getColumnName()) + "] = ?", new String[]{key.toString()});
        if (cursor.moveToFirst()) {
            try {
                T t = this.toObject(cursor);
                return t;
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public List<T> listAll() throws LiteDatabaseException {
        return this.toList(this.query(null, null));
    }

    public int count() throws LiteDatabaseException {
        return this.count(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(String selection, String[] selectionArgs) throws LiteDatabaseException {
        try (Cursor cursor = null;){
            String sql = "select count(*) from [" + (this.databaseHelper.isUseClassSchema() ? this.tableClass.getName() : this.getTableMeta().getTableName()) + "]" + (selection == null ? "" : " where " + selection);
            cursor = this.rawQuery(sql, selectionArgs);
            cursor.moveToFirst();
            int n = cursor.getInt(0);
            return n;
        }
    }

    public BulkInsert<T> newBulkInsert() throws LiteDatabaseException {
        return this.newBulkInsert(true);
    }

    public BulkInsert<T> newBulkInsert(boolean useTransaction) throws LiteDatabaseException {
        return new BulkInsert(this.getDatabase(), this.getDatabaseHelper().getTableMeta(this.tableClass), useTransaction);
    }

    public BulkUpdate<T> newBulkUpdate() throws LiteDatabaseException {
        return this.newBulkUpdate(true);
    }

    public BulkUpdate<T> newBulkUpdate(boolean useTransaction) throws LiteDatabaseException {
        return new BulkUpdate(this.getDatabase(), this.getDatabaseHelper().getTableMeta(this.tableClass), useTransaction);
    }

    public LiteTableMeta getTableMeta() throws LiteDatabaseException {
        return this.getDatabaseHelper().getTableMeta(this.tableClass);
    }

    public String getTableName() throws LiteDatabaseException {
        return this.getTableMeta().getTableName();
    }

    public String[] getColumns() throws LiteDatabaseException {
        return this.getTableMeta().getSelectColumns();
    }
}

