/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.luhonghai.litedb.LiteQuery;
import com.luhonghai.litedb.annotation.AnnotationHelper;
import com.luhonghai.litedb.annotation.LiteColumn;
import com.luhonghai.litedb.annotation.LiteDatabase;
import com.luhonghai.litedb.exception.AnnotationNotFound;
import com.luhonghai.litedb.exception.InvalidAnnotationData;
import com.luhonghai.litedb.exception.LiteDatabaseException;
import com.luhonghai.litedb.exception.UnsupportedFieldType;
import com.luhonghai.litedb.meta.LiteTableMeta;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LiteDatabaseHelper {
    private static final String TAG = "LiteDB";
    private SQLiteDatabase mDB;
    private DatabaseHelper mOpenHelper;
    private final Context mContext;
    private final LiteQuery liteQuery;
    private final Map<String, LiteTableMeta> tableMetaData = new ConcurrentHashMap<String, LiteTableMeta>();
    private final Map<String, AnnotationHelper> annotationHelpers = new ConcurrentHashMap<String, AnnotationHelper>();
    private boolean useClassSchema;

    public boolean isUseClassSchema() {
        return this.useClassSchema;
    }

    public LiteDatabaseHelper(Context context) throws AnnotationNotFound, InvalidAnnotationData {
        LiteDatabase liteDatabase = this.getClass().getAnnotation(LiteDatabase.class);
        if (liteDatabase == null) {
            throw new AnnotationNotFound(LiteDatabase.class);
        }
        this.mContext = context;
        this.useClassSchema = liteDatabase.useClassSchema();
        Class[] tableClasses = liteDatabase.tables();
        if (tableClasses == null || tableClasses.length == 0) {
            throw new InvalidAnnotationData("Require at least one table in database");
        }
        String dbName = liteDatabase.name();
        if (dbName == null || dbName.length() == 0) {
            dbName = this.getClass().getSimpleName();
        }
        this.mOpenHelper = new DatabaseHelper(this.mContext, dbName, liteDatabase.version(), tableClasses);
        this.liteQuery = new LiteQuery(this);
    }

    public LiteDatabaseHelper(Context context, DatabaseListener databaseListener) throws AnnotationNotFound, InvalidAnnotationData {
        this(context);
        this.setDatabaseListener(databaseListener);
    }

    public final Context getContext() {
        return this.mContext;
    }

    public LiteQuery getLiteQuery() {
        return this.liteQuery;
    }

    public final SQLiteDatabase getDatabase() {
        return this.mDB;
    }

    public final void open() {
        this.openWritable();
    }

    public final void openWritable() {
        if (this.mOpenHelper == null) {
            return;
        }
        this.mDB = this.mOpenHelper.getWritableDatabase();
    }

    public final void openReadable() {
        if (this.mOpenHelper == null) {
            return;
        }
        this.mDB = this.mOpenHelper.getReadableDatabase();
    }

    public final void close() {
        if (this.mDB != null) {
            this.mDB.close();
        }
    }

    public void setDatabaseListener(DatabaseListener databaseListener) {
        this.mOpenHelper.setDatabaseListener(databaseListener);
    }

    public boolean isTableExists(String table) {
        return this.mOpenHelper.isTableExists(this.mDB, table);
    }

    public boolean isColumnExists(String table, String column) {
        return this.mOpenHelper.isColumnExists(this.mDB, table, column);
    }

    public AnnotationHelper getAnnotationHelper(Class<?> clazz) {
        if (!this.annotationHelpers.containsKey(clazz.getName())) {
            this.annotationHelpers.put(clazz.getName(), new AnnotationHelper(clazz));
        }
        return this.annotationHelpers.get(clazz.getName());
    }

    public LiteTableMeta getTableMeta(Class<?> clazz) throws LiteDatabaseException {
        if (!this.tableMetaData.containsKey(clazz.getName())) {
            AnnotationHelper annotationHelper = this.getAnnotationHelper(clazz);
            try {
                this.tableMetaData.put(clazz.getName(), annotationHelper.generateTableMeta());
            }
            catch (AnnotationNotFound | InvalidAnnotationData | UnsupportedFieldType e) {
                throw new LiteDatabaseException("Could not get table meta data", e);
            }
        }
        return this.tableMetaData.get(clazz.getName());
    }

    public Class[] getTableClasses() {
        return this.mOpenHelper.getTableClass();
    }

    public Map<String, LiteTableMeta> getTableMetaMap() throws LiteDatabaseException {
        Class[] tableClasses = this.getTableClasses();
        if (tableClasses != null && this.tableMetaData.size() != tableClasses.length) {
            for (Class clazz : tableClasses) {
                this.getTableMeta(clazz);
            }
        }
        return this.tableMetaData;
    }

    public static final class DatabaseHelper
    extends SQLiteOpenHelper {
        private final Class[] tableClasses;
        private DatabaseListener databaseListener;

        public DatabaseHelper(Context context, String databaseName, int databaseVersion, Class[] tableClasses) {
            super(context, databaseName, null, databaseVersion);
            this.tableClasses = tableClasses;
        }

        public DatabaseHelper(Context context, String databaseName, int databaseVersion, Class[] tableClasses, DatabaseListener databaseListener) {
            this(context, databaseName, databaseVersion, tableClasses);
            this.setDatabaseListener(databaseListener);
        }

        public void onCreate(SQLiteDatabase db) {
            if (this.databaseListener != null) {
                this.databaseListener.onBeforeDatabaseCreate(db);
            }
            this.verifyDatabase(db);
            if (this.databaseListener != null) {
                this.databaseListener.onAfterDatabaseCreate(db);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (this.databaseListener != null) {
                this.databaseListener.onBeforeDatabaseUpgrade(db, oldVersion, newVersion);
            }
            this.verifyDatabase(db);
            if (this.databaseListener != null) {
                this.databaseListener.onAfterDatabaseUpgrade(db, oldVersion, newVersion);
            }
        }

        private void verifyDatabase(SQLiteDatabase db) {
            for (Class clazz : this.tableClasses) {
                try {
                    AnnotationHelper annotationHelper = new AnnotationHelper(clazz);
                    String tableName = annotationHelper.getTableName();
                    if (this.isTableExists(db, tableName)) {
                        for (Field field : clazz.getDeclaredFields()) {
                            LiteColumn liteColumn = field.getAnnotation(LiteColumn.class);
                            if (liteColumn == null || this.isColumnExists(db, tableName, annotationHelper.getColumnName(field))) continue;
                            String query = annotationHelper.getAddColumnQuery(field);
                            Log.d((String)LiteDatabaseHelper.TAG, (String)("Add new column. Query: " + query));
                            db.execSQL(query);
                        }
                        continue;
                    }
                    String query = annotationHelper.getCreateTableQuery();
                    Log.d((String)LiteDatabaseHelper.TAG, (String)("Create new table. Query: " + query));
                    db.execSQL(query);
                }
                catch (Exception e) {
                    Log.e((String)LiteDatabaseHelper.TAG, (String)("Could not verify table " + clazz.getName()), (Throwable)e);
                    if (this.databaseListener == null) continue;
                    this.databaseListener.onError(db, "Could not verify table " + clazz.getName(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isTableExists(SQLiteDatabase db, String table) {
            Cursor cursor = db.rawQuery("select DISTINCT [tbl_name] from [sqlite_master] where [tbl_name] = ?", new String[]{table});
            if (cursor != null) {
                try {
                    boolean bl = cursor.getCount() > 0;
                    return bl;
                }
                finally {
                    cursor.close();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isColumnExists(SQLiteDatabase db, String table, String column) {
            try (Cursor mCursor = null;){
                mCursor = db.rawQuery("SELECT * FROM [" + table + "] LIMIT 0", null);
                boolean bl = mCursor.getColumnIndex(column) != -1;
                return bl;
            }
        }

        public void setDatabaseListener(DatabaseListener databaseListener) {
            this.databaseListener = databaseListener;
        }

        public Class[] getTableClass() {
            return this.tableClasses;
        }
    }

    public static interface DatabaseListener {
        public void onBeforeDatabaseCreate(SQLiteDatabase var1);

        public void onAfterDatabaseCreate(SQLiteDatabase var1);

        public void onBeforeDatabaseUpgrade(SQLiteDatabase var1, int var2, int var3);

        public void onAfterDatabaseUpgrade(SQLiteDatabase var1, int var2, int var3);

        public void onError(SQLiteDatabase var1, String var2, Throwable var3);
    }
}

