/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb.annotation;

import com.luhonghai.litedb.LiteColumnType;
import com.luhonghai.litedb.LiteFieldType;
import com.luhonghai.litedb.annotation.LiteColumn;
import com.luhonghai.litedb.annotation.LiteTable;
import com.luhonghai.litedb.exception.AnnotationNotFound;
import com.luhonghai.litedb.exception.InvalidAnnotationData;
import com.luhonghai.litedb.exception.UnsupportedFieldType;
import com.luhonghai.litedb.meta.LiteColumnMeta;
import com.luhonghai.litedb.meta.LiteTableMeta;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AnnotationHelper {
    private final Class<?> clazz;

    public AnnotationHelper(Class tableClazz) {
        this.clazz = tableClazz;
    }

    public Class getTableClass() {
        return this.clazz;
    }

    public final String getTableName() throws AnnotationNotFound {
        LiteTable annotationTable = this.clazz.getAnnotation(LiteTable.class);
        String table = this.clazz.getSimpleName();
        if (annotationTable != null) {
            if (!annotationTable.name().equals("")) {
                table = annotationTable.name();
            }
        } else {
            throw new AnnotationNotFound(LiteTable.class);
        }
        return table;
    }

    public final String getColumnName(Field field) {
        LiteColumn annotationColumn = field.getAnnotation(LiteColumn.class);
        String column = null;
        if (annotationColumn != null) {
            column = annotationColumn.name().equals("") ? field.getName() : annotationColumn.name();
        }
        return column;
    }

    public final String[] getColumns() {
        ArrayList<String> columnsList = new ArrayList<String>();
        this.findColumns(columnsList, this.clazz);
        Class<?> parent = this.clazz.getSuperclass();
        if (parent.isAssignableFrom(this.clazz.getAnnotation(LiteTable.class).allowedParent())) {
            this.findColumns(columnsList, parent);
        }
        String[] columnsArray = new String[columnsList.size()];
        return columnsList.toArray(columnsArray);
    }

    private void findColumns(List<String> columnsList, Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            String columnName;
            LiteColumn fieldEntityAnnotation = field.getAnnotation(LiteColumn.class);
            if (fieldEntityAnnotation == null || (columnName = this.getColumnName(field)) == null || columnsList.contains(columnName)) continue;
            columnsList.add(columnName);
        }
    }

    public final String getCreateTableQuery() throws AnnotationNotFound, UnsupportedFieldType, InvalidAnnotationData {
        StringBuffer sql = new StringBuffer("CREATE TABLE ");
        sql.append("[").append(this.getTableName()).append("]");
        sql.append(" (");
        this.findColumn(sql, this.clazz);
        Class<?> parent = this.clazz.getSuperclass();
        if (parent.isAssignableFrom(this.clazz.getAnnotation(LiteTable.class).allowedParent())) {
            this.findColumn(sql, parent);
        }
        String rSql = sql.toString().trim();
        rSql = rSql.substring(0, rSql.length() - 1);
        return rSql + ");";
    }

    private void findColumn(StringBuffer sql, Class clazz) throws UnsupportedFieldType, InvalidAnnotationData {
        for (Field field : clazz.getDeclaredFields()) {
            LiteColumn liteColumn = field.getAnnotation(LiteColumn.class);
            if (liteColumn == null) continue;
            String fieldType = this.getColumnType(field);
            sql.append("[").append(this.getColumnName(field)).append("]");
            sql.append(" ");
            sql.append(fieldType);
            if (liteColumn.isPrimaryKey()) {
                sql.append(" ").append("PRIMARY KEY");
            }
            if (liteColumn.isAutoincrement()) {
                this.verifyAutoincrement(field);
                sql.append(" ").append("AUTOINCREMENT");
            }
            if (liteColumn.isNotNull()) {
                sql.append(" ").append("NOT NULL");
            }
            if (liteColumn.defaultValue().length() > 0) {
                sql.append(" ").append("DEFAULT ").append(liteColumn.defaultValue());
            }
            sql.append(", ");
        }
    }

    public void verifyAutoincrement(Field field) throws InvalidAnnotationData {
        if (!this.isNumberField(field)) {
            throw new InvalidAnnotationData("Autoincrement only support field type: Double, Float, Long, Integer and Short. Field name: " + field.getName() + ". Field type: " + field.getType().getName() + ". Class: " + this.clazz.getName());
        }
    }

    public boolean isNumberField(Field field) {
        Class<Number> fType = field.getType();
        return fType.isAssignableFrom(Long.class) || fType.isAssignableFrom(Long.TYPE) || fType.isAssignableFrom(Integer.class) || fType.isAssignableFrom(Integer.TYPE) || fType.isAssignableFrom(Short.class) || fType.isAssignableFrom(Short.TYPE) || fType.isAssignableFrom(Double.class) || fType.isAssignableFrom(Double.TYPE) || fType.isAssignableFrom(Float.class) || fType.isAssignableFrom(Float.TYPE);
    }

    public final String getAddColumnQuery(Field field) throws AnnotationNotFound, UnsupportedFieldType, InvalidAnnotationData {
        LiteColumn liteColumn = field.getAnnotation(LiteColumn.class);
        if (liteColumn == null) {
            throw new AnnotationNotFound(LiteColumn.class);
        }
        StringBuffer sql = new StringBuffer("ALTER TABLE ");
        sql.append("[").append(this.getTableName()).append("]");
        sql.append(" ADD COLUMN ");
        sql.append("[").append(this.getColumnName(field)).append("]");
        sql.append(" ").append(this.getColumnType(field));
        if (liteColumn.isAutoincrement()) {
            this.verifyAutoincrement(field);
            sql.append(" ").append("AUTOINCREMENT");
        }
        if (liteColumn.isNotNull()) {
            sql.append(" ").append("NOT NULL");
        }
        if (liteColumn.defaultValue().length() > 0) {
            sql.append(" ").append("DEFAULT ").append(liteColumn.defaultValue());
        }
        return sql.toString();
    }

    public final String getColumnType(Field field) throws UnsupportedFieldType {
        return this.getLiteColumnType(field).toString();
    }

    public final LiteColumnType getLiteColumnType(Field field) throws UnsupportedFieldType {
        Class<Object> fieldType = field.getType();
        LiteColumn liteColumn = field.getAnnotation(LiteColumn.class);
        if (fieldType.isAssignableFrom(Long.class) || fieldType.isAssignableFrom(Long.TYPE) || fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Integer.TYPE) || fieldType.isAssignableFrom(Short.class) || fieldType.isAssignableFrom(Short.TYPE) || fieldType.isAssignableFrom(Byte.class) || fieldType.isAssignableFrom(Byte.TYPE) || fieldType.isAssignableFrom(Boolean.class) || fieldType.isAssignableFrom(Boolean.TYPE)) {
            return LiteColumnType.INTEGER;
        }
        if (fieldType.isAssignableFrom(String.class)) {
            return LiteColumnType.TEXT;
        }
        if (fieldType.isAssignableFrom(Byte[].class) || fieldType.isAssignableFrom(byte[].class) || Serializable.class.isAssignableFrom(fieldType.getClass()) || Externalizable.class.isAssignableFrom(fieldType.getClass())) {
            return LiteColumnType.BLOB;
        }
        if (fieldType.isAssignableFrom(Double.class) || fieldType.isAssignableFrom(Double.TYPE) || fieldType.isAssignableFrom(Float.class) || fieldType.isAssignableFrom(Float.TYPE)) {
            return LiteColumnType.REAL;
        }
        if (fieldType.isAssignableFrom(Date.class) && (liteColumn.dateColumnType() == LiteColumnType.INTEGER || liteColumn.dateColumnType() == LiteColumnType.REAL || liteColumn.dateColumnType() == LiteColumnType.TEXT)) {
            return LiteColumnType.DATE;
        }
        throw new UnsupportedFieldType(this.clazz, field);
    }

    public final LiteFieldType getLiteFieldType(Field field) throws UnsupportedFieldType {
        Class<Object> fieldType = field.getType();
        if (fieldType.isAssignableFrom(Long.class) || fieldType.isAssignableFrom(Long.TYPE)) {
            return LiteFieldType.LONG;
        }
        if (fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Integer.TYPE)) {
            return LiteFieldType.INTEGER;
        }
        if (fieldType.isAssignableFrom(Short.class) || fieldType.isAssignableFrom(Short.TYPE)) {
            return LiteFieldType.SHORT;
        }
        if (fieldType.isAssignableFrom(Byte.class) || fieldType.isAssignableFrom(Byte.TYPE)) {
            return LiteFieldType.BYTE;
        }
        if (fieldType.isAssignableFrom(Boolean.class) || fieldType.isAssignableFrom(Boolean.TYPE)) {
            return LiteFieldType.BOOLEAN;
        }
        if (fieldType.isAssignableFrom(String.class)) {
            return LiteFieldType.STRING;
        }
        if (fieldType.isAssignableFrom(Byte[].class) || fieldType.isAssignableFrom(byte[].class)) {
            return LiteFieldType.BYTE_ARRAY;
        }
        if (Serializable.class.isAssignableFrom(fieldType.getClass()) || Externalizable.class.isAssignableFrom(fieldType.getClass())) {
            return LiteFieldType.SERIALIZABLE;
        }
        if (fieldType.isAssignableFrom(Double.class) || fieldType.isAssignableFrom(Double.TYPE)) {
            return LiteFieldType.DOUBLE;
        }
        if (fieldType.isAssignableFrom(Float.class) || fieldType.isAssignableFrom(Float.TYPE)) {
            return LiteFieldType.FLOAT;
        }
        if (fieldType.isAssignableFrom(Date.class)) {
            return LiteFieldType.DATE;
        }
        throw new UnsupportedFieldType(this.clazz, field);
    }

    public final Field getPrimaryField() throws InvalidAnnotationData {
        return this.getPrimaryField(this.clazz);
    }

    public final Field getPrimaryField(Class<?> targetClass) throws InvalidAnnotationData {
        for (Field field : targetClass.getDeclaredFields()) {
            LiteColumn liteColumn;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((liteColumn = field.getAnnotation(LiteColumn.class)) == null || !liteColumn.isPrimaryKey()) continue;
            return field;
        }
        Class<?> parent = targetClass.getSuperclass();
        if (parent.isAssignableFrom(targetClass.getAnnotation(LiteTable.class).allowedParent())) {
            for (Field field : parent.getDeclaredFields()) {
                LiteColumn liteColumn;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((liteColumn = field.getAnnotation(LiteColumn.class)) == null || !liteColumn.isPrimaryKey()) continue;
                return field;
            }
        }
        throw new InvalidAnnotationData("No primary key found for table " + this.clazz.getName());
    }

    public LiteTableMeta generateTableMeta() throws AnnotationNotFound, InvalidAnnotationData, UnsupportedFieldType {
        LiteTableMeta meta = new LiteTableMeta();
        meta.setTableName(this.getTableName());
        HashMap<String, LiteColumnMeta> columns = new HashMap<String, LiteColumnMeta>();
        this.generateTableMeta(meta, columns, this.clazz);
        Class<?> parent = this.clazz.getSuperclass();
        if (parent.isAssignableFrom(this.clazz.getAnnotation(LiteTable.class).allowedParent())) {
            this.generateTableMeta(meta, columns, parent);
        }
        if (meta.getPrimaryKey().length() == 0) {
            throw new InvalidAnnotationData("Require one primary key. Simply to extends LiteEntity class");
        }
        meta.setColumns(columns);
        String[] selectColumns = new String[columns.size()];
        String[] selectFields = new String[columns.size()];
        Iterator<String> fieldNames = columns.keySet().iterator();
        int count = 0;
        ArrayList<String> insertFields = new ArrayList<String>();
        ArrayList<String> updateFields = new ArrayList<String>();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            LiteColumnMeta columnMeta = columns.get(fieldName);
            selectColumns[count] = "[" + columnMeta.getColumnName() + "]" + ("".equals(columnMeta.getAlias()) ? "" : " AS [" + columnMeta.getAlias() + "]");
            selectFields[count] = fieldName;
            if (!columnMeta.isAutoincrement() && !insertFields.contains(fieldName)) {
                insertFields.add(fieldName);
            }
            if (!(columnMeta.isPrimaryKey() || columnMeta.isAutoincrement() || updateFields.contains(fieldName))) {
                updateFields.add(fieldName);
            }
            ++count;
        }
        meta.setSelectColumns(selectColumns);
        meta.setSelectFields(selectFields);
        String[] listInsertFields = new String[insertFields.size()];
        insertFields.toArray(listInsertFields);
        meta.setInsertFields(listInsertFields);
        String[] listUpdateFields = new String[updateFields.size()];
        updateFields.toArray(listUpdateFields);
        meta.setUpdateFields(listUpdateFields);
        meta.setInsertQuery(this.generateInsertQuery(meta));
        meta.setUpdateQuery(this.generateUpdateQuery(meta));
        return meta;
    }

    public String generateUpdateQuery(LiteTableMeta tableMeta) {
        String[] updateFields = tableMeta.getUpdateFields();
        StringBuffer query = new StringBuffer("UPDATE [" + tableMeta.getTableName() + "] SET ");
        for (int i = 0; i < updateFields.length; ++i) {
            query.append("[").append(tableMeta.getColumns().get(updateFields[i]).getColumnName()).append("]").append(" = ?");
            if (i >= updateFields.length - 1) continue;
            query.append(",");
        }
        query.append(" WHERE ").append("[").append(tableMeta.getColumns().get(tableMeta.getPrimaryKey()).getColumnName()).append("]").append(" = ?");
        return query.toString();
    }

    public String generateInsertQuery(LiteTableMeta tableMeta) {
        String[] insertFields = tableMeta.getInsertFields();
        StringBuffer query = new StringBuffer("INSERT INTO [" + tableMeta.getTableName() + "](");
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < insertFields.length; ++i) {
            query.append("[").append(tableMeta.getColumns().get(insertFields[i]).getColumnName()).append("]");
            params.append("?");
            if (i >= insertFields.length - 1) continue;
            query.append(",");
            params.append(",");
        }
        query.append(") VALUES (").append(params.toString()).append(")");
        return query.toString();
    }

    private void generateTableMeta(LiteTableMeta tableMeta, HashMap<String, LiteColumnMeta> columns, Class<?> clazz) throws UnsupportedFieldType {
        for (Field field : clazz.getDeclaredFields()) {
            LiteColumn liteColumn;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((liteColumn = field.getAnnotation(LiteColumn.class)) == null) continue;
            if (liteColumn.isPrimaryKey() && tableMeta.getPrimaryKey().length() == 0) {
                tableMeta.setPrimaryKey(field.getName());
            }
            LiteColumnMeta columnMeta = new LiteColumnMeta();
            columnMeta.setField(field);
            columnMeta.setDateColumnType(liteColumn.dateColumnType());
            String name = liteColumn.name();
            if (name == null || name.length() == 0) {
                name = field.getName();
            }
            columnMeta.setColumnName(name);
            columnMeta.setColumnType(this.getLiteColumnType(field));
            columnMeta.setFieldType(this.getLiteFieldType(field));
            columnMeta.setIsAutoincrement(liteColumn.isAutoincrement());
            columnMeta.setIsPrimaryKey(liteColumn.isPrimaryKey());
            columnMeta.setIsNotNull(liteColumn.isNotNull());
            columnMeta.setDefaultValue(liteColumn.defaultValue());
            columnMeta.setAlias(liteColumn.alias());
            columns.put(field.getName(), columnMeta);
        }
    }
}

