/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb.bulk;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.luhonghai.litedb.LiteColumnType;
import com.luhonghai.litedb.LiteFieldType;
import com.luhonghai.litedb.exception.InvalidAnnotationData;
import com.luhonghai.litedb.exception.LiteDatabaseException;
import com.luhonghai.litedb.meta.LiteTableMeta;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractBulk<T> {
    private final SQLiteDatabase database;
    private SQLiteStatement sqLiteStatement;
    private final LiteTableMeta tableMeta;
    private final SimpleDateFormat sdfDateValue;
    private boolean useTransaction = true;

    public AbstractBulk(SQLiteDatabase database, LiteTableMeta tableMeta) {
        this.database = database;
        this.tableMeta = tableMeta;
        this.sdfDateValue = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        this.sdfDateValue.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public AbstractBulk(SQLiteDatabase database, LiteTableMeta tableMeta, boolean useTransaction) {
        this(database, tableMeta);
        this.useTransaction = useTransaction;
    }

    protected abstract String getQuery();

    public LiteTableMeta getTableMeta() {
        return this.tableMeta;
    }

    public SQLiteStatement getSqLiteStatement() {
        return this.sqLiteStatement;
    }

    public void begin() {
        if (this.useTransaction) {
            this.database.beginTransaction();
        }
        this.sqLiteStatement = this.database.compileStatement(this.getQuery());
    }

    /*
     * Unable to fully structure code
     */
    protected void bindObject(T object, String fieldName, int index) throws LiteDatabaseException {
        block34: {
            block33: {
                meta = this.tableMeta.getColumns().get(fieldName);
                defaultValue = meta.getDefaultValue();
                field = meta.getField();
                field.setAccessible(true);
                try {
                    fieldValue = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new LiteDatabaseException("could not get field value", e);
                }
                if (!"".equals(defaultValue)) {
                    fieldValue = defaultValue;
                }
                if (fieldValue != null) break block33;
                this.sqLiteStatement.bindNull(index);
                break block34;
            }
            block7 : switch (1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[meta.getFieldType().ordinal()]) {
                case 1: {
                    this.sqLiteStatement.bindLong(index, (long)(Boolean.parseBoolean(fieldValue.toString()) != false ? 1 : 0));
                    break;
                }
                case 2: {
                    this.sqLiteStatement.bindLong(index, (long)Byte.valueOf(fieldValue.toString()).byteValue());
                    break;
                }
                case 3: 
                case 4: {
                    outputStream = null;
                    objectOutputStream = null;
                    outputStream = new ByteArrayOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(fieldValue);
                    this.sqLiteStatement.bindBlob(index, outputStream.toByteArray());
                    objectOutputStream.flush();
                    outputStream.flush();
                    if (objectOutputStream == null) ** GOTO lbl39
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
lbl39:
                    // 3 sources

                    if (outputStream == null) break;
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {}
                    break;
                    catch (IOException e) {
                        try {
                            throw new LiteDatabaseException("could not parse byte array data", e);
                        }
                        catch (Throwable var11_14) {
                            if (objectOutputStream != null) {
                                try {
                                    objectOutputStream.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            throw var11_14;
                        }
                    }
                }
                case 5: {
                    switch (1.$SwitchMap$com$luhonghai$litedb$LiteColumnType[meta.getDateColumnType().ordinal()]) {
                        case 1: {
                            this.sqLiteStatement.bindString(index, this.sdfDateValue.format((Date)fieldValue));
                            break block7;
                        }
                        case 2: {
                            this.sqLiteStatement.bindLong(index, ((Date)fieldValue).getTime());
                            break block7;
                        }
                    }
                    throw new LiteDatabaseException("Invalid date column type " + meta.getDateColumnType().toString(), new InvalidAnnotationData("Invalid dateColumnType"));
                }
                case 6: {
                    this.sqLiteStatement.bindDouble(index, Double.parseDouble(fieldValue.toString()));
                    break;
                }
                case 7: {
                    this.sqLiteStatement.bindDouble(index, (double)Float.parseFloat(fieldValue.toString()));
                    break;
                }
                case 8: {
                    this.sqLiteStatement.bindLong(index, (long)Integer.parseInt(fieldValue.toString()));
                    break;
                }
                case 9: {
                    this.sqLiteStatement.bindLong(index, Long.parseLong(fieldValue.toString()));
                    break;
                }
                case 10: {
                    this.sqLiteStatement.bindLong(index, (long)Short.parseShort(fieldValue.toString()));
                    break;
                }
                case 11: {
                    this.sqLiteStatement.bindString(index, fieldValue.toString());
                    break;
                }
                default: {
                    this.sqLiteStatement.bindNull(index);
                }
            }
        }
    }

    public long[] execute(Collection<T> list) throws LiteDatabaseException {
        if (list == null || list.size() == 0) {
            return new long[0];
        }
        long[] ids = new long[list.size()];
        int count = 0;
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            ids[count++] = this.execute(iterator.next());
        }
        return ids;
    }

    public long[] execute(T[] list) throws LiteDatabaseException {
        if (list == null || list.length == 0) {
            return new long[0];
        }
        long[] ids = new long[list.length];
        for (int i = 0; i < list.length; ++i) {
            ids[i] = this.execute(list[i]);
        }
        return ids;
    }

    public abstract long execute(T var1) throws LiteDatabaseException;

    public void success() {
        if (this.useTransaction) {
            this.database.setTransactionSuccessful();
        }
    }

    public void end() {
        if (this.useTransaction) {
            this.database.endTransaction();
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$luhonghai$litedb$LiteColumnType;
        static final /* synthetic */ int[] $SwitchMap$com$luhonghai$litedb$LiteFieldType;

        static {
            $SwitchMap$com$luhonghai$litedb$LiteFieldType = new int[LiteFieldType.values().length];
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.SERIALIZABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.BYTE_ARRAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.FLOAT.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.INTEGER.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.LONG.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.SHORT.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteFieldType[LiteFieldType.STRING.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$com$luhonghai$litedb$LiteColumnType = new int[LiteColumnType.values().length];
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteColumnType[LiteColumnType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$luhonghai$litedb$LiteColumnType[LiteColumnType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

