/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb.bulk;

import android.database.sqlite.SQLiteDatabase;
import com.luhonghai.litedb.bulk.AbstractBulk;
import com.luhonghai.litedb.exception.LiteDatabaseException;
import com.luhonghai.litedb.meta.LiteTableMeta;

public class BulkInsert<T>
extends AbstractBulk<T> {
    public BulkInsert(SQLiteDatabase database, LiteTableMeta tableMeta) {
        super(database, tableMeta);
    }

    public BulkInsert(SQLiteDatabase database, LiteTableMeta tableMeta, boolean useTransaction) {
        super(database, tableMeta, useTransaction);
    }

    @Override
    protected String getQuery() {
        return this.getTableMeta().getInsertQuery();
    }

    @Override
    public long execute(T object) throws LiteDatabaseException {
        String[] fields = this.getTableMeta().getInsertFields();
        for (int i = 0; i < fields.length; ++i) {
            int index = i + 1;
            String fieldName = fields[i];
            this.bindObject(object, fieldName, index);
        }
        long rowId = this.getSqLiteStatement().executeInsert();
        this.getSqLiteStatement().clearBindings();
        return rowId;
    }
}

