/*
 * Decompiled with CFR 0.152.
 */
package com.luhonghai.litedb.bulk;

import android.database.sqlite.SQLiteDatabase;
import com.luhonghai.litedb.bulk.AbstractBulk;
import com.luhonghai.litedb.exception.LiteDatabaseException;
import com.luhonghai.litedb.meta.LiteTableMeta;

public class BulkUpdate<T>
extends AbstractBulk<T> {
    public BulkUpdate(SQLiteDatabase database, LiteTableMeta tableMeta) {
        super(database, tableMeta);
    }

    public BulkUpdate(SQLiteDatabase database, LiteTableMeta tableMeta, boolean useTransaction) {
        super(database, tableMeta, useTransaction);
    }

    @Override
    protected String getQuery() {
        return this.getTableMeta().getUpdateQuery();
    }

    @Override
    public long execute(T object) throws LiteDatabaseException {
        String[] fields = this.getTableMeta().getUpdateFields();
        for (int i = 0; i < fields.length; ++i) {
            int index = i + 1;
            String fieldName = fields[i];
            this.bindObject(object, fieldName, index);
        }
        this.bindObject(object, this.getTableMeta().getPrimaryKey(), fields.length + 1);
        this.getSqLiteStatement().execute();
        this.getSqLiteStatement().clearBindings();
        return 1L;
    }
}

