/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzC5;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYEA;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzYEA zzYAZ;

    BorderCollection(zzYEA parent) {
        this.zzYAZ = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzWQY.zzYDl(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzX4s().equals(brColl.zzX4s()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzYAZ.getPossibleBorderKeys().zzWwL(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzYAZ.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzYAZ, borderKey);
            this.zzYAZ.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzYAZ.getPossibleBorderKeys().zzSq().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzYAZ.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzYAZ.getPossibleBorderKeys().zzSq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX96(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzYAZ.getPossibleBorderKeys().zzSq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX96(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzX4s().zzXLN();
    }

    public final void setColor(Color value) throws Exception {
        this.zzYZl(zzC5.zzWWH(value));
    }

    private zzC5 zzX4s() throws Exception {
        return this.get(0).zzX4s();
    }

    private void zzYZl(zzC5 zzC52) throws Exception {
        Iterator iterator = this.zzYAZ.getPossibleBorderKeys().zzSq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX96(n)) continue;
            this.getByBorderType(n).zzYZl(zzC52);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzYAZ.getPossibleBorderKeys().zzSq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX96(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzYAZ.getPossibleBorderKeys().zzSq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX96(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzWwL(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzX96(int n) {
        return n != 6 && n != 7;
    }

    static final class zzWwL
    implements Iterator<Border> {
        private BorderCollection zzWl9;
        private int zzW7F;

        zzWwL(BorderCollection borderCollection) {
            this.zzWl9 = borderCollection;
            this.zzW7F = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzW7F >= this.zzWl9.getCount() - 1) {
                return false;
            }
            ++this.zzW7F;
            return true;
        }

        private Border zzYcL() {
            try {
                return this.zzWl9.get(this.zzW7F);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzYcL();
        }
    }
}

