/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.zz84;
import com.aspose.words.zzBM;
import com.aspose.words.zzVZC;
import com.aspose.words.zzWyg;
import com.aspose.words.zzYAc;
import com.aspose.words.zzYUC;
import com.aspose.words.zzYWr;
import com.aspose.words.zzYhT;
import com.aspose.words.zzYp5;
import com.aspose.words.zzZtH;

public class Cell
extends CompositeNode<Node>
implements zz84,
zzWyg {
    private zzBM zzZk9;
    private CellFormat zzXOU;
    private ParagraphCollection zzWry;
    private TableCollection zzZjt;

    public Cell(DocumentBase doc) {
        this(doc, new zzBM());
    }

    Cell(DocumentBase doc, zzBM cellPr) {
        super(doc);
        this.zzZk9 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzW5m() {
        return (Cell)this.zzWX8();
    }

    public Row getParentRow() {
        return (Row)this.zzYX3();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzsJ() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZgA(this, true);
        }
        return -1;
    }

    final int zzY0() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzY0();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzXOU == null) {
            this.zzXOU = new CellFormat(this);
        }
        return this.zzXOU;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzWry == null) {
            this.zzWry = new ParagraphCollection(this);
        }
        return this.zzWry;
    }

    public TableCollection getTables() {
        if (this.zzZjt == null) {
            this.zzZjt = new TableCollection(this);
        }
        return this.zzZjt;
    }

    final zzBM zzZEf() {
        return this.zzZk9;
    }

    final void zzWwL(zzBM zzBM2) {
        this.zzZk9 = zzBM2;
    }

    @Override
    final Node zzWwL(boolean bl, zzVZC zzVZC2) {
        zzBM zzBM2;
        Cell cell = (Cell)super.zzWwL(bl, zzVZC2);
        zzBM zzBM3 = this.zzZk9;
        cell.zzZk9 = zzBM2 = (zzBM)zzBM3.zzW1Z();
        cell.zzXOU = null;
        cell.zzWry = null;
        cell.zzZjt = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWwL(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzWWH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzYp5.zzWdN(this);
    }

    @Override
    final boolean zzXgW(Node node) {
        return zzYUC.zzZq4(node);
    }

    final int zzVYx() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzWX8();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZk9.zzYN1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzZk9.zzYN1(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzYhT zzYhT2 = zzWQY.zzWwL(object, zzYhT.class);
        if (zzYhT2 != null && zzYhT2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzFV(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzBM.zzZDt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzZk9.zzZLz(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZk9.clear();
    }

    private Object zzFV(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWQY.zzWwL((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWwL(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZtH getInsertRevision() {
        Cell cell = this;
        return cell.zzZk9.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZtH value) {
        zz84 zz842 = this;
        zzZtH zzZtH2 = value;
        zz842 = zz842.zzZk9;
        ((zzYWr)((Object)zz842)).zzZLz(14, zzZtH2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZtH getDeleteRevision() {
        Cell cell = this;
        return cell.zzZk9.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZtH value) {
        zz84 zz842 = this;
        zzZtH zzZtH2 = value;
        zz842 = zz842.zzZk9;
        ((zzYWr)((Object)zz842)).zzZLz(12, zzZtH2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYAc getMoveFromRevision() {
        Cell cell = this;
        return cell.zzZk9.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYAc value) {
        zz84 zz842 = this;
        zzYAc zzYAc2 = value;
        zz842 = zz842.zzZk9;
        ((zzYWr)((Object)zz842)).zzZLz(13, zzYAc2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYAc getMoveToRevision() {
        Cell cell = this;
        return cell.zzZk9.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYAc value) {
        zz84 zz842 = this;
        zzYAc zzYAc2 = value;
        zz842 = zz842.zzZk9;
        ((zzYWr)((Object)zz842)).zzZLz(15, zzYAc2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzZk9.remove(13);
        cell = this;
        cell.zzZk9.remove(15);
    }

    final zzBM zzWGd(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzBM zzBM2 = new zzBM();
        this.zzWwL(3120, zzBM2);
        this.zzWwL(3140, zzBM2);
        this.zzWwL(3110, zzBM2);
        this.zzWwL(3130, zzBM2);
        this.zzWwL(3090, zzBM2);
        this.zzWwL(3100, zzBM2);
        this.zzWwL(3070, zzBM2);
        this.zzWwL(3080, zzBM2);
        if (bl && (tableStyle = zzWQY.zzWwL((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWWH(this, zzBM2);
        }
        this.zzZk9.zzWWH((zzYWr)zzBM2);
        return zzBM2;
    }

    private void zzWwL(int n, zzBM zzBM2) {
        zzBM2.zzZLz(n, this.fetchInheritedCellAttr(n));
    }
}

