/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzYcY;
import com.aspose.words.zzVWW;
import com.aspose.words.zzWBi;
import com.aspose.words.zzWMy;
import com.aspose.words.zzWdP;
import com.aspose.words.zzWi7;
import com.aspose.words.zzYGy;
import com.aspose.words.zzYqp;
import com.aspose.words.zzZ3V;
import com.aspose.words.zzZkf;
import com.aspose.words.zzZwX;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzWMy zzYLL;

    ChartSeriesCollection(zzWMy dmlChart) {
        this.zzYLL = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYLL.zznr().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYLL.zznr().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYLL.zznr().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYLL.zznr().clear();
        this.zzWTe(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWwL(seriesName, values);
        chartSeries.zzYPb().zzY4i(ChartSeriesCollection.zzY7A(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWwL(seriesName, yValues);
        chartSeries.zzYPb().zzY4i(ChartSeriesCollection.zzY4i(xValues));
        return chartSeries;
    }

    private ChartSeries zzWwL(String string, zzYcY[] zzYcYArray, double[] dArray) {
        if (zzYcYArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYcYArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYcYArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWwL(string, dArray);
        chartSeries.zzYPb().zzY4i(ChartSeriesCollection.zzWwL(zzYcYArray));
        if (!this.zzYLL.zzzv()) {
            this.zzWTe(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWwL(seriesName, zzYcY.zzWwL(dates), values);
    }

    private void zzWTe(boolean bl) {
        zzZkf zzZkf2 = zzWQY.zzWwL((Object)this.zzYLL, zzZkf.class);
        if (zzZkf2 != null && zzZkf2.zzW5Y().zzXJ3()) {
            zzZkf2.zzW5Y().zzW7j().zzYDl(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzYLL.zzYfi() != 15) {
            this.zzYLL.zzXQ0(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWwL(seriesName, yValues);
        chartSeries.zzWR2().zzGI().zzYDl(3, this.zzYLL.zzZUi());
        chartSeries.zzYPb().zzY4i(ChartSeriesCollection.zzY4i(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzYze().zzY4i(ChartSeriesCollection.zzY4i(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWwL(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzYLL);
        chartSeries.setName(string);
        this.zzXuR(chartSeries);
        chartSeries.zztB(this.zzYLL.zzWWI().zzWtk() + 1);
        chartSeries.zzZXK(this.zzYLL.zzWWI().zzWez() + 1);
        chartSeries.zzXpM().zzY4i(ChartSeriesCollection.zzY4i(dArray));
        this.zzYLL.zzke().zzZYc();
        this.zzYLL.zznr().zzGb(chartSeries);
        return chartSeries;
    }

    private void zzXuR(ChartSeries chartSeries) {
        chartSeries.zzWR2().zzGI().zzYDl(5, new zzWi7());
        switch (this.zzYLL.zzYfi()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWwL(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWwL(chartSeries, 5);
                ChartSeriesCollection.zzB3(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWwL(chartSeries, 1);
                ChartSeriesCollection.zzB3(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZLz(chartSeries);
            }
        }
    }

    private static void zzZLz(ChartSeries chartSeries) {
        zzWi7 zzWi72 = new zzWi7();
        zzWi72.setOutline(new zzWdP());
        zzYGy zzYGy2 = new zzYGy();
        zzYGy2.zzXSK(1);
        zzWi72.getOutline().setFill(new zzZwX(zzYGy2));
        zzWi72.getOutline().zzYdJ(19050.0);
        chartSeries.zzWR2().zzGI().zzYDl(5, zzWi72);
    }

    private static void zzB3(ChartSeries chartSeries) {
        zzWi7 zzWi72 = new zzWi7();
        zzWi72.setOutline(new zzWdP());
        zzWi72.getOutline().setFill(new zzVWW());
        zzWi72.getOutline().setEndCap(0);
        zzWi72.getOutline().zzYdJ(19050.0);
        chartSeries.zzWR2().zzGI().zzYDl(5, zzWi72);
    }

    private static void zzWwL(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZx2());
        chartMarker.zzZvM().zzYDl(0, n);
        chartSeries.zzWR2().zzGI().zzYDl(4, chartMarker);
    }

    private static zzYqp zzY4i(double[] dArray) {
        int n = 0;
        zzYqp zzYqp2 = new zzYqp(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzYqp2.zzW3g(new zzWBi(n, d, "General"));
            }
            ++n;
        }
        zzYqp2.zzZ2P(dArray.length);
        return zzYqp2;
    }

    private static zzYqp zzWwL(zzYcY[] zzYcYArray) {
        int n = 0;
        zzYqp zzYqp2 = new zzYqp(2);
        zzYcY[] zzYcYArray2 = zzYcYArray;
        int n2 = zzYcYArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYcY zzYcY2 = zzYcYArray2[i];
            zzYqp2.zzW3g(new zzWBi(n++, zzYcY2.zzYlx(), "m/d/yyyy"));
        }
        zzYqp2.zzZ2P(zzYcYArray.length);
        return zzYqp2;
    }

    private static zzYqp zzY7A(String[] stringArray) {
        int n = 0;
        zzYqp zzYqp2 = new zzYqp(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzYqp2.zzW3g(new zzZ3V(n++, string));
        }
        zzYqp2.zzZ2P(stringArray.length);
        return zzYqp2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYLL.zznr().getCount();
    }
}

