/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.zzVZC;
import com.aspose.words.zzVZG;
import com.aspose.words.zzWo6;
import com.aspose.words.zzXjI;
import com.aspose.words.zzYUC;
import com.aspose.words.zzYm6;
import com.aspose.words.zzZv;
import com.aspose.words.zzl8;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWo6,
Iterable<T> {
    private Node zz3d;
    private Node zzdx;
    private Node zzbJ;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzWWH((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZjm() {
        return this.zzYjD() != null;
    }

    final boolean zzWWY() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzQD() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZv) {
                return true;
            }
            CompositeNode compositeNode = zzWQY.zzWwL((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzQD()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zz3d;
    }

    public Node getLastChild() {
        return this.zzdx;
    }

    final Node zzYjD() {
        return zzYUC.zzXYo(this.getFirstChild(), false);
    }

    final Node zzWLc() {
        return zzYUC.zzWcO(this.getLastChild(), false);
    }

    final CompositeNode zzX75() {
        return (CompositeNode)zzYUC.zzXYo(this.getFirstChild(), true);
    }

    final CompositeNode zzON() {
        return (CompositeNode)zzYUC.zzWcO(this.getLastChild(), true);
    }

    final Node zzVZD() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYUC.zzYrM((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzWzb() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYUC.zzYrM((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWwL(boolean bl, zzVZC zzVZC2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWwL(bl, zzVZC2);
        ((CompositeNode)super.zzWwL(bl, zzVZC2)).zzdx = null;
        compositeNode.zz3d = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWj5(node.zzWwL(true, zzVZC2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzqO(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzqO(StringBuilder stringBuilder) {
        this.zzZuu(stringBuilder);
        zzWQY.zzWWH(stringBuilder, this.zzYEz());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWWH(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYUC.zzXt1(nodeType);
            Node node2 = node = bl ? this.zzYjD() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZ5C() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzVZG.zzZgA(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzVZG.zzY4i(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXjI(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzWwL(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzWwL(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzWWH(oldChild, false);
    }

    private Node zzWWH(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWwL(node, (Node)this, null, 1);
        if (documentBase.zzXRh() && zzYUC.zzzm(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWwL(nodeChangingArgs);
        }
        if (!bl && zzYUC.zzXpV(node)) {
            zzYUC.zzZLz(node, false);
        }
        Node node2 = this.zzYvP(node);
        if (nodeChangingArgs != null) {
            documentBase.zzWWH(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzl8.zzYC1(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWj5(Node node) {
        node.getParentNode();
        if (this.zzdx == null) {
            node.zzoA(null);
            node.zzzL(null);
            this.zz3d = node;
        } else {
            node.zzoA(this.zzdx);
            node.zzzL(null);
            this.zzdx.zzzL(node);
        }
        this.zzdx = node;
        node.zzkf(this);
        return node;
    }

    final void zzWwL(Node node, Node node2, Node node3) {
        this.zzWwL(node, node2, node3, false);
    }

    final void zzWwL(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzXgW(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzWWH(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZgA(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYUC.zzYrM(node3.getNodeType())) continue;
            if (zzYUC.zzW1m(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYEz().length();
    }

    String zzYEz() {
        return "";
    }

    final String zzY2Y() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZuu(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZuu(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzqO(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWwL(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzWWH(visitor));
    }

    abstract int zzWwL(DocumentVisitor var1) throws Exception;

    abstract int zzWWH(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzXgW(Node var1);

    final Node zzWwL(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYdJ(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzXgW(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzYm6(documentBase);
            try {
                compositeNode.zzWWH(node, true);
            }
            finally {
                ((zzYm6)object).dispose();
            }
        }
        if ((object = documentBase.zzWwL(node, null, (Node)this, 0)) != null) {
            documentBase.zzWwL((NodeChangingArgs)object);
        }
        if (this.zzdx == null) {
            node.zzoA(null);
            node.zzzL(null);
            this.zz3d = node;
            this.zzdx = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzWWH(node, node2);
            } else {
                this.zzZgA(node, this.zz3d);
            }
        } else if (node2 != null) {
            this.zzZgA(node, node2);
        } else {
            this.zzWWH(node, this.zzdx);
        }
        node.zzkf(this);
        if (object != null) {
            documentBase.zzWWH((NodeChangingArgs)object);
        }
        if (documentBase.zzXRh()) {
            zzYUC.zzWwL(node, compositeNode, node3);
        }
        return node;
    }

    private void zzWWH(Node node, Node node2) {
        Node node3 = node2.zz9s();
        node.zzoA(node2);
        node.zzzL(node3);
        node2.zzzL(node);
        if (node3 == null) {
            this.zzdx = node;
            return;
        }
        node3.zzoA(node);
    }

    private void zzZgA(Node node, Node node2) {
        Node node3 = node2.zz3a();
        node.zzoA(node3);
        node.zzzL(node2);
        node2.zzoA(node);
        if (node3 == null) {
            this.zz3d = node;
            return;
        }
        node3.zzzL(node);
    }

    private Node zzYvP(Node node) {
        if (node == this.zz3d) {
            if (this.zz3d == this.zzdx) {
                this.zz3d = null;
                this.zzdx = null;
            } else {
                this.zz3d = node.zz9s();
                this.zz3d.zzoA(null);
            }
        } else {
            Node node2 = node.zz3a();
            Node node3 = node.zz9s();
            node2.zzzL(node3);
            if (node3 == null) {
                this.zzdx = node2;
            } else {
                node3.zzoA(node2);
            }
        }
        node.zzzL(null);
        node.zzoA(null);
        node.zzkf(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzbJ = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzbJ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

