/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz6b;
import com.aspose.words.internal.zzW0X;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzWlC;
import com.aspose.words.internal.zzXKF;
import com.aspose.words.internal.zzXLX;
import com.aspose.words.internal.zzXlS;
import com.aspose.words.internal.zzYGB;
import com.aspose.words.internal.zzYJ7;
import com.aspose.words.internal.zzZ6K;
import com.aspose.words.internal.zzZpm;
import com.aspose.words.internal.zzxl;
import com.aspose.words.zzVD;
import com.aspose.words.zzVXw;
import com.aspose.words.zzWhe;
import com.aspose.words.zzXKj;
import com.aspose.words.zzY0X;
import com.aspose.words.zzYKe;
import com.aspose.words.zzYcL;
import com.aspose.words.zzYs0;
import com.aspose.words.zzZyI;
import com.aspose.words.zzsl;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWwL(zzXlS zzXlS2, zzXlS zzXlS3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWQY.zzWWH((Object)zzXlS2, "srcStream");
        zzWQY.zzWWH((Object)zzXlS3, "dstStream");
        zzWQY.zzWWH((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWWH(zzXlS2, zzXlS3, certificateHolder, signOptions);
        zzXlS3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWwL(zzXlS.zzWWH(srcStream), (zzXlS)zzXlS.zzZgA(dstStream), certHolder, signOptions);
    }

    private static void zzWWH(zzXlS zzXlS2, zzXlS zzXlS3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZgA(digitalSignature);
        }
        if (zzYs0.zzZqP(zzXlS2)) {
            DigitalSignatureUtil.zzWwL(zzXlS2, zzXlS3, digitalSignature, true);
            return;
        }
        zzYs0 zzYs02 = new zzYs0();
        zzXlS zzXlS4 = zzXlS2;
        zzYs0 zzYs03 = zzYs02;
        FileFormatInfo fileFormatInfo = zzYs02.zzWWH(zzXlS4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzxl zzxl2 = new zzxl(zzXlS2);
                int n = fileFormatInfo.zzXky() == 1 ? 1 : 2;
                zzYKe.zzWwL(zzxl2, digitalSignature, n);
                zzXlS3.zzZkV(0L);
                zzxl2.zzY7A(zzXlS3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWwL(fileFormatInfo.zzZWt(), zzXlS3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWwL(zzXlS2, zzXlS3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWwL(zzXlS2, zzXlS3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWQY.zzWWH(srcFileName, "srcFileName");
        zzWQY.zzWWH(dstFileName, "dstFileName");
        try (zzZ6K zzZ6K2 = zzWQY.zzWWH(srcFileName, 3, 1);){
            try (zzZ6K zzZ6K3 = zzWQY.zzWWH(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWwL((zzXlS)zzZ6K2, (zzXlS)zzZ6K3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzW0X zzW0X2 = zzXlS.zzZgA(dstStream);
        zzXlS zzXlS2 = zzXlS.zzWWH(srcStream);
        DigitalSignatureUtil.zzWwL(zzXlS2, (zzXlS)zzW0X2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZ6K zzZ6K2 = zzWQY.zzWWH(srcFileName, 3, 1);){
            try (zzZ6K zzZ6K3 = zzWQY.zzWWH(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzY4i(zzZ6K2, zzZ6K3);
            }
            return;
        }
    }

    private static void zzY4i(zzXlS zzXlS2, zzXlS zzXlS3) throws Exception {
        zzYs0 zzYs02 = new zzYs0();
        zzXlS zzXlS4 = zzXlS2;
        zzYs0 zzYs03 = zzYs02;
        FileFormatInfo fileFormatInfo = zzYs02.zzWWH(zzXlS4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzxl zzxl2 = new zzxl(zzXlS2);
                zzxl2.zzXUP().zzZYf("_xmlsignatures");
                zzxl2.zzXUP().zzZYf("_signatures");
                zzXlS3.zzWj5(0L);
                zzxl2.zzY7A(zzXlS3);
                zzXlS zzXlS5 = zzXlS3;
                zzXlS5.zzZkV(zzXlS5.zzXe1());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYJ7 zzYJ72 = new zzYJ7(zzXlS2);
                zzZpm zzZpm2 = zzYJ72.zzWwL(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZpm2 != null) {
                    for (zzYGB zzYGB2 : zzZpm2.zzY5u()) {
                        String string = zzZpm2.zzWwL(zzYGB2);
                        zzYJ72.zzWxV().remove(string);
                    }
                    zzYJ72.zzWxV().remove(zzZpm2.getName());
                    zzYGB zzYGB3 = zzYJ72.zzY5u().zzZDe("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYJ72.zzY5u().remove(zzYGB3.getId());
                    zzYJ72.zzWon();
                }
                zzXlS3.zzWj5(0L);
                zzYJ72.zzY7A(zzXlS3);
                zzXlS zzXlS6 = zzXlS3;
                zzXlS6.zzZkV(zzXlS6.zzXe1());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzY4i(zzXlS.zzWWH(srcStream), zzXlS.zzZgA(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZ6K zzZ6K2 = zzWQY.zzWWH(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzX3K(zzZ6K2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzX3K(zzXlS zzXlS2) throws Exception {
        if (zzYs0.zzZqP(zzXlS2)) {
            return DigitalSignatureUtil.zzY9g(zzXlS2);
        }
        zzYs0 zzYs02 = new zzYs0();
        zzXlS zzXlS3 = zzXlS2;
        zzYs0 zzYs03 = zzYs02;
        FileFormatInfo fileFormatInfo = zzYs02.zzWWH(zzXlS3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXlS2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzX3K(zzXlS.zzWWH(stream));
    }

    static zzXLX zzWwL(zzxl zzxl2, String string) throws Exception {
        zzWhe zzWhe2 = new zzWhe(zzxl2);
        if (zzWhe2.zzYQM()) {
            zzXLX zzXLX2 = zzWhe2.zzEl(string);
            return zzXLX2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzpn(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzWlC.zzWWH("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZbf(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzpn(n);
    }

    private static void zzWwL(zzXlS zzXlS2, zzXlS zzXlS3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYJ7 zzYJ72 = new zzYJ7(zzXlS2);
        zzXKj zzXKj2 = bl ? new zzsl(zzYJ72) : new zzZyI(zzYJ72);
        zzXKj2.zzWWH(digitalSignature);
        zzXlS3.zzZkV(0L);
        zzYJ72.zzY7A(zzXlS3);
    }

    private static void zzWwL(zzXlS zzXlS2, zzXlS zzXlS3, DigitalSignature digitalSignature) throws Exception {
        zzYcL zzYcL2 = new zzYcL(zzXlS2);
        zzVD zzVD2 = new zzVD(zzYcL2);
        zzVD2.zzWWH(digitalSignature);
        zzXlS3.zzZkV(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXlS zzXlS4 = zzXlS3;
        zzYcL zzYcL3 = zzYcL2;
        zzYcL3.zzWwL(zzXlS4, string, null);
    }

    private static void zzWwL(zzxl zzxl2, zzXlS zzXlS2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXLX zzXLX2 = DigitalSignatureUtil.zzWwL(zzxl2, string);
        zzXLX zzXLX3 = new zzXLX();
        DigitalSignatureUtil.zzWwL((zzXlS)zzXLX2, (zzXlS)zzXLX3, digitalSignature, false);
        zzxl zzxl3 = zzWhe.zzZgA(zzXLX3, string);
        zzxl3.zzY7A(zzXlS2);
    }

    private static DigitalSignatureCollection zzY9g(zzXlS zzXlS2) throws Exception {
        zzXlS2.zzWj5(0L);
        zzYJ7 zzYJ72 = new zzYJ7(zzXlS2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZpm zzZpm2 = zzYJ72.zzWwL(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZpm2 != null) {
            for (zzYGB zzYGB2 : zzZpm2.zzY5u()) {
                String string = zzZpm2.zzWwL(zzYGB2);
                zzZpm zzZpm3 = zzYJ72.zzis(string);
                zzZpm zzZpm4 = zzYJ72.zzWwL(zzZpm3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zz6b zz6b2 = zzXKF.zzWdN(zzZpm4.zzXXZ().zzYQf());
                zzY0X.zzWwL(zzZpm3.zzWVq(), zz6b2, new zzVXw(zzYJ72), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

