/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzVPx;
import com.aspose.words.internal.zzW4n;
import com.aspose.words.internal.zzWFX;
import com.aspose.words.internal.zzWN9;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzWZb;
import com.aspose.words.internal.zzWlC;
import com.aspose.words.internal.zzX6I;
import com.aspose.words.internal.zzX7R;
import com.aspose.words.internal.zzXDr;
import com.aspose.words.internal.zzXLX;
import com.aspose.words.internal.zzXR5;
import com.aspose.words.internal.zzXin;
import com.aspose.words.internal.zzXlS;
import com.aspose.words.internal.zzXml;
import com.aspose.words.internal.zzXs7;
import com.aspose.words.internal.zzYfj;
import com.aspose.words.internal.zzZO4;
import com.aspose.words.zz84;
import com.aspose.words.zzBM;
import com.aspose.words.zzJR;
import com.aspose.words.zzM0;
import com.aspose.words.zzRY;
import com.aspose.words.zzVPB;
import com.aspose.words.zzVT2;
import com.aspose.words.zzVYA;
import com.aspose.words.zzWC2;
import com.aspose.words.zzWH7;
import com.aspose.words.zzWYd;
import com.aspose.words.zzWsp;
import com.aspose.words.zzWt5;
import com.aspose.words.zzWxx;
import com.aspose.words.zzWyg;
import com.aspose.words.zzXL4;
import com.aspose.words.zzXbW;
import com.aspose.words.zzXbl;
import com.aspose.words.zzXbz;
import com.aspose.words.zzXdF;
import com.aspose.words.zzXgn;
import com.aspose.words.zzXiC;
import com.aspose.words.zzXr0;
import com.aspose.words.zzXzh;
import com.aspose.words.zzY8J;
import com.aspose.words.zzYFq;
import com.aspose.words.zzYUC;
import com.aspose.words.zzYWr;
import com.aspose.words.zzYm6;
import com.aspose.words.zzYn2;
import com.aspose.words.zzYp5;
import com.aspose.words.zzYxJ;
import com.aspose.words.zzZ0L;
import com.aspose.words.zzZ5b;
import com.aspose.words.zzZIV;
import com.aspose.words.zzZL1;
import com.aspose.words.zzZYL;
import com.aspose.words.zzZql;
import com.aspose.words.zzZsX;
import com.aspose.words.zzZxH;
import com.aspose.words.zzeW;
import com.aspose.words.zzek;
import com.aspose.words.zzvm;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz84,
zzXbl,
zzXgn {
    private Document zzWfu;
    private Node zz0A;
    private Node zzYkP;
    private zzWC2 zzWQ0;
    private Font zzWyL;
    private zzYfj<zzWC2> zzYqM;
    private zzYfj<zzXdF> zzWe6;
    private zzYfj<zzWwL> zzVOK;
    private zzYxJ zzZTq = zzYxJ.zzZF5();
    private zzBM zzZk9 = new zzBM();
    private RowFormat zzB0;
    private CellFormat zzXOU;
    private zzYfj<zzJR> zzYpB;
    private int zzW1l = 0;
    private int zzYCg = -1;
    private int zzWgn;
    private boolean zzZF7;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXuR(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXuR(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXuR(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWwL(documentBuilder.getCurrentSection(), zzYp5.zzVTB(headerFooterType), 0, 0);
    }

    private void zzXuR(int n, int n2, int n3, int n4) {
        this.zzWfu.ensureMinimum();
        Section section = (Section)this.zzWfu.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWwL(section, 1, n3, n4);
    }

    private void zzWwL(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYp5.zzy9(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzWfu, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWfu));
            }
        }
        this.zzWwL(story, n2, n3);
    }

    private void zzWwL(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWwL((CompositeNode)paragraph2, n3);
    }

    final void zzWwL(Paragraph paragraph, int n) {
        this.zzWwL((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzoo().zzPT() ? zzRY.zzW3g(this.zzWfu, fieldName) : zzRY.zzXgW(this.zzoo(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWwL(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWwL(field, isAfter, false);
    }

    private boolean zzWwL(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWsp zzWsp2 = field.getFormat().zzXlE();
        Inline inline = zzWsp2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWwL(inline.zzWBc(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzWYd.zzWwL(this.zzWfu, bookmarkName) : zzWYd.zzWWH(this.zzWfu, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWTV() == 6) {
            this.zzWwL((Paragraph)node.zzYX3(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYUC.zzRw(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzWwL(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWwL(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzWWH(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzWwL(structuredDocumentTag);
            return;
        }
        this.zzZgA(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZah(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzWwL(cell, characterIndex);
    }

    private void zzWwL(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWTV() == 6) {
            this.zzYWr(node);
        } else {
            Node node2 = node;
            if (zzYUC.zzYrM(node2.getNodeType())) {
                Paragraph paragraph = zzYUC.zzRw(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYWr(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWTV() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYWr(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzWgn = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZHr();
            return;
        }
        if (!this.zzZfe()) {
            this.zzZHr();
        }
    }

    private boolean zzZfe() {
        Node node = this.zzoo();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzoo().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWwL(((StructuredDocumentTag)documentBuilder.zzoo().getParentNode()).zzY8Q(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzoo(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWwL(inline.zzWBc(), true);
            return true;
        }
        return false;
    }

    private void zzZHr() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWwL(documentBuilder.getCurrentParagraph().zzXVq(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZah(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXYC() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzoo().zzYdJ(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWX8();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWwL((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzXT(text, false);
    }

    public void writeln(String text) {
        this.zzXT(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        this.zzWaH();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzYm6 zzYm62 = new zzYm6(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzWfu, this.zzWzk(), this.zzYAC());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzWWH(this.zzoo(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzYm62.dispose();
        }
        if (this.getDocument().zzXRh()) {
            zzYUC.zzZgA((zzWyg)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzh0());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZXj() {
        zzWC2 zzWC22;
        Run run;
        Run run2;
        zzXgn zzXgn2;
        this.zzWaH();
        Node node = this.zzoo();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzXgn2 = paragraph;
            run2 = zzXgn2.zzZxA(false);
        } else {
            run2 = run = (Run)node.zzZZA(21);
        }
        if (run2 == null && zzWQY.zzYDl(node, paragraph.zzRT())) {
            run = paragraph.zzRT();
        }
        if (run != null) {
            zzXgn2 = run.zzWBc();
            zzWC22 = (zzWC2)((zzYWr)((Object)zzXgn2)).zzW1Z();
        } else {
            zzXgn2 = paragraph.zzXVq();
            zzWC22 = (zzWC2)((zzYWr)((Object)zzXgn2)).zzW1Z();
        }
        zzWC2 zzWC23 = zzWC22;
        Paragraph paragraph2 = new Paragraph(this.zzWfu, this.zzWzk(), zzWC23);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYm6 zzYm62 = new zzYm6(this.zzWfu);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWWH(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYm62.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzZql.zzW3g(this);
    }

    public void insertBreak(int breakType) {
        this.zzXxI(breakType, true);
    }

    final void zzXxI(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzYOE(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZHO(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzYXq())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzYOE(bl)) {
                        this.zzZHO(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzYOE(bl)) {
                        this.zzZT2(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzYOE(bl)) {
                        this.zzZT2(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzYOE(bl)) {
                        this.zzZT2(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzYOE(bl)) {
                        this.zzZT2(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzYOE(bl)) {
                        this.zzZT2(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZHO(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZO4.zzWO(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzWlC.zzWWH("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzWaH();
        return zzYUC.zzWwL(fieldType, updateField, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzWaH();
        return zzYUC.zzWwL(fieldCode, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzWaH();
        return zzYUC.zzWwL(fieldCode, fieldValue, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWQY.zzWWH((Object)displayText, "displayText");
        zzWQY.zzWWH((Object)urlOrBookmark, "hrefOrBookmark");
        zzWH7 zzWH72 = this.zzWWH(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzWH72.zzWWH(documentBuilder.zzX64(88, true));
        return zzYUC.zzWwL(zzWH72.getStart(), zzWH72.getSeparator(), zzWH72.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWti(70);
        if (zzZO4.zzWO(name)) {
            this.startBookmark(name);
        }
        this.zzW8t(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzWAs(70);
        String string = zzZO4.zzWO(fieldValue) ? fieldValue : FormField.zzX4e;
        Run run = new Run(this.zzWfu, string, this.zzYAC());
        this.insertNode(run);
        Node node = this.zzX64(70, true);
        if (zzZO4.zzWO(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZsX(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzWwL((Paragraph)node.zzYX3(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWti(71);
        if (zzZO4.zzWO(name)) {
            this.startBookmark(name);
        }
        this.zzW8t(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzX64(71, false);
        if (zzZO4.zzWO(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZsX(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWti(83);
        if (zzZO4.zzWO(name)) {
            this.startBookmark(name);
        }
        this.zzW8t(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzX64(83, false);
        if (zzZO4.zzWO(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZsX(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWfu, footnoteType, !zzZO4.zzWO(referenceMark), referenceMark, this.zzYAC());
        Style style = this.getDocument().getStyles().zzXVu(zzYUC.zzZxZ(footnoteType));
        footnote.zzWBc().set(50, style.zzQ8());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWfu);
        Style style2 = this.getDocument().getStyles().zzXVu(zzYUC.zzYCw(footnoteType));
        paragraph.zzVWb().set(1000, style2.zzQ8());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWfu, '\u0002', new zzWC2()) : new Run(this.zzWfu, footnote.getReferenceMark(), new zzWC2());
        inline.zzWBc().set(50, style.zzQ8());
        paragraph.appendChild(inline);
        if (zzZO4.zzWO(footnoteText)) {
            Node node = this.zzoo();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYWr(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZLT(zzXlS zzXlS2) throws Exception {
        return this.zzWwL(zzXlS2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZLT(zzXlS.zzWWH(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWwL(zzXlS zzXlS2, double d, double d2) throws Exception {
        return this.zzWwL(zzXlS2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWwL(zzXlS.zzWWH(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzXLX zzXLX2 = new zzXLX();){
            zzXDr.zzWwL(image, zzXLX2);
            Shape shape = this.zzWwL(zzXLX2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWQY.zzWWH(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzX7R.zz82(fileName);
        try {
            Shape shape = this.zzWwL((zzXlS)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXlS)object).close();
            }
        }
    }

    private Shape zzWwL(zzXlS zzXlS2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXlS2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzWQY.zzW1m(zzXlS2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWwL(zzXlS.zzWWH(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWwL(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzWwL(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzWZb.zzoU(object)) {
            object4 = new zzXDr((byte[])object);
            bl2 = true;
            ((zzWN9)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzWfu.getCompatibilityOptions().getMswVersion() > 12 || this.zzWfu.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzWfu, 0);
            object3 = new zzXzh();
            ((zzVYA)object3).zzWwL(zzWxx.zz6w("rect"));
            ((zzXzh)object3).zzWwL(new zzVPB());
            ((zzXzh)object3).zzYHI().zzWz3().zzZgA(this.zzWfu);
            object2 = new zzWt5();
            ((zzeW)object2).zzWWH(new zzvm(this.zzWfu.zzYxM(), ""));
            ((zzeW)object2).zzWwL(new zzM0());
            ((zzZxH)object3).zzWwL((zzeW)object2);
            shape.zzYYW(75);
            shape.zzW1m((zzZxH)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzWfu, 75);
        }
        if (zzWZb.zzXqP(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzWwL((byte[])object, new zzVT2(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzVT2(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzWZb.zzzm((byte[])object2));
                this.zzWwL((zzXzh)shape.zzRP(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXzh)shape.zzRP()).zzYHI().zzWz3().zzX8F((byte[])object);
            object3 = zzWZb.zzZIA(object);
            object4 = new zzVT2(((zzXin)object3).getWidthPoints(), ((zzXin)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzWwL(this.zzYAC());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzWZb.zzX3K(object)) {
            d5 = DocumentBuilder.zzWwL(shape, object);
        }
        shape.zzWwL(d3, d4, (zzVT2)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzWwL(Shape shape, byte[] byArray) throws Exception {
        int n = zzWZb.zzWYd(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYUC.zzVPn(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYUC.zzWDX(n);
        return d;
    }

    private void zzWwL(zzXzh zzXzh2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXzh2.zzYHI().zzWz3().getExtensions();
        try (zzXLX zzXLX2 = new zzXLX(byArray);){
            object = zzYUC.zzWwL(zzXLX2, this.zzWfu);
            ((zzXbz)object).zzY7R(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzXbz)object).zzYgt();
            byArray2 = ((zzXbz)object).zzZCZ(true);
        }
        zzXzh2.zzYHI().zzWz3().setExtensions(new zzVPx<zzZYL>());
        object = zzZYL.zzWwL(byArray2, this.zzWfu);
        zzXzh2.zzYHI().zzWz3().getExtensions().zzWAh(((zzZYL)object).getUri(), (zzZYL)object);
    }

    private Shape zzWwL(zzXlS zzXlS2, String string, boolean bl, zzXlS zzXlS3) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzXt1(string);
        Shape shape = this.zzWwL(zzXlS3, bl, zzZ5b2, null);
        zzXr0 zzXr02 = zzYFq.zzWwL(zzXlS2, string, bl);
        return DocumentBuilder.zzWwL(null, false, shape, zzZ5b2.zzZWX, zzXr02);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWwL(zzXlS.zzWWH(stream), progId, asIcon, zzXlS.zzWWH(presentation));
    }

    private Shape zzWwL(String string, boolean bl, boolean bl2, zzXlS zzXlS2) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzWoD(zzW4n.zzZk5(string));
        return this.zzWwL(string, bl, bl2, zzXlS2, zzZ5b2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWwL(fileName, isLinked, asIcon, zzXlS.zzWWH(presentation));
    }

    private Shape zzWwL(String string, String string2, boolean bl, boolean bl2, zzXlS zzXlS2) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzXt1(string2);
        return this.zzWwL(string, bl, bl2, zzXlS2, zzZ5b2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWwL(fileName, progId, isLinked, asIcon, zzXlS.zzWWH(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzWoD(zzW4n.zzZk5(fileName));
        return this.zzWwL(fileName, isLinked, iconFile, iconCaption, zzZ5b2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzXt1(progId);
        return this.zzWwL(fileName, isLinked, iconFile, iconCaption, zzZ5b2);
    }

    private Shape zzWwL(zzXlS zzXlS2, String string, String string2, String string3) throws Exception {
        zzZ5b zzZ5b2 = zzZ5b.zzXt1(string);
        Shape shape = this.zzWwL(string2, string3, zzZ5b2);
        zzXr0 zzXr02 = zzYFq.zzWwL(zzXlS2, string, true);
        return DocumentBuilder.zzWwL(null, false, shape, zzZ5b2.zzZWX, zzXr02);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWwL(zzXlS.zzWWH(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWwL(zzZIV zzZIV2, zzXlS zzXlS2) throws Exception {
        Shape shape = this.zzX8N(zzXlS2);
        shape.zzYYW(201);
        shape.getOleFormat().zzWWH(zzZIV2.zzXOP());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzWaH();
        if (this.zzZuK()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzdV(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzek zzek2 = zzYUC.zzWwL(html, options, this);
        zzek2.zzYuP();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzWaH();
        return zzYUC.zzWwL(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzWaH();
        return zzYUC.zzWwL(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZL1 zzZL12 = new zzZL1();
        return zzZL12.zzWwL(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXiC(this).zzWwL(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXiC(this).zzWwL(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWfu, 75);
        shape.zzWwL(this.zzYAC());
        shape.zz01(true);
        shape.getSignatureLine().zzWwL(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYC1(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZhW(this.zzWfu);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZuK() {
        boolean bl = false;
        if (this.zzoo().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzoo().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzdV(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzWaH();
        if (this.zzXYC() == null) {
            this.startTable();
        }
        if (this.zzXYC().zzWbw() == 1) {
            this.zzXYC().zzWGH();
        }
        if (this.zzXYC().zzWbw() == 3) {
            this.zzXYC().zzVUA();
        }
        return this.zzXYC().zzWrz();
    }

    public Table startTable() {
        this.zzYpB.push(new zzJR(this));
        return this.zzXYC().startTable();
    }

    public Table endTable() {
        if (this.zzXYC() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXYC().endTable();
        this.zzYpB.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXYC() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXYC().endRow();
        if (this.zzWyL != null && this.zzWyL.getHidden()) {
            row.zzWs6().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWfu, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWfu, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW8I();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWfu, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzVYx();
        bookmarkStart.zzZgh(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW8I();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzVYx();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWfu, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYZz(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWfu);
        this.zzYCg = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzYCg == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWfu, this.zzYCg);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWfu, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWQY.zzWWH((Object)importFormatOptions, "ImportFormatOptions");
        this.zzWaH();
        return zzYn2.zzWwL(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzWfu;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWfu) {
            return;
        }
        this.zzWfu = value;
        this.zzYWr(null);
        this.zzWQ0 = new zzWC2();
        this.zzYqM = null;
        this.zzWe6 = null;
        this.zzWyL = null;
        this.zzYpB = new zzYfj();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzWyL == null) {
            DocumentBuilder documentBuilder = this;
            this.zzWyL = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzWyL;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzB0 == null) {
            this.zzB0 = new RowFormat(this);
        }
        return this.zzB0;
    }

    public CellFormat getCellFormat() {
        if (this.zzXOU == null) {
            this.zzXOU = new CellFormat(this);
        }
        return this.zzXOU;
    }

    final void zzZuP(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWC2 zzWC22 = this.getCurrentParagraph().zzXVq();
        this.zzY6g().push(new zzWwL(this.zzYAC(), (zzWC2)zzWC22.zzW1Z()));
    }

    public void popFont() {
        zzYfj<zzWwL> zzYfj2 = this.zzY6g();
        if (zzYfj2.size() > 0) {
            zzWwL zzWwL2 = (zzWwL)this.zzY6g().pop();
            this.zzWwL(zzWwL2.zzWBc(), false);
            this.getCurrentParagraph().zzXRg(zzWwL2.zzSR());
        }
    }

    final void zzBI() {
        this.zzXyz().push(this.zzYAC());
    }

    final void zzqL() {
        zzYfj<zzWC2> zzYfj2 = this.zzXyz();
        if (zzYfj2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWwL((zzWC2)documentBuilder.zzXyz().pop(), false);
        }
    }

    final void zzXkw() {
        this.zzWTH().push(this.zzWzk());
    }

    final void zzYv5() {
        zzYfj<zzXdF> zzYfj2 = this.zzWTH();
        if (zzYfj2.size() > 0) {
            this.getCurrentParagraph().zzWwL((zzXdF)this.zzWTH().pop());
        }
    }

    final zzWH7 zzWWH(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWti(88);
        zzY8J zzY8J2 = new zzY8J();
        zzY8J2.setTarget(string2);
        zzY8J2.setScreenTip(string3);
        if (bl) {
            zzY8J2.setSubAddress(string);
        } else {
            zzY8J2.setAddress(zzX6I.zzZgO(string));
            zzY8J2.setSubAddress(zzX6I.zzph(string));
        }
        this.zzW8t(zzY8J2.zzWyr());
        FieldSeparator fieldSeparator = this.zzWAs(88);
        return new zzWH7(fieldStart, fieldSeparator, null);
    }

    final zzWH7 zzZLz(String string, String string2, String string3) {
        boolean bl = zzX6I.zzXDo(string);
        String string4 = bl ? zzX6I.zzph(string) : string;
        return this.zzWWH(string4, bl, string2, string3);
    }

    final FieldEnd zzWB7() {
        return this.zzX64(88, true);
    }

    final zzWC2 zzYAC() {
        zzWC2 zzWC22 = this.zzWQ0;
        return (zzWC2)zzWC22.zzW1Z();
    }

    final zzXdF zzWzk() {
        if (this.getCurrentParagraph() != null) {
            zzXdF zzXdF2 = this.getCurrentParagraph().zzVWb();
            return (zzXdF)zzXdF2.zzW1Z();
        }
        Paragraph paragraph = null;
        if (this.isAtEndOfStructuredDocumentTag()) {
            paragraph = (Paragraph)this.getCurrentStructuredDocumentTag().getChild(8, -1, true);
        }
        if (paragraph == null) {
            paragraph = zzYUC.zzY1u(this.zzoo());
        }
        if (paragraph != null) {
            zzXdF zzXdF3 = paragraph.zzVWb();
            return (zzXdF)zzXdF3.zzW1Z();
        }
        return new zzXdF();
    }

    final zzYxJ zz8n() {
        zzYxJ zzYxJ2 = this.zzWs6();
        return (zzYxJ)zzYxJ2.zzW1Z();
    }

    final zzBM zzZ19() {
        zzBM zzBM2 = this.zzZEf();
        return (zzBM)zzBM2.zzW1Z();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzoo(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzoo().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzZF7 && this.zzoo().getNodeType() == 28;
    }

    private void zzXT(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzoo()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzYp5.zzXwc(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXEN(string2.substring(n4, n4 + n2));
                }
                switch (this.zzW1l) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZHO(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXEN(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzWaH();
        if (this.zzXYC() != null && this.zzXYC().zzWbw() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzoo().getParentNode().insertBefore(node, this.zzoo());
    }

    final void zzZBQ(int n) {
        this.zzYOE(true);
        this.zzZT2(n);
    }

    private void zzZT2(int n) {
        this.insertParagraph();
        zzYm6 zzYm62 = new zzYm6(this.getDocument());
        try {
            zzXbW zzXbW2 = this.getCurrentSection().zzWsS();
            zzXbW zzXbW3 = (zzXbW)zzXbW2.zzW1Z();
            Section section = new Section(this.zzWfu, zzXbW3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWfu));
            this.zzWfu.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWWH(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYm62.dispose();
        }
    }

    final FieldStart zzWti(int n) {
        this.zzWaH();
        return zzYUC.zzWwL(n, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzW8t(String string) {
        return zzYUC.zzWWH(string, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzX64(int n, boolean bl) {
        return zzYUC.zzWWH(n, bl, this.zzYAC(), this.zzoo(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzWAs(int n) {
        return zzYUC.zzWWH(n, this.zzYAC(), this.zzoo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZsX(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWfu, new zzXL4(), this.zzYAC());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYOE(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXYC() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZah(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXEN(String string) {
        if (this.zz6Y(string)) {
            zzXml zzXml2 = new zzXml(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzWFX zzWFX2 : zzXml2.zzXs4(this.getParagraphFormat().getBidi())) {
                zzZsX zzZsX2 = zzZsX.zzBM(zzWFX2.zzZgi());
                zzWC2 zzWC22 = this.zzYAC();
                zzWC22.zzZLz(265, zzZsX2);
                if (zzWFX2.zzYMU()) {
                    zzWC22.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWfu, zzWFX2.getText(), zzWC22);
                this.insertNode(run);
            }
            return;
        }
        this.zzZHO(string);
    }

    private boolean zz6Y(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXR5.zzZq4(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWwL(zzWC2 zzWC22, boolean bl) {
        zzWC2 zzWC23;
        if (bl) {
            zzWC2 zzWC24 = zzWC22;
            zzWC23 = (zzWC2)zzWC24.zzW1Z();
        } else {
            zzWC23 = zzWC22;
        }
        this.zzWQ0 = zzWC23;
    }

    final void zzZ0B() {
        this.zzWQ0.clear();
    }

    final void zzZ5() {
        if (this.zzW8I() != null) {
            zzBM zzBM2;
            zzBM zzBM3 = zzBM2 = this.zzW8I().zzZEf();
            this.zzZk9 = (zzBM)zzBM3.zzW1Z();
            zzBM2.zzWWH(this.zzZk9);
        }
    }

    private Shape zzWwL(String string, boolean bl, boolean bl2, zzXlS zzXlS2, zzZ5b zzZ5b2) throws Exception {
        if (zzZ5b2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWwL(zzXlS2, bl2, zzZ5b2, string);
        zzXr0 zzXr02 = zzYFq.zzWwL(string, bl, bl2, zzZ5b2);
        return DocumentBuilder.zzWwL(string, bl, shape, zzZ5b2.zzZWX, zzXr02);
    }

    private Shape zzWwL(String string, boolean bl, String string2, String string3, zzZ5b zzZ5b2) throws Exception {
        if (zzZ5b2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzW4n.zzWqd(string);
        }
        Shape shape = string2 != null ? this.zzWHn(string2, string3) : this.zzWwL(null, string3, zzZ5b2);
        zzXr0 zzXr02 = zzYFq.zzWwL(string, bl, true, zzZ5b2);
        return DocumentBuilder.zzWwL(string, bl, shape, zzZ5b2.zzZWX, zzXr02);
    }

    private static Shape zzWwL(String string, boolean bl, Shape shape, String string2, zzXr0 zzXr02) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzYYW(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWWH(zzXr02);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWwL(zzXlS zzXlS2, boolean bl, zzZ5b zzZ5b2, String string) throws Exception {
        if (zzZ5b2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXlS2 != null) {
            return this.zzX8N(zzXlS2);
        }
        if (!bl) {
            return this.zzY2J(zzYFq.zzOX().get("normal"));
        }
        String string2 = string != null ? zzW4n.zzWqd(string) : zzYFq.zzYcY(zzZ5b2.zzYmw);
        return this.zzWwL(zzZ5b2, string2);
    }

    private Shape zzWwL(String string, String string2, zzZ5b zzZ5b2) throws Exception {
        if (zzZ5b2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYFq.zzYcY(zzZ5b2.zzYmw);
        }
        if (string != null) {
            return this.zzWHn(string, string2);
        }
        return this.zzWwL(zzZ5b2, string2);
    }

    private Shape zzWwL(zzZ5b zzZ5b2, String string) throws Exception {
        if (zzZ5b2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYFq.zzXwV(zzZ5b2.zzYmw);
        zzXs7 zzXs72 = new zzXs7(byArray, null, string, this.getDocument().zzWdK());
        return this.zzY2J(zzXs72.zzW71());
    }

    private Shape zzWHn(String string, String string2) throws Exception {
        zzXs7 zzXs72 = new zzXs7(string, string2, this.getDocument().zzWdK());
        return this.zzY2J(zzXs72.zzW71());
    }

    private Shape zzX8N(zzXlS zzXlS2) throws Exception {
        byte[] byArray = zzWQY.zzW1m(zzXlS2);
        return this.zzY2J(byArray);
    }

    private Shape zzY2J(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWfu, 1);
        shape.zzYYW(75);
        shape.zzWwL(this.zzYAC());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYC1(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzWwL(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWWH(compositeNode, n);
            return;
        }
        this.zzZgA(compositeNode, n);
    }

    private void zzWWH(CompositeNode compositeNode, int n) {
        zzZ0L zzZ0L2 = zzZ0L.zzZbf(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzZ0L2.zzWwL(null, true, true, true, false, true);
            node = zzZ0L2.getNode();
            if (zzZ0L2.zzXV6() && (!node.isComposite() || node.zzWTV() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYEz().length() : node.getTextLength();
            if (!zzZ0L2.zzXV6() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzZ0L2.zzXV6() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzWwL((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzWwL(null, node);
            this.zzWgn = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzWwL(StructuredDocumentTag structuredDocumentTag) {
        this.zzYWr(structuredDocumentTag);
        this.zzZF7 = true;
        this.zzWgn = 0;
        zzWC2 zzWC22 = structuredDocumentTag.zzY8Q();
        switch (structuredDocumentTag.zzWTV()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzWzb(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzWC22 = ((Inline)node).zzWBc();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzWC22 = paragraph.zzXVq();
                break;
            }
            default: {
                return;
            }
        }
        this.zzWwL(zzWC22, true);
    }

    private void zzZgA(CompositeNode compositeNode, int n) {
        zzZ0L zzZ0L2 = zzZ0L.zzF1(compositeNode);
        while (zzZ0L2.getNode() != compositeNode || !zzZ0L2.zzXV6()) {
            int n2;
            Node node = zzZ0L2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYEz().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzWwL(null, node);
                this.zzWgn = n;
                return;
            }
            while (zzZ0L2.zzWwL(null, false, true, true, false, true) && zzZ0L2.zzXV6() && zzZ0L2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzWaH() {
        int n = this.zzWgn;
        if (n == 0) {
            return;
        }
        this.zzWgn = 0;
        Run run = zzWQY.zzWwL((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzYf6(n);
        }
    }

    private Run zzZHO(String string) {
        Run run = new Run(this.zzWfu, string, this.zzYAC());
        this.insertNode(run);
        return run;
    }

    final boolean zz1O() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzXHe() {
        return this.zzW1l;
    }

    final void zzWhX(int n) {
        this.zzW1l = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzoo();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzoo();
        }
        return (Paragraph)this.zzoo().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzoo();
        }
        return (StructuredDocumentTag)this.zzoo().getAncestor(28);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzJR zzXYC() {
        zzYfj<zzJR> zzYfj2 = this.zzYpB;
        if (zzYfj2.size() > 0) {
            return (zzJR)this.zzYpB.peek();
        }
        return null;
    }

    private Cell zzW8I() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzY0n();
    }

    private zzYfj<zzWC2> zzXyz() {
        if (this.zzYqM == null) {
            this.zzYqM = new zzYfj();
        }
        return this.zzYqM;
    }

    private zzYfj<zzXdF> zzWTH() {
        if (this.zzWe6 == null) {
            this.zzWe6 = new zzYfj();
        }
        return this.zzWe6;
    }

    private zzYfj<zzWwL> zzY6g() {
        if (this.zzVOK == null) {
            this.zzVOK = new zzYfj();
        }
        return this.zzVOK;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWQ0.zzYN1(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzKu(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzKu(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWQ0.zzZLz(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZQC()) {
            this.getCurrentParagraph().zzXVq().zzZLz(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWQ0.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWQ0.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZQC()) {
            this.getCurrentParagraph().zzXVq().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWs6().zzYN1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWs6().zzXWX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWs6().zzWwI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWs6().zzZLz(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWs6().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWs6().clear();
        zzYxJ.zzZF5().zzWWH(this.zzWs6());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZEf().zzYN1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZEf().zzXWX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZEf().zzWwI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWQY.zzWwL(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzW8I() != null ? this.zzW8I().getCellFormat() : this.getCellFormat();
            border.zzWwL(cellFormat);
        }
        this.zzZEf().zzZLz(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZEf().clear();
    }

    private Node zzoo() {
        Node node = this.zz0A != null && this.zz0A.getParentNode() == null ? this.zzYkP : this.zz0A;
        if (node != null && node.zzWTV() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzZF7 = this.zzZF7 && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYWr(Node node) {
        this.zz0A = node;
        if (this.zz0A != null) {
            this.zzYkP = this.zz0A.getParentNode();
        }
        this.zzZF7 = false;
    }

    private zzYxJ zzWs6() {
        if (this.zzXYC() != null && this.zzXYC().zzWbw() == 1) {
            return this.zzZTq;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWs6();
        }
        return this.zzZTq;
    }

    private zzBM zzZEf() {
        if (this.zzXYC() != null && this.zzXYC().zzWbw() != 3) {
            return this.zzZk9;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzY0n().zzZEf();
        }
        return this.zzZk9;
    }

    static final class zzWwL {
        private zzWC2 zzWQ0;
        private zzWC2 zzVSr;

        public zzWwL(zzWC2 zzWC22, zzWC2 zzWC23) {
            this.zzWQ0 = zzWC22;
            this.zzVSr = zzWC23;
        }

        public final zzWC2 zzWBc() {
            return this.zzWQ0;
        }

        public final zzWC2 zzSR() {
            return this.zzVSr;
        }
    }
}

