/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzXlS;
import com.aspose.words.internal.zzYOh;
import com.aspose.words.internal.zzYfl;
import com.aspose.words.internal.zzZ6K;
import com.aspose.words.internal.zzZO4;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYs0;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzai = new HashMap();
    private static HashMap<Integer, Integer> zzY0P = new HashMap();
    private static HashMap<Integer, Integer> zzZm4 = new HashMap();
    private static HashMap<Integer, Integer> zzZj3 = new HashMap();
    private static HashMap<Integer, Integer> zzXqZ = new HashMap();
    private static HashMap<Integer, Integer> zzWMb = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWQY.zzWWH(fileName, "fileName");
        try (zzZ6K zzZ6K2 = zzWQY.zzYZl(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzX21(zzZ6K2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzX21(zzYOh.zzWwL(stream));
    }

    static FileFormatInfo zzX21(zzXlS zzXlS2) throws Exception {
        if (zzXlS2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzYs0 zzYs02 = new zzYs0();
            zzXlS zzXlS3 = zzXlS2;
            zzYs0 zzYs03 = zzYs02;
            return zzYs02.zzWWH(zzXlS3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZgA(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzGA(zzYfl.zzY1u(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzVQM(zzYfl.zzY1u(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZO4.zzWO(string = zzYfl.zzWSR(FileFormatUtil.zzYPE(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzGA(FileFormatUtil.zzZ8N(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzVQM(FileFormatUtil.zzYPE(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYfl.zzWSR(FileFormatUtil.zzZ8N(saveFormat));
        if (zzZO4.zzWO(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzVQM(zzYfl.zzZnP(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYfl.zzWSR(FileFormatUtil.zzVWe(imageType));
    }

    static Exception zzZgA(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzaJ(int n) {
        return zzYfl.toString(FileFormatUtil.zzZ8N(n));
    }

    static int zzVQM(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWQY.zzWwL(zzXqZ, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY5(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWQY.zzWwL(zzWMb, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzX7S(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYPE(int n) {
        return zzWQY.zzWwL(zzai, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZ8N(int n) {
        return zzWQY.zzWwL(zzY0P, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzVWe(int n) {
        return zzWQY.zzWwL(zzZm4, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzGA(int n) {
        return zzWQY.zzWwL(zzZj3, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzB3(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWQY.zzWWH(zzXqZ, Integer.valueOf(n), Integer.valueOf(n2));
            zzWQY.zzWWH(zzY0P, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZj3.containsKey(n)) {
                zzWQY.zzWWH(zzZj3, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWQY.zzWWH(zzai, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWQY.zzWWH(zzWMb, Integer.valueOf(n), Integer.valueOf(n4));
            zzWQY.zzWWH(zzZm4, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzB3(11, 10, 10, 1);
        FileFormatUtil.zzB3(11, 0, 0, 1);
        FileFormatUtil.zzB3(12, 11, 11, 1);
        FileFormatUtil.zzB3(13, 20, 20, 1);
        FileFormatUtil.zzB3(13, 0, 254, 1);
        FileFormatUtil.zzB3(14, 21, 21, 1);
        FileFormatUtil.zzB3(15, 22, 22, 1);
        FileFormatUtil.zzB3(16, 23, 23, 1);
        FileFormatUtil.zzB3(18, 24, 24, 1);
        FileFormatUtil.zzB3(19, 25, 25, 1);
        FileFormatUtil.zzB3(20, 26, 26, 1);
        FileFormatUtil.zzB3(21, 27, 27, 1);
        FileFormatUtil.zzB3(24, 30, 30, 1);
        FileFormatUtil.zzB3(17, 31, 31, 1);
        FileFormatUtil.zzB3(25, 50, 50, 1);
        FileFormatUtil.zzB3(26, 45, 255, 1);
        FileFormatUtil.zzB3(27, 51, 51, 1);
        FileFormatUtil.zzB3(28, 0, 52, 1);
        FileFormatUtil.zzB3(29, 0, 53, 1);
        FileFormatUtil.zzB3(31, 53, 54, 1);
        FileFormatUtil.zzB3(22, 60, 60, 1);
        FileFormatUtil.zzB3(23, 61, 61, 1);
        FileFormatUtil.zzB3(34, 40, 64, 1);
        FileFormatUtil.zzB3(41, 47, 255, 1);
        FileFormatUtil.zzB3(42, 48, 255, 1);
        FileFormatUtil.zzB3(35, 41, 255, 1);
        FileFormatUtil.zzB3(36, 46, 255, 1);
        FileFormatUtil.zzB3(38, 42, 255, 1);
        FileFormatUtil.zzB3(37, 44, 255, 1);
        FileFormatUtil.zzB3(30, 52, 55, 1);
        FileFormatUtil.zzB3(32, 70, 62, 1);
        FileFormatUtil.zzB3(33, 73, 63, 1);
        FileFormatUtil.zzB3(39, 71, 255, 1);
        FileFormatUtil.zzB3(8, 100, 255, 1);
        FileFormatUtil.zzB3(9, 105, 255, 1);
        FileFormatUtil.zzB3(6, 101, 255, 6);
        FileFormatUtil.zzB3(7, 102, 255, 7);
        FileFormatUtil.zzB3(5, 104, 255, 5);
        FileFormatUtil.zzB3(4, 0, 255, 4);
        FileFormatUtil.zzB3(3, 0, 255, 3);
        FileFormatUtil.zzB3(40, 72, 255, 1);
        FileFormatUtil.zzB3(2, 103, 255, 2);
    }
}

