/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYOh;
import com.aspose.words.zzWo6;
import com.aspose.words.zzXjI;
import com.aspose.words.zzY9z;
import com.aspose.words.zzYDn;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWo6,
Iterable<T> {
    private Node zzbJ;
    private CompositeNode zzY5z;
    private DocumentBase zzhz;
    private boolean zzXHI;
    private int zzYtX;
    private int zzYQc;
    private Node zzLn;
    private int zzZpo;
    private zzY9z zzZVM;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzYDn.zzWiL(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzYDn(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzY9z matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzY5z = container;
        this.zzhz = container.getDocument();
        this.zzZVM = matcher;
        this.zzXHI = isDeep;
        this.zzZrX();
    }

    public Node get(int index) {
        try {
            this.zzVTq();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYQc == index) {
                return this.zzLn;
            }
            int n = index - this.zzYQc;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzZuu(nodeCollection.zzLn, n);
            if (node != null) {
                this.zzYQc = index;
                this.zzLn = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzXHI) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzY5z.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzXHI) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzY5z.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzzS();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXjI(this);
    }

    final <TNode extends Node> zzXjI<TNode> zzZhG() {
        return new zzXjI(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzzS() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYOh.zzWwL(arrayList, node);
        }
        return arrayList;
    }

    private Node zzZuu(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzYqc(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYWr(curNode, true);
    }

    private Node zzYWr(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzbJ = node;
        do {
            node2 = this.zzbJ;
            Node node3 = this.zzXHI ? this.zzWwL(true, this.zzbJ) : (this.zzbJ = this.zzZVM.zzXeY() ? this.zzZgA(true, this.zzbJ) : this.zzWWH(true, this.zzbJ));
        } while (this.zzbJ != null && !this.zzZVM.zzZuu(this.zzbJ));
        return node2;
    }

    private Node zzYqc(Node node, boolean bl) throws Exception {
        while ((this.zzXHI ? this.zzWwL(bl, node) : (node = this.zzZVM.zzXeY() ? this.zzZgA(bl, node) : this.zzWWH(bl, node))) != null && !this.zzZVM.zzZuu(node)) {
        }
        return node;
    }

    private Node zzWwL(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzY5z);
        }
        return node.previousPreOrder(this.zzY5z);
    }

    private Node zzWWH(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzY5z) {
                return this.zzY5z.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzY5z) {
            return this.zzY5z.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZgA(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzY5z ? this.zzY5z.zzYjD() : node.zzZ5C();
        } else {
            Node node3 = node2 = node == this.zzY5z ? this.zzY5z.zzWLc() : node.zzZBb();
        }
        if (node2 == this.zzY5z.getNextSibling() || node2 == this.zzY5z.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzVTq() {
        if (this.zzYtX != this.zzW74()) {
            this.zzZrX();
        }
    }

    private void zzZrX() {
        this.zzYtX = this.zzW74();
        this.zzYQc = -1;
        this.zzLn = this.zzY5z;
        this.zzZpo = -1;
    }

    private int zzW74() {
        if (this.zzhz != null) {
            return this.zzhz.zzVRc();
        }
        return 0;
    }

    public int getCount() {
        this.zzVTq();
        if (this.zzZpo == -1) {
            this.zzZpo = zzXjI.zzWwL(this);
        }
        return this.zzZpo;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzbJ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzY5z;
    }
}

