/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzW4n;
import com.aspose.words.internal.zzYfl;

public abstract class SaveOptions {
    private boolean zzYTD;
    boolean zzWDi = false;
    boolean zzZ15 = true;
    private IDocumentSavingCallback zzXGo;
    private boolean zzYTC = true;
    private boolean zzWu5 = false;
    private boolean zzMb;
    private boolean zzYKt = true;
    private boolean zzWbu;
    private String zzXfd;
    private boolean zzZOY;
    private boolean zzX4c = false;
    private int zzYQs = 1;
    private int zzWic = 1;
    private int zzZZD = 0;
    private String zzW6b = "";
    private boolean zzZpZ = true;
    private boolean zzYZE = true;
    private boolean zzZ7J;
    private boolean zzW9u;
    private int zzZoO = 0;
    private boolean zzEn = true;
    private boolean zzX3g = false;

    protected SaveOptions() {
    }

    final boolean zzY0V() {
        return this.zzMb;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZjY() {
        return false;
    }

    boolean zzwi() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYKt;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYKt = value;
    }

    public String getTempFolder() {
        return this.zzXfd;
    }

    public void setTempFolder(String value) {
        this.zzXfd = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWbu;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWbu = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZOY;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZOY = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzX4c;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzX4c = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzWDi;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzWDi = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYQs;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYQs = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZZD;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZZD = value;
    }

    public int getImlRenderingMode() {
        return this.zzWic;
    }

    public void setImlRenderingMode(int value) {
        this.zzWic = value;
    }

    public String getDefaultTemplate() {
        return this.zzW6b;
    }

    public void setDefaultTemplate(String value) {
        this.zzW6b = value;
    }

    public boolean getUpdateFields() {
        return this.zzZpZ;
    }

    public void setUpdateFields(boolean value) {
        this.zzZpZ = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZ7J;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZ7J = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzW9u;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzW9u = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzX3g;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzX3g = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzWu5;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzWu5 = value;
    }

    final boolean zzXje() {
        return this.zzYZE;
    }

    final boolean zzXqQ() {
        return this.zzEn;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzVQM(zzYfl.zzZnP(zzW4n.zzZk5(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzZoO;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzZoO = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzXGo;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzXGo = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzYTD;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzYTD = value;
    }

    final boolean zzA6() {
        return this.zzYTC;
    }
}

