/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzWlC;
import com.aspose.words.zzFS;
import com.aspose.words.zzVZC;
import com.aspose.words.zzXbW;

public final class Section
extends CompositeNode<Node>
implements zzFS {
    private zzXbW zzXMQ;
    private PageSetup zzpD;
    private HeaderFooterCollection zzWUW;

    public Section(DocumentBase doc) {
        this(doc, new zzXbW());
    }

    Section(DocumentBase doc, zzXbW sectPr) {
        super(doc);
        this.zzXMQ = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzWUW == null) {
            this.zzWUW = new HeaderFooterCollection(this);
        }
        return this.zzWUW;
    }

    public final PageSetup getPageSetup() {
        if (this.zzpD == null) {
            Section section = this;
            this.zzpD = new PageSetup(section, section.getDocument().zzZo1(), this.getDocument().getStyles(), new zzWwL(this));
        }
        return this.zzpD;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZ1w();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYhf(!value);
    }

    final zzXbW zzWsS() {
        return this.zzXMQ;
    }

    final void zzZgA(zzXbW zzXbW2) {
        this.zzXMQ = zzXbW2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWwL(boolean bl, zzVZC zzVZC2) {
        zzXbW zzXbW2;
        Section section = (Section)super.zzWwL(bl, zzVZC2);
        zzXbW zzXbW3 = this.zzXMQ;
        section.zzXMQ = zzXbW2 = (zzXbW)zzXbW3.zzW1Z();
        section.zzpD = null;
        section.zzWUW = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWwL(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzWWH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzY4i(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzY4i(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYpx(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzXgW(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYpx(n) == null;
            }
        }
        return false;
    }

    final void zzZgA(Shape shape, boolean bl) throws Exception {
        this.zzWwL(shape, 4, bl);
        this.zzWwL(shape, 0, bl);
        this.zzWwL(shape, 1, bl);
    }

    private void zzWwL(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzYxM());
        shape2.setName(zzWlC.zzWWH("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzVVI() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWe2()) {
                if (!shape.zzXKW()) continue;
                shape.remove();
            }
        }
    }

    private void zzY4i(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWWH(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXMQ.zzYN1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZo1().zzZCE.zzXWX(key);
        }
        return zzXbW.zzZDt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXMQ.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZo1().zzZCE.zzZLz(key, value);
            return;
        }
        this.zzXMQ.zzZLz(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXMQ.clear();
    }

    final boolean zzXag() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZRj() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzWwL
    implements zzFS {
        private Section zzZjl;

        zzWwL(Section section) {
            this.zzZjl = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZeO().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZeO().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZeO().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzFS zzZeO() {
            Document document = zzWQY.zzWwL((Object)this.zzZjl.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZjl;
        }
    }
}

