/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWAQ;
import com.aspose.words.internal.zzWQY;
import com.aspose.words.internal.zzWUi;
import com.aspose.words.internal.zzWiQ;
import com.aspose.words.internal.zzWlC;
import com.aspose.words.internal.zzYf2;
import com.aspose.words.internal.zzZO4;
import com.aspose.words.zzSt;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWfu;
    private zzSt zzYsU;

    Watermark(Document doc, zzSt watermarkProvider) {
        this.zzWfu = doc;
        this.zzYsU = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZpA(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWwL(text, textWatermarkOptions, this.zzWfu);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWQY.zzWWH((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWfu, 75);
        shape.getImageData().setImage(image);
        this.zzWwL(shape, options, this.zzWfu);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWQY.zzWWH((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWfu, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWwL(shape, options, this.zzWfu);
    }

    public final int getType() {
        Shape shape = this.zzYsU.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXKW();
        if (shape.zzYhM()) {
            return 0;
        }
        if (shape.zzVc()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzYsU.add(shape);
    }

    public final void remove() {
        this.zzYsU.remove();
    }

    private static void zzZpA(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzZO4.zzYk9(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWQY.zzWwL(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWwL(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWWH(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWAh(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWWH(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzYkP() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYUJ()) / d2) > (double)(f = pageSetup.zzYsE())) {
            d = (double)f / d3;
        }
        shape.zzVTi(zzWiQ.zzZgA(d2 * d, 2, zzWAQ.zzXG9));
        shape.zzXDo(zzWiQ.zzZgA(d3 * d, 2, zzWAQ.zzXG9));
    }

    private Shape zzWwL(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWwL(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWAh(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWwL(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYUb() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYf2 zzYf22 = document.zzWdK().zzZgA(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYf22.zzZq4(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYUb()) {
            l = Watermark.zzWwL(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzVTi(zzWiQ.zzZgA(Float.intBitsToFloat(n), 2, zzWAQ.zzXG9));
        shape.zzXDo(zzWiQ.zzZgA(zzWUi.zzXVT(l), 2, zzWAQ.zzXG9));
    }

    private static long zzWwL(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYUJ();
        float f2 = pageSetup.zzYsE();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWUi.zzXVT(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWUi.zzMj(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWUi.zzXVT(l) >= Float.intBitsToFloat(n)) {
            return zzWUi.zzMj(f2 / f3, f2);
        }
        float f6 = f;
        return zzWUi.zzMj(f6, f6 * f3);
    }

    private static void zzWAh(Shape shape, String string) {
        shape.setName(zzWlC.zzWWH("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

