/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzJb;
import com.aspose.words.internal.zzWx2;
import com.aspose.words.internal.zzX2O;
import com.aspose.words.internal.zzXAJ;
import com.aspose.words.internal.zzYqd;
import com.aspose.words.internal.zzYuN;
import com.aspose.words.internal.zzZ42;
import com.aspose.words.internal.zzZZ9;
import com.aspose.words.internal.zzZym;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzX9A
extends CertPathBuilderSpi {
    private final zzYqd zzWpi;
    private zzZZ9 zzWrD;

    zzX9A(zzYqd zzYqd2) {
        this.zzWpi = zzYqd2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzYuN pkixParams;
        if (params instanceof zzYuN) {
            pkixParams = (zzYuN)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzYuN.zzWwL((PKIXBuilderParameters)params).zzY0o();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzYuN.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzX2O zzX2O2 = pkixParams.zzYFv().zzZMs();
        try {
            collection = zzZ42.zzWwL(zzX2O2, pkixParams.zzYFv().zzZv6());
            collection.addAll(zzZ42.zzWwL(zzX2O2, pkixParams.zzYFv().zzVXm()));
        }
        catch (zzZZ9 zzZZ92) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZZ92);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzWwL(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWrD != null) {
            throw new CertPathBuilderException(this.zzWrD.getMessage(), this.zzWrD.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzWwL(X509Certificate x509Certificate, zzYuN zzYuN2, List list) throws CertPathBuilderException {
        zzZym zzZym2;
        zzWx2 zzWx22;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzYuN2.zz9d().contains(x509Certificate)) {
            return null;
        }
        if (zzYuN2.zzWi5() != -1 && list.size() - 1 > zzYuN2.zzWi5()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzWx22 = new zzWx2(this.zzWpi);
            zzZym2 = new zzZym(this.zzWpi);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZ42.zzWwL(x509Certificate, zzYuN2.zzYFv().zz3B(), zzYuN2.zzYFv().zzIz()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzWx22.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZZ9("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZym2.engineValidate(certPath, zzYuN2);
                }
                catch (Exception exception) {
                    throw new zzZZ9("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzJb> arrayList = new ArrayList<zzJb>();
            arrayList.addAll(zzYuN2.zzYFv().zzZv6());
            try {
                arrayList.addAll(zzZ42.zzWwL(x509Certificate.getExtensionValue(zzXAJ.zzYau.getId()), zzYuN2.zzYFv().zzWrB()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZZ9("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZ42.zzWwL(x509Certificate, zzYuN2.zzYFv().zzVXm(), arrayList));
            }
            catch (zzZZ9 zzZZ92) {
                throw new zzZZ9("Cannot find issuer certificate for certificate in certification path.", zzZZ92);
            }
            if (hashSet.isEmpty()) {
                throw new zzZZ9("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzWwL(x509Certificate2, zzYuN2, list);
            }
        }
        catch (zzZZ9 zzZZ93) {
            this.zzWrD = zzZZ93;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

