/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWlC;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW1m;
import com.aspose.words.net.System.Data.zzY4i;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzZIN;
    private final DataTable zzVSC;
    private final AtomicInteger zzoF;

    ConstraintCollection(DataTable table) {
        this.zzVSC = table;
        this.zzoF = new AtomicInteger(1);
        this.zzZIN = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzWlC.zzW8(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzZIN) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzZIN.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzXx2()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzXx2()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzWwL(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzWZa());
        }
        constraint.zzWwL(this);
        this.zzZIN.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzVSC.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzZIN.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzZIN.contains(cc);
    }

    public int getCount() {
        return this.zzZIN.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzZIN.iterator();
    }

    final DataTable getTable() {
        return this.zzVSC;
    }

    final List<ForeignKeyConstraint> zzWay() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzZIN) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzWwL(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzZIN) {
            if (constraint instanceof UniqueConstraint) {
                this.zzWwL((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzWwL((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzWwL(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzZIN) {
            if (constraint2.equals(constraint) || zzWlC.zzWAh(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzWZa() {
        return "Constraint" + this.zzoF.getAndIncrement();
    }

    private void zzWwL(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzW1m zzW1m2 = this.zzVSC.zzXsd().zzY4i(uniqueConstraint.getColumns());
        Map<String, Object> map = zzW1m2.zzWAh(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzWlC.zzWWH("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzWwL(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzVSC.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzVSC.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzVSC.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzVSC.getTableName())) {
            return;
        }
        if (!ConstraintCollection.zzWWH(foreignKeyConstraint, dataRow)) {
            DataTable dataTable = foreignKeyConstraint.getRelatedTable();
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
            DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
            object = dataTable;
            if (!zzY4i.zzWwL(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                    stringBuilder.append(zzWlC.zzWWH("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
                }
                throw new InvalidConstraintException(stringBuilder.toString());
            }
        }
    }

    private static boolean zzWWH(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) {
        boolean bl = false;
        for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
            Object object = dataRow.get(dataColumn);
            if (object == null || object == DBNull.Value) continue;
            bl = true;
            break;
        }
        return !bl;
    }
}

