/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWlC;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXaK = new ArrayList();
    private final Map<String, DataColumn> zzX2s = new HashMap<String, DataColumn>();
    private DataTable zzVSC;

    DataColumnCollection(DataTable table) {
        this.zzVSC = table;
    }

    public void add(DataColumn column) {
        if (zzWlC.zzW8(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzXCA(column.getColumnName());
        if (this.zzX2s.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzY4i(this.zzVSC);
        column.setOrdinal(this.zzXaK.size());
        this.zzXaK.add(column);
        this.zzX2s.put(string, column);
        this.zzVSC.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzVSC);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzVSC);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWlC.zzW8(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzXCA(columnName);
        DataColumn dataColumn = this.zzX2s.get(string);
        if (dataColumn != null) {
            int n = this.zzXaK.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXaK.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXaK.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXaK.remove(n);
            this.zzX2s.remove(DataColumnCollection.zzXCA(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzVSC.getRows()) {
                dataRow.remove(n);
            }
            this.zzVSC.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzXaK.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXaK.iterator();
    }

    public void clear() {
        this.zzX2s.clear();
        this.zzXaK.clear();
    }

    final DataColumn[] zzXL7() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXaK);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWwL(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXaK.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXaK.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzXCA(string);
            String string3 = DataColumnCollection.zzXCA(dataColumn.getColumnName());
            this.zzX2s.remove(string3);
            this.zzX2s.put(string2, dataColumn);
            return;
        }
    }

    private static String zzXCA(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

