/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzKT;
import com.aspose.words.internal.zzWlC;
import com.aspose.words.internal.zzYBa;
import com.aspose.words.internal.zzYOh;
import com.aspose.words.internal.zzYcY;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzWWH;
import com.aspose.words.net.System.Data.zzY4i;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzVSC;
    private Object[] zzYFC;
    private int zzXWg = 1;
    private int zzYfp;
    private String zzWNT;
    private Map<String, Object> zzaP = new HashMap<String, Object>();
    private Map<String, String> zzYef = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzVSC = table;
        this.zzYFC = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzYFC, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzWWH.zzZgA(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzVSC.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzVSC.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzVSC;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzVSC.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzVSC.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzVSC.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzVSC.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzVSC.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzVSC.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzVSC) {
            throw new IllegalStateException(zzWlC.zzWWH("Table {0} is not the child table in the relation {1}", this.zzVSC.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzWwL(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzdI(columnIndex, value);
        this.zzVSC.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzVSC.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzXWg;
    }

    public void setRowState(int state) {
        this.zzXWg = state;
    }

    public void delete() {
        zzY4i.zzWWH(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzaP.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzaP.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzYFC.length];
        System.arraycopy(this.zzYFC, 0, objectArray, 0, this.zzYFC.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzYFC.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzYFC.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzdI(i, array[i]);
        }
        this.zzVSC.onDataRowChanged(this);
    }

    final int zzZd6() {
        return this.zzYfp;
    }

    final void zzoA(String string, String string2) {
        this.zzYef.put(string, string2);
    }

    final void zzkf(String string, String string2) {
        this.zzWNT = zzWlC.zzWWH(string, string2);
    }

    final String zzX2X() {
        return this.zzWNT;
    }

    final void zzYf5(int n) {
        this.zzYfp = n;
    }

    final Object[] zzX7() {
        return this.zzYFC;
    }

    static boolean zzWwL(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzY08(index)) {
            return null;
        }
        return this.zzYFC[index];
    }

    private void zzdI(int n, Object object) {
        if (!this.zzY08(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzWwL((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzWwL((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzWwL(clazz, object)))));
        this.zzYFC[n] = object2;
    }

    private static Object zzWwL(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        try {
            if (clazz == String.class) {
                return string;
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzYcY.class) {
                return zzYcY.zzWwL(string, zzYBa.zzXJW(), 128).zzQG();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzKT.zzZgA(exception);
        }
        return object;
    }

    private boolean zzY08(int n) {
        this.zzwo();
        return this.zzYFC != null && n >= 0 && n < this.zzYFC.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzVSC.getColumns().getCount();
        if (this.zzYFC.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzYFC.length - 1];
        System.arraycopy(this.zzYFC, 0, objectArray, 0, index);
        System.arraycopy(this.zzYFC, index + 1, objectArray, index, this.zzYFC.length - index - 1);
        this.zzYFC = objectArray;
    }

    private void zzwo() {
        if (this.zzVSC == null || this.zzVSC.getColumns() == null || this.zzYFC == null) {
            return;
        }
        int n = this.zzVSC.getColumns().getCount();
        if (this.zzYFC.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzYFC.length];
        System.arraycopy(this.zzYFC, 0, objectArray, 0, this.zzYFC.length);
        this.zzYFC = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzYFC.length);
        System.arraycopy(objectArray, 0, this.zzYFC, 0, n2);
        for (int i = n2; i < this.zzYFC.length; ++i) {
            this.zzYFC[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzWwL(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block13: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block13;
            byte[] byArray2 = byArray;
            if (inputStream == null) return byArray2;
            try {
                inputStream.close();
                return byArray2;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                zzKT.zzZgA(iOException);
            }
            return byArray2;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzYOh.zzWwL(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzKT.zzZgA(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzKT.zzZgA(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException3 = iOException;
                    zzKT.zzZgA(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzKT.zzZgA(iOException);
            }
            return byArray;
        }
    }

    private static String zzWwL(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzKT.zzZgA(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzKT.zzZgA(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.getTable().getTableName() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzYFC;
        int n = dataRow.zzYFC.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

