/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzKT;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW1m;
import com.aspose.words.net.System.Data.zzWWH;
import com.aspose.words.net.System.Data.zzXQ0;
import com.aspose.words.net.System.Data.zzZgA;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZH5;
    private final DataColumnCollection zzRy;
    private final ConstraintCollection zzOV;
    private final zzXQ0 zzW0b;
    private ResultSet zzYXE;
    private String zzXxv;
    private DataSet zzYqn;
    private String zzm5;
    private UniqueConstraint zz9j;
    private boolean zzXHM;
    private final List<DataTableEventListener> zzXoa;
    private final Set<DataRow> zzOO;
    private DataRelationCollection zzW6R;

    public DataTable() {
        this.zzZH5 = new DataRowCollection(this);
        this.zzRy = new DataColumnCollection(this);
        this.zzOV = new ConstraintCollection(this);
        this.zzW0b = new zzXQ0(this);
        this.zzm5 = "";
        this.zzXHM = true;
        this.zzXoa = new ArrayList<DataTableEventListener>();
        this.zzOO = new HashSet<DataRow>();
        this.zzW6R = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZH5 = new DataRowCollection(this);
        this.zzRy = new DataColumnCollection(this);
        this.zzOV = new ConstraintCollection(this);
        this.zzW0b = new zzXQ0(this);
        this.zzm5 = "";
        this.zzXHM = true;
        this.zzXoa = new ArrayList<DataTableEventListener>();
        this.zzOO = new HashSet<DataRow>();
        this.zzW6R = new DataRelationCollection();
        this.zzXxv = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWWH.zzWwL(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZH5 = new DataRowCollection(this);
        this.zzRy = new DataColumnCollection(this);
        this.zzOV = new ConstraintCollection(this);
        this.zzW0b = new zzXQ0(this);
        this.zzm5 = "";
        this.zzXHM = true;
        this.zzXoa = new ArrayList<DataTableEventListener>();
        this.zzOO = new HashSet<DataRow>();
        this.zzW6R = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYXE = resultSet;
        this.zzXxv = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYXE != null) {
            if (this.zzYXE.getStatement() != null) {
                this.zzYXE.getStatement().getConnection().close();
            }
            this.zzYXE = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXxv;
    }

    public void setTableName(String tableName) {
        this.zzXxv = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzRy.getCount();
    }

    public String getColumnName(int index) {
        return this.zzRy.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYXE;
    }

    public DataSet getDataSet() {
        return this.zzYqn;
    }

    final void zzY4i(DataSet dataSet) {
        this.zzYqn = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzYqn.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzW6R.add(dataRelation);
        }
        return this.zzW6R;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYqn.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZH5;
    }

    public DataColumnCollection getColumns() {
        return this.zzRy;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzOV;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zz9j == null) {
            return new DataColumn[0];
        }
        return this.zz9j.getColumns();
    }

    final void zzXQ0(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zz9j != null) {
                this.zz9j.zzXxG(false);
                this.getConstraints().remove(this.zz9j);
                this.zz9j = null;
            }
            return;
        }
        if (this.zz9j != null && DataColumn.areColumnSetsTheSame(value, this.zz9j.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWwL(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zz9j != null) {
            this.zz9j.zzXxG(false);
            this.getConstraints().remove(this.zz9j);
            this.zz9j = null;
        }
        UniqueConstraint.zzWwL(this.getConstraints(), uniqueConstraint);
        this.zz9j = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzm5;
    }

    public void setNamespace(String namespace) {
        this.zzm5 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXHM;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXHM = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzOO.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWWH.zzWwL(this.getResultSet(), this);
            zzWWH.zzWWH(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzKT.zzY4i(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWWH.zzWAh(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXoa.contains(listener)) {
            this.zzXoa.add(listener);
        }
    }

    public void removeEventListener(zzZgA listener) {
        if (this.zzXoa.contains(listener)) {
            this.zzXoa.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXoa.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzOO.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXoa) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzOO.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXoa) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzOO.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXoa) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXoa) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXoa) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzW1m zzWwL(zzWWH[] zzWWHArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzWWHArray.length];
        for (int i = 0; i < zzWWHArray.length; ++i) {
            dataColumnArray[i] = zzWWHArray[i].zzZkj();
        }
        DataTable dataTable = this;
        zzW1m zzW1m2 = dataTable.zzW0b.zzY4i(dataColumnArray);
        if (zzW1m2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzW1m2;
    }

    final zzXQ0 zzXsd() {
        return this.zzW0b;
    }

    final Set<DataRow> zzES() {
        return this.zzOO;
    }
}

