/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.zzW3K;
import com.aspose.words.zzY0q;
import com.aspose.words.zzYds;
import com.aspose.words.zzZT1;
import com.aspose.words.zzZTI;
import com.aspose.words.zzZZr;
import com.aspose.words.zzlD;
import com.aspose.words.zzsj;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzW3K,
Iterable<T> {
    private Node zzWc1;
    private Node zzUa;
    private Node zzWvZ;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzYCO((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWrH() {
        return this.zzMP() != null;
    }

    final boolean zzYuR() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWaT() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzY0q) {
                return true;
            }
            CompositeNode compositeNode = zzYkh.zzab((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWaT()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzWc1;
    }

    public Node getLastChild() {
        return this.zzUa;
    }

    final Node zzMP() {
        return zzZTI.zzXAg(this.getFirstChild(), false);
    }

    final Node zzJw() {
        return zzZTI.zzYeB(this.getLastChild(), false);
    }

    final CompositeNode zzZzu() {
        return (CompositeNode)zzZTI.zzXAg(this.getFirstChild(), true);
    }

    final CompositeNode zzal() {
        return (CompositeNode)zzZTI.zzYeB(this.getLastChild(), true);
    }

    final Node zzn() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzZTI.zzY0J((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXa6() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzZTI.zzY0J((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzab(boolean bl, zzZZr zzZZr2) {
        CompositeNode compositeNode = (CompositeNode)super.zzab(bl, zzZZr2);
        ((CompositeNode)super.zzab(bl, zzZZr2)).zzUa = null;
        compositeNode.zzWc1 = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzW19(node.zzab(true, zzZZr2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzY8T(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzY8T(StringBuilder stringBuilder) {
        this.zzX7v(stringBuilder);
        zzYkh.zzYCO(stringBuilder, this.zzYie());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYCO(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzZTI.zziL(nodeType);
            Node node2 = node = bl ? this.zzMP() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzXbi() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzlD.zzzD(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzlD.zzWpk(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZT1(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzab(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzab(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzYCO(oldChild, false);
    }

    private Node zzYCO(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzab(node, (Node)this, null, 1);
        if (documentBase.zzYnM() && zzZTI.zzYBf(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzab(nodeChangingArgs);
        }
        if (!bl && zzZTI.zzYvI(node)) {
            zzZTI.zzXcf(node, false);
        }
        Node node2 = this.zzYTJ(node);
        if (nodeChangingArgs != null) {
            documentBase.zzYCO(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzYds.zzVXt(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzW19(Node node) {
        node.getParentNode();
        if (this.zzUa == null) {
            node.zzVWQ(null);
            node.zzWNc(null);
            this.zzWc1 = node;
        } else {
            node.zzVWQ(this.zzUa);
            node.zzWNc(null);
            this.zzUa.zzWNc(node);
        }
        this.zzUa = node;
        node.zzX9W(this);
        return node;
    }

    final void zzab(Node node, Node node2, Node node3) {
        this.zzab(node, node2, node3, false);
    }

    final void zzab(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzVQt(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYCO(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzzD(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzZTI.zzY0J(node3.getNodeType())) continue;
            if (zzZTI.zzYP9(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYie().length();
    }

    String zzYie() {
        return "";
    }

    final String zzoC() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzX7v(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzX7v(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzY8T(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzab(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYCO(visitor));
    }

    abstract int zzab(DocumentVisitor var1) throws Exception;

    abstract int zzYCO(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzVQt(Node var1);

    final Node zzab(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYVR(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzVQt(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzsj(documentBase);
            try {
                compositeNode.zzYCO(node, true);
            }
            finally {
                ((zzsj)object).dispose();
            }
        }
        if ((object = documentBase.zzab(node, null, (Node)this, 0)) != null) {
            documentBase.zzab((NodeChangingArgs)object);
        }
        if (this.zzUa == null) {
            node.zzVWQ(null);
            node.zzWNc(null);
            this.zzWc1 = node;
            this.zzUa = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYCO(node, node2);
            } else {
                this.zzzD(node, this.zzWc1);
            }
        } else if (node2 != null) {
            this.zzzD(node, node2);
        } else {
            this.zzYCO(node, this.zzUa);
        }
        node.zzX9W(this);
        if (object != null) {
            documentBase.zzYCO((NodeChangingArgs)object);
        }
        if (documentBase.zzYnM()) {
            zzZTI.zzab(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYCO(Node node, Node node2) {
        Node node3 = node2.zzYUC();
        node.zzVWQ(node2);
        node.zzWNc(node3);
        node2.zzWNc(node);
        if (node3 == null) {
            this.zzUa = node;
            return;
        }
        node3.zzVWQ(node);
    }

    private void zzzD(Node node, Node node2) {
        Node node3 = node2.zzZ3m();
        node.zzVWQ(node3);
        node.zzWNc(node2);
        node2.zzVWQ(node);
        if (node3 == null) {
            this.zzWc1 = node;
            return;
        }
        node3.zzWNc(node);
    }

    private Node zzYTJ(Node node) {
        if (node == this.zzWc1) {
            if (this.zzWc1 == this.zzUa) {
                this.zzWc1 = null;
                this.zzUa = null;
            } else {
                this.zzWc1 = node.zzYUC();
                this.zzWc1.zzVWQ(null);
            }
        } else {
            Node node2 = node.zzZ3m();
            Node node3 = node.zzYUC();
            node2.zzWNc(node3);
            if (node3 == null) {
                this.zzUa = node2;
            } else {
                node3.zzVWQ(node2);
            }
        }
        node.zzWNc(null);
        node.zzVWQ(null);
        node.zzX9W(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzWvZ = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWvZ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

