/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzUD;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXN6;
import com.aspose.words.net.System.Data.zzXl0;
import com.aspose.words.net.System.Data.zzYMQ;
import com.aspose.words.net.System.Data.zzYeh;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXqq;
    private final DataColumnCollection zzXXZ;
    private final ConstraintCollection zzzK;
    private final zzXN6 zzWaC;
    private ResultSet zzl8;
    private String zzXvg;
    private DataSet zzZyH;
    private String zzB2;
    private UniqueConstraint zzYoC;
    private boolean zzYJc;
    private final List<DataTableEventListener> zzXL5;
    private final Set<DataRow> zzXnh;
    private DataRelationCollection zzWoL;

    public DataTable() {
        this.zzXqq = new DataRowCollection(this);
        this.zzXXZ = new DataColumnCollection(this);
        this.zzzK = new ConstraintCollection(this);
        this.zzWaC = new zzXN6(this);
        this.zzB2 = "";
        this.zzYJc = true;
        this.zzXL5 = new ArrayList<DataTableEventListener>();
        this.zzXnh = new HashSet<DataRow>();
        this.zzWoL = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXqq = new DataRowCollection(this);
        this.zzXXZ = new DataColumnCollection(this);
        this.zzzK = new ConstraintCollection(this);
        this.zzWaC = new zzXN6(this);
        this.zzB2 = "";
        this.zzYJc = true;
        this.zzXL5 = new ArrayList<DataTableEventListener>();
        this.zzXnh = new HashSet<DataRow>();
        this.zzWoL = new DataRelationCollection();
        this.zzXvg = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYMQ.zzXDP(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXqq = new DataRowCollection(this);
        this.zzXXZ = new DataColumnCollection(this);
        this.zzzK = new ConstraintCollection(this);
        this.zzWaC = new zzXN6(this);
        this.zzB2 = "";
        this.zzYJc = true;
        this.zzXL5 = new ArrayList<DataTableEventListener>();
        this.zzXnh = new HashSet<DataRow>();
        this.zzWoL = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzl8 = resultSet;
        this.zzXvg = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzl8 != null) {
            if (this.zzl8.getStatement() != null) {
                this.zzl8.getStatement().getConnection().close();
            }
            this.zzl8 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXvg;
    }

    public void setTableName(String tableName) {
        this.zzXvg = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXXZ.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXXZ.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzl8;
    }

    public DataSet getDataSet() {
        return this.zzZyH;
    }

    final void zzWOR(DataSet dataSet) {
        this.zzZyH = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZyH.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWoL.add(dataRelation);
        }
        return this.zzWoL;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZyH.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXqq;
    }

    public DataColumnCollection getColumns() {
        return this.zzXXZ;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzzK;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYoC == null) {
            return new DataColumn[0];
        }
        return this.zzYoC.getColumns();
    }

    final void zzXN6(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYoC != null) {
                this.zzYoC.zzYrY(false);
                this.getConstraints().remove(this.zzYoC);
                this.zzYoC = null;
            }
            return;
        }
        if (this.zzYoC != null && DataColumn.areColumnSetsTheSame(value, this.zzYoC.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXDP(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYoC != null) {
            this.zzYoC.zzYrY(false);
            this.getConstraints().remove(this.zzYoC);
            this.zzYoC = null;
        }
        UniqueConstraint.zzXDP(this.getConstraints(), uniqueConstraint);
        this.zzYoC = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzB2;
    }

    public void setNamespace(String namespace) {
        this.zzB2 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzYJc;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzYJc = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXnh.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYMQ.zzXDP(this.getResultSet(), this);
            zzYMQ.zzYMQ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzUD.zzWOR(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYMQ.zzWtP(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXL5.contains(listener)) {
            this.zzXL5.add(listener);
        }
    }

    public void removeEventListener(zzYeh listener) {
        if (this.zzXL5.contains(listener)) {
            this.zzXL5.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXL5.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXnh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXL5) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXnh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXL5) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXnh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXL5) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXL5) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXL5) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXl0 zzXDP(zzYMQ[] zzYMQArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYMQArray.length];
        for (int i = 0; i < zzYMQArray.length; ++i) {
            dataColumnArray[i] = zzYMQArray[i].zzYHQ();
        }
        DataTable dataTable = this;
        zzXl0 zzXl02 = dataTable.zzWaC.zzWOR(dataColumnArray);
        if (zzXl02 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXl02;
    }

    final zzXN6 zzWnN() {
        return this.zzWaC;
    }

    final Set<DataRow> zzZ8Q() {
        return this.zzXnh;
    }
}

