/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.conn;

import com.luhuiguo.fastdfs.conn.Connection;
import com.luhuiguo.fastdfs.exception.FdfsConnectException;
import com.luhuiguo.fastdfs.proto.mapper.BytesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnection
implements Connection {
    private Socket socket;
    private Charset charset;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnection.class);

    public DefaultConnection(InetSocketAddress address, int soTimeout, int connectTimeout, Charset charset) {
        try {
            this.socket = new Socket();
            this.socket.setSoTimeout(soTimeout);
            LOGGER.debug("connect to {} soTimeout={} connectTimeout={}", new Object[]{address, soTimeout, connectTimeout});
            this.charset = charset;
            this.socket.connect(address, connectTimeout);
        }
        catch (IOException e) {
            throw new FdfsConnectException("can't create connection to" + address, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        LOGGER.debug("disconnect from {}", (Object)this.socket);
        byte[] header = new byte[10];
        Arrays.fill(header, (byte)0);
        byte[] hex_len = BytesUtil.long2buff(0L);
        System.arraycopy(hex_len, 0, header, 0, hex_len.length);
        header[8] = 82;
        header[9] = 0;
        try {
            this.socket.getOutputStream().write(header);
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.error("close connection error", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Socket)this.socket);
        }
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isValid() {
        LOGGER.debug("check connection status of {} ", (Object)this);
        try {
            byte[] header = new byte[10];
            Arrays.fill(header, (byte)0);
            byte[] hex_len = BytesUtil.long2buff(0L);
            System.arraycopy(hex_len, 0, header, 0, hex_len.length);
            header[8] = 111;
            header[9] = 0;
            this.socket.getOutputStream().write(header);
            if (this.socket.getInputStream().read(header) != header.length) {
                return false;
            }
            return header[9] == 0;
        }
        catch (IOException e) {
            LOGGER.error("valid connection error", (Throwable)e);
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

