/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.domain;

import com.luhuiguo.fastdfs.exception.FdfsUnsupportStorePathException;
import com.luhuiguo.fastdfs.proto.mapper.DynamicFieldType;
import com.luhuiguo.fastdfs.proto.mapper.FdfsColumn;
import org.apache.commons.lang3.Validate;

public class StorePath {
    @FdfsColumn(index=0, max=16)
    private String group;
    @FdfsColumn(index=1, dynamicField=DynamicFieldType.allRestByte)
    private String path;
    private static final String SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR = "/";
    private static final String SPLIT_GROUP_NAME = "group";

    public StorePath() {
    }

    public StorePath(String group, String path) {
        this.group = group;
        this.path = path;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFullPath() {
        return this.group.concat(SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR).concat(this.path);
    }

    public String toString() {
        return "StorePath [group=" + this.group + ", path=" + this.path + "]";
    }

    public static StorePath praseFromUrl(String filePath) {
        Validate.notNull((Object)filePath, (String)"\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        int groupStartPos = StorePath.getGroupStartPos(filePath);
        String groupAndPath = filePath.substring(groupStartPos);
        int pos = groupAndPath.indexOf(SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR);
        if (pos <= 0 || pos == groupAndPath.length() - 1) {
            throw new FdfsUnsupportStorePathException("\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u9519\u8bef,\u6709\u6548\u7684\u8def\u5f84\u6837\u5f0f\u4e3a(group/path) \u800c\u5f53\u524d\u89e3\u6790\u8def\u5f84\u4e3a".concat(filePath));
        }
        String group = groupAndPath.substring(0, pos);
        String path = groupAndPath.substring(pos + 1);
        return new StorePath(group, path);
    }

    private static int getGroupStartPos(String filePath) {
        int pos = filePath.indexOf(SPLIT_GROUP_NAME);
        if (pos == -1) {
            throw new FdfsUnsupportStorePathException("\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u9519\u8bef,\u88ab\u89e3\u6790\u8def\u5f84url\u6ca1\u6709group,\u5f53\u524d\u89e3\u6790\u8def\u5f84\u4e3a".concat(filePath));
        }
        return pos;
    }
}

