/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.proto;

import com.luhuiguo.fastdfs.exception.FdfsServerException;
import com.luhuiguo.fastdfs.proto.mapper.BytesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ProtoHead {
    private static final int HEAD_LENGTH = 10;
    private long contentLength = 0L;
    private byte cmd;
    private byte status = 0;

    public long getContentLength() {
        return this.contentLength;
    }

    public byte getCmd() {
        return this.cmd;
    }

    public byte getStatus() {
        return this.status;
    }

    public ProtoHead(byte cmd) {
        this.cmd = cmd;
    }

    public ProtoHead(long contentLength, byte cmd, byte status) {
        this.contentLength = contentLength;
        this.cmd = cmd;
        this.status = status;
    }

    public byte[] toByte() {
        byte[] header = new byte[10];
        Arrays.fill(header, (byte)0);
        byte[] hex_len = BytesUtil.long2buff(this.contentLength);
        System.arraycopy(hex_len, 0, header, 0, hex_len.length);
        header[8] = this.cmd;
        header[9] = this.status;
        return header;
    }

    public static ProtoHead createFromInputStream(InputStream ins) throws IOException {
        byte[] header = new byte[10];
        int bytes = ins.read(header);
        if (bytes != header.length) {
            throw new IOException("recv package size " + bytes + " != " + header.length);
        }
        long returnContentLength = BytesUtil.buff2long(header, 0);
        byte returnCmd = header[8];
        byte returnStatus = header[9];
        return new ProtoHead(returnContentLength, returnCmd, returnStatus);
    }

    public boolean validateResponseHead() throws IOException {
        if (this.cmd != 100) {
            throw new IOException("recv cmd: " + this.cmd + " is not correct, expect cmd: " + 100);
        }
        if (this.status != 0) {
            throw FdfsServerException.byCode(this.status);
        }
        if (this.contentLength < 0L) {
            throw new IOException("recv body length: " + this.contentLength + " < 0!");
        }
        return true;
    }

    public String toString() {
        return "ProtoHead [contentLength=" + this.contentLength + ", cmd=" + this.cmd + ", status=" + this.status + "]";
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }
}

