/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.service;

import com.luhuiguo.fastdfs.conn.ConnectionManager;
import com.luhuiguo.fastdfs.domain.FileInfo;
import com.luhuiguo.fastdfs.domain.MetaData;
import com.luhuiguo.fastdfs.domain.StorageNode;
import com.luhuiguo.fastdfs.domain.StorageNodeInfo;
import com.luhuiguo.fastdfs.domain.StorePath;
import com.luhuiguo.fastdfs.proto.storage.DownloadByteArray;
import com.luhuiguo.fastdfs.proto.storage.DownloadCallback;
import com.luhuiguo.fastdfs.proto.storage.StorageDeleteFileCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageDownloadCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageGetMetadataCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageQueryFileInfoCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageSetMetadataCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageUploadFileCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageUploadSlaveFileCommand;
import com.luhuiguo.fastdfs.proto.storage.enums.StorageMetdataSetType;
import com.luhuiguo.fastdfs.service.GenerateStorageClient;
import com.luhuiguo.fastdfs.service.TrackerClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerateStorageClient
implements GenerateStorageClient {
    protected TrackerClient trackerClient;
    protected ConnectionManager connectionManager;
    protected static Logger LOGGER = LoggerFactory.getLogger(DefaultGenerateStorageClient.class);

    public DefaultGenerateStorageClient(TrackerClient trackerClient, ConnectionManager connectionManager) {
        this.trackerClient = trackerClient;
        this.connectionManager = connectionManager;
    }

    @Override
    public StorePath uploadFile(String groupName, InputStream inputStream, long fileSize, String fileExtName) {
        StorageNode client = this.trackerClient.getStoreStorage(groupName);
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public StorePath uploadSlaveFile(String groupName, String masterFilename, InputStream inputStream, long fileSize, String prefixName, String fileExtName) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, masterFilename);
        StorageUploadSlaveFileCommand command = new StorageUploadSlaveFileCommand(inputStream, fileSize, masterFilename, prefixName, fileExtName);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public Set<MetaData> getMetadata(String groupName, String path) {
        StorageNodeInfo client = this.trackerClient.getFetchStorage(groupName, path);
        StorageGetMetadataCommand command = new StorageGetMetadataCommand(groupName, path);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void overwriteMetadata(String groupName, String path, Set<MetaData> metaDataSet) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageSetMetadataCommand command = new StorageSetMetadataCommand(groupName, path, metaDataSet, StorageMetdataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void mergeMetadata(String groupName, String path, Set<MetaData> metaDataSet) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageSetMetadataCommand command = new StorageSetMetadataCommand(groupName, path, metaDataSet, StorageMetdataSetType.STORAGE_SET_METADATA_FLAG_MERGE);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public FileInfo queryFileInfo(String groupName, String path) {
        StorageNodeInfo client = this.trackerClient.getFetchStorage(groupName, path);
        StorageQueryFileInfoCommand command = new StorageQueryFileInfoCommand(groupName, path);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void deleteFile(String groupName, String path) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageDeleteFileCommand command = new StorageDeleteFileCommand(groupName, path);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public <T> T downloadFile(String groupName, String path, DownloadCallback<T> callback) {
        long fileOffset = 0L;
        long fileSize = 0L;
        return this.downloadFile(groupName, path, fileOffset, fileSize, callback);
    }

    @Override
    public <T> T downloadFile(String groupName, String path, long fileOffset, long fileSize, DownloadCallback<T> callback) {
        StorageNodeInfo client = this.trackerClient.getFetchStorage(groupName, path);
        StorageDownloadCommand<T> command = new StorageDownloadCommand<T>(groupName, path, 0L, 0L, callback);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    public void setTrackerClientService(TrackerClient trackerClientService) {
        this.trackerClient = trackerClientService;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public StorePath uploadFile(String groupName, byte[] content, String fileExtName) {
        return this.uploadFile(groupName, new ByteArrayInputStream(content), content.length, fileExtName);
    }

    @Override
    public byte[] downloadFile(String groupName, String path) {
        return this.downloadFile(groupName, path, new DownloadByteArray());
    }
}

