/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.aspect;

import com.alibaba.fastjson2.JSON;
import com.luixtech.springbootframework.config.LuixProperties;
import com.luixtech.springbootframework.utils.TraceIdUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@ConditionalOnProperty(value={"luix.aop-logging.enabled"})
@Configuration
public class AopLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(AopLoggingAspect.class);
    private static final String UNKNOWN_ARG_VAL = "UNKNOWN";
    private final LuixProperties luixProperties;

    @AfterThrowing(pointcut="within(@org.springframework.web.bind.annotation.RestController *)", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        this.getLogger(joinPoint).error("Exception in {}() with cause = '{}' and exception = '{}'", new Object[]{joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL", e.getMessage()});
    }

    @Around(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public Object logController(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
        HttpServletResponse response = servletRequestAttributes != null ? servletRequestAttributes.getResponse() : null;
        TraceIdUtils.setTraceId(request);
        this.beforeRun(joinPoint);
        Object result = joinPoint.proceed();
        TraceIdUtils.setTraceId(response);
        this.afterRun(joinPoint, result);
        TraceIdUtils.remove();
        return result;
    }

    public void beforeRun(ProceedingJoinPoint joinPoint) {
        if (this.enablePrint(joinPoint)) {
            return;
        }
        String[] paramNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        Object[] arguments = joinPoint.getArgs();
        HashMap<String, String> validParamMap = new HashMap<String, String>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            String argVal = UNKNOWN_ARG_VAL;
            if (this.isValidArgument(arguments[i])) {
                try {
                    argVal = JSON.toJSONString((Object)arguments[i]);
                }
                catch (Exception ex) {
                    log.warn("Failed to serialize argument!");
                }
            }
            validParamMap.put(paramNames[i], argVal);
        }
        this.getLogger((JoinPoint)joinPoint).info("Enter method {}() with argument[s] = {}", (Object)joinPoint.getSignature().getName(), validParamMap);
    }

    private boolean isValidArgument(Object argument) {
        return !(argument instanceof ServletRequest) && !(argument instanceof ServletResponse) && !(argument instanceof MultipartFile);
    }

    private void afterRun(ProceedingJoinPoint joinPoint, Object result) {
        if (this.enablePrint(joinPoint)) {
            return;
        }
        this.getLogger((JoinPoint)joinPoint).info("Exit method {}() with result = {}", (Object)joinPoint.getSignature().getName(), result);
    }

    private boolean enablePrint(ProceedingJoinPoint joinPoint) {
        return !this.getLogger((JoinPoint)joinPoint).isInfoEnabled() || !this.matchLogMethod(joinPoint);
    }

    private boolean matchLogMethod(ProceedingJoinPoint joinPoint) {
        if (!this.luixProperties.getAopLogging().isMethodBlacklistMode()) {
            return true;
        }
        String method = joinPoint.getSignature().getDeclaringType().getSimpleName() + "." + joinPoint.getSignature().getName();
        return !this.luixProperties.getAopLogging().getMethodBlacklist().contains(method);
    }

    private Logger getLogger(JoinPoint joinPoint) {
        return LoggerFactory.getLogger((String)joinPoint.getSignature().getDeclaringTypeName());
    }

    public AopLoggingAspect(LuixProperties luixProperties) {
        this.luixProperties = luixProperties;
    }
}

