/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.aspect;

import com.luixtech.springbootframework.config.LuixProperties;
import jakarta.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@ConditionalOnProperty(value={"luix.elapsed-time-logging.enabled"})
@Configuration
public class ElapsedTimeLoggingAspect {
    private static final String HEADER_KEY = "X-ELAPSED";
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private final LuixProperties luixProperties;

    @Around(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public Object logController(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletResponse response;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Object result = joinPoint.proceed();
        stopWatch.stop();
        long elapsed = stopWatch.getTotalTimeMillis();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse httpServletResponse = response = servletRequestAttributes != null ? servletRequestAttributes.getResponse() : null;
        if (response != null) {
            if (elapsed < 1000L) {
                response.setHeader(HEADER_KEY, elapsed + "ms");
            } else if (elapsed < 60000L) {
                response.setHeader(HEADER_KEY, elapsed / 1000L + "s");
            } else {
                response.setHeader(HEADER_KEY, elapsed / 60000L + "m");
            }
        }
        this.outputLog(joinPoint, elapsed);
        return result;
    }

    @Around(value="within(@org.springframework.stereotype.Service *)")
    public Object logService(ProceedingJoinPoint joinPoint) throws Throwable {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Object result = joinPoint.proceed();
        stopWatch.stop();
        long elapsed = stopWatch.getTotalTimeMillis();
        this.outputLog(joinPoint, elapsed);
        return result;
    }

    private void outputLog(ProceedingJoinPoint joinPoint, long elapsed) {
        if (elapsed > (long)this.luixProperties.getElapsedTimeLogging().getSlowExecutionThreshold()) {
            if (elapsed < 1000L) {
                this.getLogger((JoinPoint)joinPoint).warn("Found long running method {}() in {}ms", (Object)joinPoint.getSignature().getName(), (Object)elapsed);
            } else if (elapsed < 60000L) {
                this.getLogger((JoinPoint)joinPoint).warn("Found long running method {}() in {}s", (Object)joinPoint.getSignature().getName(), (Object)(elapsed / 1000L));
            } else {
                this.getLogger((JoinPoint)joinPoint).warn("Found long running method {}() in {}m", (Object)joinPoint.getSignature().getName(), (Object)(elapsed / 60000L));
            }
        }
    }

    private Logger getLogger(JoinPoint joinPoint) {
        return LoggerFactory.getLogger((String)joinPoint.getSignature().getDeclaringTypeName());
    }

    public ElapsedTimeLoggingAspect(LuixProperties luixProperties) {
        this.luixProperties = luixProperties;
    }
}

