/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.async;

import com.luixtech.springbootframework.utils.TraceIdUtils;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.lang.NonNull;

public class ExceptionHandlingAsyncTaskExecutor
implements AsyncTaskExecutor,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlingAsyncTaskExecutor.class);
    private final AsyncTaskExecutor executor;

    public ExceptionHandlingAsyncTaskExecutor(AsyncTaskExecutor executor) {
        this.executor = executor;
    }

    public void execute(@NonNull Runnable task) {
        this.executor.execute(this.createWrappedRunnable(task, MDC.getCopyOfContextMap()));
    }

    @Deprecated
    public void execute(@NonNull Runnable task, long startTimeout) {
        this.executor.execute(this.createWrappedRunnable(task, MDC.getCopyOfContextMap()), startTimeout);
    }

    private <T> Callable<T> createCallable(Callable<T> task, Map<String, String> context) {
        return () -> {
            try {
                TraceIdUtils.setParentMdcToChild(context);
                Object v = task.call();
                return v;
            }
            catch (Exception e) {
                this.handle(e);
                throw e;
            }
            finally {
                TraceIdUtils.remove();
            }
        };
    }

    private Runnable createWrappedRunnable(Runnable task, Map<String, String> context) {
        return () -> {
            try {
                TraceIdUtils.setParentMdcToChild(context);
                task.run();
            }
            catch (Exception e) {
                this.handle(e);
            }
            finally {
                TraceIdUtils.remove();
            }
        };
    }

    protected void handle(Exception e) {
        log.error("Caught async task exception", (Throwable)e);
    }

    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        return this.executor.submit(this.createWrappedRunnable(task, MDC.getCopyOfContextMap()));
    }

    @NonNull
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        return this.executor.submit(this.createCallable(task, MDC.getCopyOfContextMap()));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executor instanceof InitializingBean) {
            InitializingBean bean = (InitializingBean)this.executor;
            bean.afterPropertiesSet();
        }
    }

    public void destroy() throws Exception {
        if (this.executor instanceof DisposableBean) {
            DisposableBean bean = (DisposableBean)this.executor;
            bean.destroy();
        }
    }
}

