/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.component;

import com.luixtech.springbootframework.component.MessageCreator;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component
public class HttpHeaderCreator {
    private final MessageCreator messageCreator;

    public HttpHeaders createSuccessHeader(String code, Object ... args) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Success-Message", this.getMessage(code, args));
        return headers;
    }

    private String getMessage(String code, Object ... args) {
        String message = this.messageCreator.getMessage(code, args);
        try {
            message = URLEncoder.encode(message, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot find the message code from message source properties.");
        }
        return message;
    }

    public HttpHeaderCreator(MessageCreator messageCreator) {
        this.messageCreator = messageCreator;
    }
}

