/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.component;

import com.luixtech.springbootframework.config.LuixProperties;
import com.luixtech.utilities.network.AddressUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class PrintAppInfoApplicationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PrintAppInfoApplicationRunner.class);
    private final Environment env;
    private final LuixProperties luixProperties;

    public void run(ApplicationArguments args) throws Exception {
        if (!this.luixProperties.getAppInfo().isPrintEnabled()) {
            return;
        }
        String appBanner = StreamUtils.copyToString((InputStream)new ClassPathResource("config/banner-app.txt").getInputStream(), (Charset)Charset.defaultCharset());
        log.info(appBanner, new Object[]{this.env.getProperty("spring.application.name"), "http", "127.0.0.1", this.env.getProperty("server.port"), StringUtils.defaultString((String)this.env.getProperty("server.servlet.context-path")), "http", AddressUtils.getIntranetIp(), this.env.getProperty("server.port"), StringUtils.defaultString((String)this.env.getProperty("server.servlet.context-path")), org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])this.env.getActiveProfiles()), this.env.getProperty("PID"), Charset.defaultCharset(), this.env.getProperty("logging.level.root")});
    }

    public PrintAppInfoApplicationRunner(Environment env, LuixProperties luixProperties) {
        this.env = env;
        this.luixProperties = luixProperties;
    }
}

