/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config;

import com.luixtech.springbootframework.async.ExceptionHandlingAsyncTaskExecutor;
import com.luixtech.springbootframework.async.ExceptionHandlingAsyncUncaughtExceptionHandler;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableAsync
@EnableScheduling
public class AsyncConfiguration
implements AsyncConfigurer,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AsyncConfiguration.class);
    private final TaskExecutionProperties taskExecutionProperties;
    private final TaskSchedulingProperties taskSchedulingProperties;

    @Bean(name={"asyncTaskExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.taskExecutionProperties.getPool().getCoreSize());
        executor.setMaxPoolSize(this.taskExecutionProperties.getPool().getMaxSize());
        executor.setQueueCapacity(this.taskExecutionProperties.getPool().getQueueCapacity());
        executor.setThreadNamePrefix(this.taskExecutionProperties.getThreadNamePrefix());
        log.info("Created async task executor with corePoolSize: [{}], maxPoolSize: [{}] and queueCapacity: [{}]", new Object[]{executor.getCorePoolSize(), executor.getMaxPoolSize(), this.taskExecutionProperties.getPool().getQueueCapacity()});
        return new ExceptionHandlingAsyncTaskExecutor((AsyncTaskExecutor)executor);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new ExceptionHandlingAsyncUncaughtExceptionHandler();
    }

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(this.taskSchedulingProperties.getPool().getSize());
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setErrorHandler(t -> log.error("Unexpected error occurred while executing scheduled task!", t));
        taskScheduler.setThreadNamePrefix(this.taskSchedulingProperties.getThreadNamePrefix());
        return taskScheduler;
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.setTaskExecutor((AsyncTaskExecutor)this.getAsyncExecutor());
    }

    public AsyncConfiguration(TaskExecutionProperties taskExecutionProperties, TaskSchedulingProperties taskSchedulingProperties) {
        this.taskExecutionProperties = taskExecutionProperties;
        this.taskSchedulingProperties = taskSchedulingProperties;
    }
}

