/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config.apidoc;

import com.luixtech.springbootframework.config.LuixProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.core.Ordered;

public class NamedApiCustomizer
implements OpenApiCustomizer,
Ordered {
    private int order;
    private final LuixProperties.ApiDocs apiDocsProperties;
    private final String name;
    private final String title;
    private final String description;
    private final String version;

    public NamedApiCustomizer(LuixProperties.ApiDocs apiDocsProperties, String name, String title, String description, String version, int order) {
        this.apiDocsProperties = apiDocsProperties;
        this.name = name;
        this.title = title;
        this.description = description;
        this.version = version;
        this.order = order;
    }

    public void customise(OpenAPI openAPI) {
        Contact contact = new Contact().name(this.apiDocsProperties.getContactName()).url(this.apiDocsProperties.getContactUrl()).email(this.apiDocsProperties.getContactEmail());
        openAPI.info(new Info().contact(contact).title(this.title).description(this.description).version(this.version).termsOfService(this.apiDocsProperties.getTermsOfServiceUrl()).license(new License().name(this.apiDocsProperties.getLicense()).url(this.apiDocsProperties.getLicenseUrl())));
        for (LuixProperties.ApiDocs.Server server : this.apiDocsProperties.getServers()) {
            openAPI.addServersItem(new Server().url(server.getUrl()).description(server.getDescription()));
        }
    }

    public int getOrder() {
        return this.order;
    }

    public LuixProperties.ApiDocs getApiDocsProperties() {
        return this.apiDocsProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }
}

